/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.doc.gen.core;

import com.google.common.io.Files;
import io.siddhi.doc.gen.core.utils.DocumentationUtils;
import io.siddhi.doc.gen.metadata.NamespaceMetaData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="deploy-mkdocs-github-pages", aggregator=true, defaultPhase=LifecyclePhase.INSTALL)
public class MkdocsGitHubPagesDeployMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject mavenProject;
    @Parameter(property="module.target.directory")
    private File moduleTargetDirectory;
    @Parameter(property="mkdocs.config.file")
    private File mkdocsConfigFile;
    @Parameter(property="doc.gen.base.directory")
    private File docGenBaseDirectory;
    @Parameter(property="home.page.file.name")
    private String homePageFileName;
    @Parameter(property="home.page.template.file")
    private File homePageTemplateFile;
    @Parameter(property="readme.file")
    private File readmeFile;
    @Parameter(property="doc.gen.base.directory")
    private boolean includeOrigin;
    @Parameter(defaultValue="${siddhi.version}", readonly=true)
    private String siddhiVersion;
    @Parameter(property="doc.gen.deploy.docs", defaultValue="true")
    private boolean deployDocs;
    @Parameter(property="doc.gen.load.from.all.jars", defaultValue="false")
    private boolean loadFromAllJars;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<NamespaceMetaData> namespaceMetaDataList;
        MavenProject rootMavenProject = this.mavenProject;
        while (rootMavenProject.getParent() != null && rootMavenProject.getParent().getBasedir() != null) {
            rootMavenProject = rootMavenProject.getParent();
        }
        String moduleTargetPath = this.moduleTargetDirectory != null ? this.moduleTargetDirectory.getAbsolutePath() : this.mavenProject.getBuild().getDirectory();
        if (this.mkdocsConfigFile == null) {
            this.mkdocsConfigFile = new File(rootMavenProject.getBasedir() + File.separator + "mkdocs" + ".yml");
        }
        String docGenBasePath = this.docGenBaseDirectory != null ? this.docGenBaseDirectory.getAbsolutePath() : rootMavenProject.getBasedir() + File.separator + "docs";
        File homePageFile = this.homePageFileName == null ? new File(docGenBasePath + File.separator + "index" + ".md") : new File(docGenBasePath + File.separator + this.homePageFileName);
        if (this.readmeFile == null) {
            this.readmeFile = new File(rootMavenProject.getBasedir() + File.separator + "README" + ".md");
        }
        if (this.homePageTemplateFile == null) {
            this.homePageTemplateFile = new File(rootMavenProject.getBasedir() + File.separator + "README" + ".md");
        }
        try {
            namespaceMetaDataList = DocumentationUtils.getExtensionMetaData(moduleTargetPath, this.mavenProject.getRuntimeClasspathElements(), this.getLog(), this.includeOrigin, this.loadFromAllJars);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoFailureException("Unable to resolve dependencies of the project", (Throwable)e);
        }
        if (namespaceMetaDataList.size() > 0) {
            DocumentationUtils.generateDocumentation(namespaceMetaDataList, docGenBasePath, this.mavenProject.getVersion(), this.getLog(), this.siddhiVersion, this.mavenProject.getGroupId());
        }
        DocumentationUtils.removeSnapshotAPIDocs(this.mkdocsConfigFile, docGenBasePath, this.getLog());
        String latestVersion = this.mavenProject.getVersion();
        try {
            latestVersion = DocumentationUtils.updateAPIPagesInMkdocsConfig(this.mkdocsConfigFile, docGenBasePath);
        }
        catch (FileNotFoundException e) {
            this.getLog().warn((CharSequence)("Unable to find mkdocs configuration file: " + this.mkdocsConfigFile.getAbsolutePath() + ". Mkdocs configuration file not updated."));
        }
        if (namespaceMetaDataList.size() > 0) {
            DocumentationUtils.updateHeadingsInMarkdownFile(this.homePageTemplateFile, homePageFile, rootMavenProject.getArtifactId(), latestVersion, namespaceMetaDataList, rootMavenProject.getGroupId(), this.siddhiVersion);
            DocumentationUtils.updateHeadingsInMarkdownFile(this.readmeFile, this.readmeFile, rootMavenProject.getArtifactId(), latestVersion, namespaceMetaDataList, rootMavenProject.getGroupId(), this.siddhiVersion);
        }
        File newVersionFile = new File(docGenBasePath + File.separator + "api" + File.separator + latestVersion + ".md");
        File latestLabelFile = new File(docGenBasePath + File.separator + "api" + File.separator + "latest" + ".md");
        try {
            Files.copy((File)newVersionFile, (File)latestLabelFile);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Failed to generate latest.md file", (Throwable)e);
        }
        if (DocumentationUtils.generateMkdocsSite(this.mkdocsConfigFile, this.getLog())) {
            if (this.deployDocs) {
                this.deployDocumentation(rootMavenProject, docGenBasePath);
            }
        } else {
            this.getLog().warn((CharSequence)"Unable to generate documentation. Skipping documentation deployment.");
        }
    }

    private void deployDocumentation(MavenProject rootMavenProject, String docGenBasePath) {
        String scmUsername = System.getenv("SCM_USERNAME");
        String scmPassword = System.getenv("SCM_PASSWORD");
        if (scmUsername == null && scmPassword == null) {
            this.getLog().info((CharSequence)"SCM_USERNAME and SCM_PASSWORD not defined!");
        }
        String url = null;
        Scm scm = rootMavenProject.getScm();
        if (scm != null) {
            url = scm.getUrl();
        }
        DocumentationUtils.updateDocumentationOnGitHub(docGenBasePath, this.mkdocsConfigFile, this.readmeFile, this.mavenProject.getVersion(), this.getLog());
        DocumentationUtils.deployMkdocsOnGitHubPages(this.mavenProject.getVersion(), rootMavenProject.getBasedir(), url, scmUsername, scmPassword, this.getLog());
    }
}

