/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FieldMatcher {
    private final String exactMatch;
    private final String globMatch;
    private final String regexMatch;
    private final String jsonMatch;
    private final String jsonPathMatch;
    private final String xmlMatch;
    private final String xpathMatch;

    @JsonCreator
    public FieldMatcher(@JsonProperty(value="exactMatch") String exactMatch, @JsonProperty(value="globMatch") String globMatch, @JsonProperty(value="regexMatch") String regexMatch, @JsonProperty(value="jsonMatch") String jsonMatch, @JsonProperty(value="jsonPathMatch") String jsonPathMatch, @JsonProperty(value="xmlMatch") String xmlMatch, @JsonProperty(value="xpathMatch") String xpathMatch) {
        this.exactMatch = exactMatch;
        this.globMatch = globMatch;
        this.jsonMatch = jsonMatch;
        this.regexMatch = regexMatch;
        this.jsonPathMatch = jsonPathMatch;
        this.xmlMatch = xmlMatch;
        this.xpathMatch = xpathMatch;
    }

    public static FieldMatcher blankMatcher() {
        return new Builder().exactMatch("").build();
    }

    public static FieldMatcher exactlyMatches(String value) {
        return new Builder().exactMatch(value).build();
    }

    public static FieldMatcher wildCardMatches(String pattern) {
        return new Builder().globMatch(pattern).build();
    }

    public String getExactMatch() {
        return this.exactMatch;
    }

    public String getGlobMatch() {
        return this.globMatch;
    }

    public String getJsonMatch() {
        return this.jsonMatch;
    }

    public String getRegexMatch() {
        return this.regexMatch;
    }

    public String getXpathMatch() {
        return this.xpathMatch;
    }

    public String getJsonPathMatch() {
        return this.jsonPathMatch;
    }

    public String getXmlMatch() {
        return this.xmlMatch;
    }

    static FieldMatcher fromString(String value) {
        Builder builder = new Builder();
        if (value.contains("*")) {
            builder.globMatch(value);
        } else {
            builder.exactMatch(value);
        }
        return builder.build();
    }

    @JsonIgnore
    public String getMatchPattern() {
        return Stream.of(this.exactMatch, this.regexMatch).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("None of the exact/regex matcher is set. "));
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class Builder {
        private String exactMatch = null;
        private String globMatch = null;
        private String regexMatch = null;
        private String jsonMatch = null;
        private String jsonPathMatch = null;
        private String xmlMatch = null;
        private String xpathMatch = null;

        public Builder exactMatch(String exactMatch) {
            this.exactMatch = exactMatch;
            return this;
        }

        public Builder globMatch(String globMatch) {
            this.globMatch = globMatch;
            return this;
        }

        public Builder regexMatch(String regexMatch) {
            this.regexMatch = regexMatch;
            return this;
        }

        public Builder jsonMatch(String jsonMatch) {
            this.jsonMatch = jsonMatch;
            return this;
        }

        public Builder jsonPathMatch(String jsonPathMatch) {
            this.jsonPathMatch = jsonPathMatch;
            return this;
        }

        public Builder xmlMatch(String xmlMatch) {
            this.xmlMatch = xmlMatch;
            return this;
        }

        public Builder xpathMatch(String xpathMatch) {
            this.xpathMatch = xpathMatch;
            return this;
        }

        public FieldMatcher build() {
            return new FieldMatcher(this.exactMatch, this.globMatch, this.regexMatch, this.jsonMatch, this.jsonPathMatch, this.xmlMatch, this.xpathMatch);
        }
    }
}

