/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.rule;

import io.specto.hoverfly.junit.core.Hoverfly;
import io.specto.hoverfly.junit.core.HoverflyConfig;
import io.specto.hoverfly.junit.core.HoverflyMode;
import io.specto.hoverfly.junit.core.SimulationSource;
import io.specto.hoverfly.junit.core.SslConfigurer;
import io.specto.hoverfly.junit.dsl.RequestMatcherBuilder;
import io.specto.hoverfly.junit.dsl.StubServiceBuilder;
import io.specto.hoverfly.junit.rule.HoverflyRuleUtils;
import io.specto.hoverfly.junit.verification.VerificationCriteria;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoverflyRule
extends ExternalResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(HoverflyRule.class);
    private final Hoverfly hoverfly;
    private final HoverflyMode hoverflyMode;
    private Path capturePath;
    private SimulationSource simulationSource;
    private boolean enableSimulationPrint;

    private HoverflyRule(SimulationSource simulationSource, HoverflyConfig hoverflyConfig) {
        this.hoverflyMode = HoverflyMode.SIMULATE;
        this.hoverfly = new Hoverfly(hoverflyConfig, this.hoverflyMode);
        this.simulationSource = simulationSource;
    }

    private HoverflyRule(Path capturePath, HoverflyConfig hoverflyConfig) {
        this.hoverflyMode = HoverflyMode.CAPTURE;
        this.hoverfly = new Hoverfly(hoverflyConfig, this.hoverflyMode);
        this.capturePath = capturePath;
    }

    private HoverflyRule(HoverflyConfig hoverflyConfig) {
        this.hoverflyMode = HoverflyMode.CAPTURE;
        this.hoverfly = new Hoverfly(hoverflyConfig, this.hoverflyMode);
    }

    public static HoverflyRule inCaptureOrSimulationMode(String recordFile) {
        return HoverflyRule.inCaptureOrSimulationMode(recordFile, HoverflyConfig.configs());
    }

    public static HoverflyRule inCaptureOrSimulationMode(String recordFile, HoverflyConfig hoverflyConfig) {
        Path path = HoverflyRuleUtils.fileRelativeToTestResourcesHoverfly(recordFile);
        if (Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
            return HoverflyRule.inSimulationMode(SimulationSource.file(path), hoverflyConfig);
        }
        return HoverflyRule.inCaptureMode(recordFile, hoverflyConfig);
    }

    public static HoverflyRule inCaptureMode() {
        return HoverflyRule.inCaptureMode(HoverflyConfig.configs());
    }

    public static HoverflyRule inCaptureMode(HoverflyConfig hoverflyConfig) {
        return new HoverflyRule(hoverflyConfig);
    }

    public static HoverflyRule inCaptureMode(String outputFilename) {
        return HoverflyRule.inCaptureMode(outputFilename, HoverflyConfig.configs());
    }

    public static HoverflyRule inCaptureMode(String outputFilename, HoverflyConfig hoverflyConfig) {
        HoverflyRuleUtils.createTestResourcesHoverflyDirectoryIfNoneExisting();
        return new HoverflyRule(HoverflyRuleUtils.fileRelativeToTestResourcesHoverfly(outputFilename), hoverflyConfig);
    }

    public static HoverflyRule inSimulationMode() {
        return HoverflyRule.inSimulationMode(HoverflyConfig.configs());
    }

    public static HoverflyRule inSimulationMode(HoverflyConfig hoverflyConfig) {
        return HoverflyRule.inSimulationMode(SimulationSource.empty(), hoverflyConfig);
    }

    public static HoverflyRule inSimulationMode(SimulationSource simulationSource) {
        return HoverflyRule.inSimulationMode(simulationSource, HoverflyConfig.configs());
    }

    public static HoverflyRule inSimulationMode(SimulationSource simulationSource, HoverflyConfig hoverflyConfig) {
        return new HoverflyRule(simulationSource, hoverflyConfig);
    }

    public Statement apply(Statement base, Description description) {
        if (HoverflyRuleUtils.isAnnotatedWithRule(description)) {
            LOGGER.warn("It is recommended to use HoverflyRule with @ClassRule to get better performance in your tests, and prevent known issue with Apache HttpClient. For more information, please see http://hoverfly-java.readthedocs.io/en/latest/pages/misc/misc.html#apache-httpclient.");
        }
        return super.apply(base, description);
    }

    protected void before() throws Throwable {
        this.hoverfly.start();
        if (this.hoverflyMode == HoverflyMode.SIMULATE) {
            this.importSimulation();
        }
    }

    protected void after() {
        try {
            if (this.hoverflyMode == HoverflyMode.CAPTURE) {
                this.hoverfly.exportSimulation(this.capturePath);
            }
        }
        finally {
            this.hoverfly.close();
        }
    }

    public int getProxyPort() {
        return this.hoverfly.getHoverflyConfig().getProxyPort();
    }

    public SslConfigurer getSslConfigurer() {
        return this.hoverfly.getSslConfigurer();
    }

    public HoverflyMode getHoverflyMode() {
        return this.hoverflyMode;
    }

    public void simulate(SimulationSource simulationSource) {
        this.checkMode(HoverflyMode.SIMULATE);
        this.simulationSource = simulationSource;
        this.importSimulation();
        this.hoverfly.resetJournal();
    }

    public void capture(String recordFile) {
        this.checkMode(HoverflyMode.CAPTURE);
        if (this.capturePath != null) {
            this.hoverfly.exportSimulation(this.capturePath);
        }
        this.hoverfly.reset();
        this.capturePath = HoverflyRuleUtils.fileRelativeToTestResourcesHoverfly(recordFile);
    }

    public String getAuthHeaderName() {
        return "X-HOVERFLY-AUTHORIZATION";
    }

    public String getAuthHeaderValue() {
        Optional<String> authToken = this.hoverfly.getHoverflyConfig().getAuthToken();
        return authToken.map(s -> "Bearer " + s).orElse(null);
    }

    public HoverflyRule printSimulationData() {
        this.enableSimulationPrint = true;
        return this;
    }

    public void verify(RequestMatcherBuilder requestMatcher) {
        this.hoverfly.verify(requestMatcher);
    }

    public void verify(RequestMatcherBuilder requestMatcher, VerificationCriteria criteria) {
        this.hoverfly.verify(requestMatcher, criteria);
    }

    public void verifyZeroRequestTo(StubServiceBuilder requestedServiceBuilder) {
        this.hoverfly.verifyZeroRequestTo(requestedServiceBuilder);
    }

    public void verifyAll() {
        this.hoverfly.verifyAll();
    }

    public void resetJournal() {
        this.hoverfly.resetJournal();
    }

    private void checkMode(HoverflyMode mode) {
        if (this.hoverflyMode != mode) {
            throw new HoverflyRuleException("Hoverfly must be in " + mode.name() + " mode for this operation.");
        }
    }

    private void importSimulation() {
        if (this.simulationSource == null) {
            this.simulationSource = SimulationSource.empty();
        }
        this.hoverfly.importSimulation(this.simulationSource);
        if (this.enableSimulationPrint) {
            HoverflyRuleUtils.prettyPrintJson(this.simulationSource.getSimulation());
        }
    }

    static class HoverflyRuleException
    extends RuntimeException {
        HoverflyRuleException(String message) {
            super(message);
        }
    }
}

