/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.utils;

import io.swagger.inflector.CustomMediaTypes;
import io.swagger.inflector.utils.ContentTypeSelector;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class DefaultContentTypeSelector
implements ContentTypeSelector {
    private final MediaType type;
    private final Set<String> overriden;

    public DefaultContentTypeSelector(MediaType type) {
        this(type, CustomMediaTypes.APPLICATION_YAML.getSubtype());
    }

    public DefaultContentTypeSelector(MediaType type, String ... overriden) {
        this.type = type;
        TreeSet<String> tmp = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        tmp.add("*");
        tmp.addAll(Arrays.asList(overriden));
        this.overriden = Collections.unmodifiableSet(tmp);
    }

    @Override
    public boolean apply(List<MediaType> acceptable, Response.ResponseBuilder builder) {
        for (MediaType item : acceptable) {
            if (this.overriden.contains(item.getSubtype())) continue;
            return false;
        }
        builder.type(this.type);
        return true;
    }
}

