/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.wildfly;

import java.io.IOException;
import java.io.InputStream;
import javax.enterprise.inject.Vetoed;
import org.jboss.as.logging.logmanager.ConfigurationPersistence;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.PropertyConfigurator;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.wildfly.swarm.bootstrap.logging.InitialLoggerManager;
import org.wildfly.swarm.bootstrap.logging.LevelNode;

@Vetoed
public class LoggingConfigurator
extends ConfigurationPersistence
implements Configurator {
    private final LogContext context;
    private final PropertyConfigurator propertyConfigurator;

    public LoggingConfigurator() {
        this(LogContext.getSystemLogContext());
    }

    public LoggingConfigurator(LogContext context) {
        this.context = context;
        this.propertyConfigurator = new PropertyConfigurator(this.context);
    }

    public void configure(InputStream inputStream) throws IOException {
        this.propertyConfigurator.configure(inputStream);
        LogContextConfiguration config = this.propertyConfigurator.getLogContextConfiguration();
        config.getHandlerConfiguration("CONSOLE").setLevel("ALL");
        LevelNode root = InitialLoggerManager.INSTANCE.getRoot();
        this.apply(root, config);
        config.commit();
    }

    protected void apply(LevelNode node, LogContextConfiguration config) {
        if (!node.getName().equals("")) {
            config.addLoggerConfiguration(node.getName()).setLevel(node.getLevel().toString());
        }
        for (LevelNode each : node.getChildren()) {
            this.apply(each, config);
        }
    }
}

