/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.wildfly;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.CodeSigner;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.vfs.TempDir;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.spi.FileSystem;
import org.wildfly.swarm.container.runtime.wildfly.SizingOutputStream;

@ApplicationScoped
public class ShrinkWrapFileSystem
implements FileSystem {
    private Map<String, Entry> archives = new HashMap<String, Entry>();
    private TempDir tempDir;
    @Inject
    private TempFileProvider tempFileProvider;

    @PostConstruct
    public void postConstruct() throws IOException {
        this.tempDir = this.tempFileProvider.createTempDir("wildfly-swarm-deployments.tmp");
    }

    public void addArchive(String name, Archive<?> archive) {
        this.archives.put(name, new Entry(archive));
    }

    public File getFile(VirtualFile mountPoint, VirtualFile target) throws IOException {
        return this.getEntry(mountPoint, target).map(e -> this.getFile((Entry)e)).orElse(null);
    }

    File getFile(Entry entry) {
        if (entry.file == null) {
            try {
                entry.file = this.tempDir.createFile(entry.archive.getName(), ((ZipExporter)entry.archive.as(ZipExporter.class)).exportAsInputStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return entry.file;
    }

    public InputStream openInputStream(VirtualFile mountPoint, VirtualFile target) throws IOException {
        return this.getEntry(mountPoint, target).map(e -> ((ZipExporter)e.archive.as(ZipExporter.class)).exportAsInputStream()).orElse(null);
    }

    Optional<Entry> getEntry(VirtualFile mountPoint, VirtualFile target) {
        String name = target.getPathNameRelativeTo(mountPoint);
        Entry entry = this.archives.get(name);
        return Optional.ofNullable(entry);
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean delete(VirtualFile mountPoint, VirtualFile target) {
        this.getEntry(mountPoint, target).ifPresent(e -> {
            try {
                e.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        });
        return true;
    }

    public long getSize(VirtualFile mountPoint, VirtualFile target) {
        return this.getEntry(mountPoint, target).map(e -> this.sizeof((Entry)e)).orElse(0L);
    }

    long sizeof(Entry entry) {
        if (entry.size == null) {
            SizingOutputStream sizingOutputStream = new SizingOutputStream();
            ((ZipExporter)entry.archive.as(ZipExporter.class)).exportTo((OutputStream)sizingOutputStream);
            entry.size = sizingOutputStream.getSize();
        }
        return entry.size;
    }

    public long getLastModified(VirtualFile mountPoint, VirtualFile target) {
        return 0L;
    }

    public boolean exists(VirtualFile mountPoint, VirtualFile target) {
        return this.getEntry(mountPoint, target).isPresent();
    }

    public boolean isFile(VirtualFile mountPoint, VirtualFile target) {
        return this.exists(mountPoint, target);
    }

    public boolean isDirectory(VirtualFile mountPoint, VirtualFile target) {
        return false;
    }

    public List<String> getDirectoryEntries(VirtualFile mountPoint, VirtualFile target) {
        return Collections.emptyList();
    }

    public CodeSigner[] getCodeSigners(VirtualFile mountPoint, VirtualFile target) {
        return new CodeSigner[0];
    }

    public void close() throws IOException {
        for (Entry each : this.archives.values()) {
            each.close();
        }
        this.tempDir.close();
    }

    public File getMountSource() {
        return null;
    }

    public URI getRootURI() throws URISyntaxException {
        return null;
    }

    private static class Entry
    implements Closeable {
        final Archive<?> archive;
        Long size;
        File file;

        Entry(Archive<?> archive) {
            this.archive = archive;
        }

        @Override
        public void close() throws IOException {
            if (this.file != null) {
                this.file.delete();
            }
        }
    }
}

