/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.xmlconfig;

import java.net.URL;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.swarm.container.runtime.xmlconfig.XMLConfig;
import org.wildfly.swarm.internal.SwarmConfigMessages;

@ApplicationScoped
public class StandaloneXMLConfigProducer {
    private static final String STANDALONE_XML_FILE = "standalone.xml";

    @Produces
    @XMLConfig
    public URL fromSwarmApplicationModule() {
        try {
            Module app = Module.getBootModuleLoader().loadModule("swarm.application");
            ModuleClassLoader cl = app.getClassLoader();
            URL result = cl.getResource(STANDALONE_XML_FILE);
            if (result != null) {
                SwarmConfigMessages.MESSAGES.loadingStandaloneXml("'swarm.application' module", result.toExternalForm());
            }
            return result;
        }
        catch (ModuleLoadException e) {
            SwarmConfigMessages.MESSAGES.errorLoadingModule(e);
            return null;
        }
    }

    @Produces
    @XMLConfig
    public URL fromClassLoader() {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        URL result = cl.getResource(STANDALONE_XML_FILE);
        if (result != null) {
            SwarmConfigMessages.MESSAGES.loadingStandaloneXml("system classloader", result.toExternalForm());
        }
        return result;
    }
}

