/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.elytron;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.Elytron;
import org.wildfly.swarm.config.elytron.SimplePermissionMapper;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.MarshalDMR;
import org.wildfly.swarm.spi.api.annotations.WildFlyExtension;

@WildFlyExtension(module="org.wildfly.extension.elytron")
@MarshalDMR
public class ElytronFraction
extends Elytron<ElytronFraction>
implements Fraction<ElytronFraction> {
    private static final String ELYTRON = "elytron";
    private static final String GLOBAL = "global";
    private static final String LOCAL = "local";
    private static final String LOCAL_AUDIT = "local-audit";
    private static final String MANAGEMENT_DOMAIN = "ManagementDomain";
    private static final String MANAGEMENT_REALM = "ManagementRealm";
    private static final String APPLICATION_DOMAIN = "ApplicationDomain";
    private static final String APPLICATION_REALM = "ApplicationRealm";
    private static final String MECHANISM_NAME = "mechanism-name";
    private static final String MECHANISM_REALM_CONFIGURATIONS = "mechanism-realm-configurations";
    private static final String REALM = "realm";
    private static final String REALM_NAME = "realm-name";
    private static final String CLASS_NAME = "class-name";
    private static final String MODULE = "module";
    private static final String TARGET_NAME = "target-name";
    private static final String COMBINED_PROVIDERS = "combined-providers";
    private static final String ROLE_DECODER = "role-decoder";
    private static final String OPENSSL = "openssl";

    public ElytronFraction applyDefaults() {
        this.finalProviders(COMBINED_PROVIDERS);
        this.disallowedProvider("OracleUcrypto");
        this.providerLoader(ELYTRON, loader -> loader.module("org.wildfly.security.elytron"));
        this.providerLoader(OPENSSL, loader -> loader.module("org.wildfly.openssl"));
        this.aggregateProviders(COMBINED_PROVIDERS, providers -> {
            providers.provider(ELYTRON);
            providers.provider(OPENSSL);
        });
        this.securityDomain(APPLICATION_DOMAIN, domain -> {
            domain.defaultRealm(APPLICATION_REALM);
            domain.permissionMapper("default-permission-mapper");
            domain.realm((Map)new HashMap(){
                {
                    this.put(ElytronFraction.REALM, ElytronFraction.APPLICATION_REALM);
                    this.put(ElytronFraction.ROLE_DECODER, "groups-to-roles");
                }
            });
            domain.realm((Map)new HashMap(){
                {
                    this.put(ElytronFraction.REALM, ElytronFraction.LOCAL);
                }
            });
        });
        this.securityDomain(MANAGEMENT_DOMAIN, domain -> {
            domain.defaultRealm(MANAGEMENT_REALM);
            domain.permissionMapper("default-permission-mapper");
            domain.realm((Map)new HashMap(){
                {
                    this.put(ElytronFraction.REALM, ElytronFraction.MANAGEMENT_REALM);
                    this.put(ElytronFraction.ROLE_DECODER, "groups-to-roles");
                }
            });
            domain.realm((Map)new HashMap(){
                {
                    this.put(ElytronFraction.REALM, ElytronFraction.LOCAL);
                    this.put("role-mapper", "super-user-mapper");
                }
            });
        });
        this.identityRealm(LOCAL, realm -> realm.identity("$local"));
        this.customRealm(APPLICATION_REALM, realm -> {
            realm.module("org.wildfly.swarm.elytron:runtime");
            realm.className("org.wildfly.swarm.elytron.runtime.Realm");
        });
        this.customRealm(MANAGEMENT_REALM, realm -> {
            realm.module("org.wildfly.swarm.elytron:runtime");
            realm.className("org.wildfly.swarm.elytron.runtime.Realm");
        });
        this.simplePermissionMapper("default-permission-mapper", mapper -> {
            mapper.mappingMode(SimplePermissionMapper.MappingMode.FIRST);
            mapper.permissionMapping((Map)new HashMap(){
                {
                    this.put("principals", new ArrayList(){
                        {
                            this.add("anonymous");
                        }
                    });
                    this.put("permissions", new ArrayList(){
                        {
                            this.add(new HashMap(){
                                {
                                    this.put(ElytronFraction.CLASS_NAME, "org.wildfly.extension.batch.jberet.deployment.BatchPermission");
                                    this.put(ElytronFraction.MODULE, "org.wildfly.extension.batch.jberet");
                                    this.put(ElytronFraction.TARGET_NAME, "*");
                                }
                            });
                            this.add(new HashMap(){
                                {
                                    this.put(ElytronFraction.CLASS_NAME, "org.wildfly.transaction.client.RemoteTransactionPermission");
                                    this.put(ElytronFraction.MODULE, "org.wildfly.transaction.client");
                                }
                            });
                            this.add(new HashMap(){
                                {
                                    this.put(ElytronFraction.CLASS_NAME, "org.jboss.ejb.client.RemoteEJBPermission");
                                    this.put(ElytronFraction.MODULE, "org.jboss.ejb-client");
                                }
                            });
                        }
                    });
                }
            });
            mapper.permissionMapping((Map)new HashMap(){
                {
                    this.put("match-all", true);
                    this.put("permissions", new ArrayList(){
                        {
                            this.add(new HashMap(){
                                {
                                    this.put(ElytronFraction.CLASS_NAME, "org.wildfly.security.auth.permission.LoginPermission");
                                }
                            });
                            this.add(new HashMap(){
                                {
                                    this.put(ElytronFraction.CLASS_NAME, "org.wildfly.extension.batch.jberet.deployment.BatchPermission");
                                    this.put(ElytronFraction.MODULE, "org.wildfly.extension.batch.jberet");
                                    this.put(ElytronFraction.TARGET_NAME, "*");
                                }
                            });
                            this.add(new HashMap(){
                                {
                                    this.put(ElytronFraction.CLASS_NAME, "org.wildfly.transaction.client.RemoteTransactionPermission");
                                    this.put(ElytronFraction.MODULE, "org.wildfly.transaction.client");
                                }
                            });
                            this.add(new HashMap(){
                                {
                                    this.put(ElytronFraction.CLASS_NAME, "org.jboss.ejb.client.RemoteEJBPermission");
                                    this.put(ElytronFraction.MODULE, "org.jboss.ejb-client");
                                }
                            });
                        }
                    });
                }
            });
        });
        this.constantRealmMapper(LOCAL, mapper -> mapper.realmName(LOCAL));
        this.simpleRoleDecoder("groups-to-roles", decoder -> decoder.attribute("groups"));
        this.constantRoleMapper("super-user-mapper", mapper -> mapper.role("SuperUser"));
        this.httpAuthenticationFactory("management-http-authentication", auth -> {
            auth.httpServerMechanismFactory(GLOBAL);
            auth.securityDomain(MANAGEMENT_DOMAIN);
            auth.mechanismConfiguration((Map)new HashMap(){
                {
                    this.put(ElytronFraction.MECHANISM_NAME, "DIGEST");
                    this.put(ElytronFraction.MECHANISM_REALM_CONFIGURATIONS, new ArrayList(){
                        {
                            this.add(new HashMap(){
                                {
                                    this.put(ElytronFraction.REALM_NAME, ElytronFraction.MANAGEMENT_REALM);
                                }
                            });
                        }
                    });
                }
            });
        });
        this.httpAuthenticationFactory("application-http-authentication", auth -> {
            auth.httpServerMechanismFactory(GLOBAL);
            auth.securityDomain(APPLICATION_DOMAIN);
            auth.mechanismConfiguration((Map)new HashMap(){
                {
                    this.put(ElytronFraction.MECHANISM_NAME, "BASIC");
                    this.put(ElytronFraction.MECHANISM_REALM_CONFIGURATIONS, new ArrayList(){
                        {
                            this.add(new HashMap(){
                                {
                                    this.put(ElytronFraction.REALM_NAME, "Application Realm");
                                }
                            });
                        }
                    });
                }
            });
            auth.mechanismConfiguration((Map)new HashMap(){
                {
                    this.put(ElytronFraction.MECHANISM_NAME, "FORM");
                }
            });
        });
        this.providerHttpServerMechanismFactory(GLOBAL);
        this.saslAuthenticationFactory("management-sasl-authentication", auth -> {
            auth.saslServerFactory("configured");
            auth.securityDomain(MANAGEMENT_DOMAIN);
            auth.mechanismConfiguration((Map)new HashMap(){
                {
                    this.put(ElytronFraction.MECHANISM_NAME, "JBOSS-LOCAL-USER");
                    this.put("realm-mapper", ElytronFraction.LOCAL);
                }
            });
            auth.mechanismConfiguration((Map)new HashMap(){
                {
                    this.put(ElytronFraction.MECHANISM_NAME, "DIGEST-MD5");
                    this.put(ElytronFraction.MECHANISM_REALM_CONFIGURATIONS, new ArrayList(){
                        {
                            this.add(new HashMap(){
                                {
                                    this.put(ElytronFraction.REALM_NAME, ElytronFraction.MANAGEMENT_REALM);
                                }
                            });
                        }
                    });
                }
            });
        });
        this.saslAuthenticationFactory("application-sasl-authentication", auth -> {
            auth.saslServerFactory("configured");
            auth.securityDomain(APPLICATION_DOMAIN);
            auth.mechanismConfiguration((Map)new HashMap(){
                {
                    this.put(ElytronFraction.MECHANISM_NAME, "JBOSS-LOCAL-USER");
                    this.put("realm-mapper", ElytronFraction.LOCAL);
                }
            });
            auth.mechanismConfiguration((Map)new HashMap(){
                {
                    this.put(ElytronFraction.MECHANISM_NAME, "DIGEST-MD5");
                    this.put(ElytronFraction.MECHANISM_REALM_CONFIGURATIONS, new ArrayList(){
                        {
                            this.add(new HashMap(){
                                {
                                    this.put(ElytronFraction.REALM_NAME, ElytronFraction.APPLICATION_REALM);
                                }
                            });
                        }
                    });
                }
            });
        });
        this.providerSaslServerFactory(GLOBAL);
        this.mechanismProviderFilteringSaslServerFactory(ELYTRON, filtering -> {
            filtering.saslServerFactory(GLOBAL);
            filtering.filter((Map)new HashMap(){
                {
                    this.put("provider-name", "WildFlyElytron");
                }
            });
        });
        this.configurableSaslServerFactory("configured", configurable -> {
            configurable.saslServerFactory(ELYTRON);
            configurable.property("wildfly.sasl.local-user.default-user", (Object)"$local");
        });
        return this;
    }
}

