/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.fractions;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.wildfly.swarm.fractions.ArquillianClientAnnotationSeekingClassVisitor;
import org.wildfly.swarm.fractions.FractionDescriptor;
import org.wildfly.swarm.fractions.FractionList;
import org.wildfly.swarm.fractions.scanner.ClassAndPackageScanner;
import org.wildfly.swarm.fractions.scanner.FilePresenceScanner;
import org.wildfly.swarm.fractions.scanner.JarScanner;
import org.wildfly.swarm.fractions.scanner.Scanner;
import org.wildfly.swarm.fractions.scanner.WarScanner;
import org.wildfly.swarm.fractions.scanner.WebXmlDescriptorScanner;
import org.wildfly.swarm.spi.meta.FilePathSource;
import org.wildfly.swarm.spi.meta.FractionDetector;
import org.wildfly.swarm.spi.meta.PathSource;
import org.wildfly.swarm.spi.meta.SimpleLogger;
import org.wildfly.swarm.spi.meta.ZipPathSource;

public class FractionUsageAnalyzer {
    private final List<File> sources = new ArrayList<File>();
    private final FractionList fractionList;
    private Collection<FractionDetector<?>> detectors = new HashSet();
    private Collection<Scanner<?>> scanners = new HashSet();
    private boolean detectorsLoaded = false;
    private SimpleLogger log = new SimpleLogger(){};
    private String testClass;
    private boolean removeTestClassFromScanning;

    public FractionUsageAnalyzer() {
        this(FractionList.get());
    }

    public FractionUsageAnalyzer(FractionList fractionList) {
        this.fractionList = fractionList;
    }

    public FractionUsageAnalyzer source(Path source) {
        this.source(source.toFile());
        return this;
    }

    public FractionUsageAnalyzer source(File source) {
        this.sources.add(source);
        return this;
    }

    public FractionUsageAnalyzer logger(SimpleLogger log) {
        this.log = log;
        return this;
    }

    public FractionUsageAnalyzer testClass(String testClass) {
        this.testClass = testClass;
        try {
            ClassReader reader = new ClassReader(testClass);
            ArquillianClientAnnotationSeekingClassVisitor visitor = new ArquillianClientAnnotationSeekingClassVisitor();
            reader.accept((ClassVisitor)visitor, 0);
            if (visitor.isClient()) {
                this.removeTestClassFromScanning = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public Collection<FractionDescriptor> detectNeededFractions() throws IOException {
        if (this.fractionList == null) {
            return Collections.emptySet();
        }
        this.loadDetectorsAndScanners();
        this.sources.forEach(this::scanFile);
        Set detectedFractionNames = this.detectors.stream().filter(FractionDetector::wasDetected).map(FractionDetector::artifactId).distinct().collect(Collectors.toSet());
        if (this.sources.stream().anyMatch(e -> e.getName().endsWith(".war"))) {
            detectedFractionNames.add("undertow");
        }
        Set<FractionDescriptor> detectedFractions = this.fractionList.getFractionDescriptors().stream().filter(fd -> detectedFractionNames.contains(fd.getArtifactId())).collect(Collectors.toSet());
        Iterator it = detectedFractions.iterator();
        while (it.hasNext()) {
            FractionDescriptor descriptor = (FractionDescriptor)it.next();
            if (!detectedFractions.stream().anyMatch(fd -> fd.getDependencies().contains(descriptor))) continue;
            it.remove();
        }
        if (detectedFractions.isEmpty()) {
            detectedFractions.add(this.fractionList.getFractionDescriptor("io.thorntail", "container"));
        }
        return detectedFractions;
    }

    private boolean isZipFile(File source) {
        if (source.isDirectory()) {
            return false;
        }
        return source.getName().endsWith(".jar") || source.getName().endsWith(".war") || source.getName().endsWith(".zip");
    }

    private void scanFile(File source) {
        if (this.isZipFile(source)) {
            this.fireScanner(this.suffix(source.getName()), this.zipFileScannerConsumer(source));
        } else {
            File basePathFile = source.getAbsoluteFile();
            Path basePath = null;
            if (basePathFile.isDirectory()) {
                basePath = basePathFile.toPath();
            }
            if (source.isDirectory()) {
                if (source.getName().endsWith(".war") || new File(source, "WEB-INF").exists()) {
                    this.fireScanner("war", this.explodedScannerConsumer(basePath, source));
                } else {
                    this.fireScanner("jar", this.explodedScannerConsumer(basePath, source));
                }
            } else {
                this.fireScanner(this.suffix(source.getName()), this.explodedScannerConsumer(basePath, source));
            }
        }
    }

    private Consumer<Scanner<?>> zipFileScannerConsumer(File source) {
        return s -> {
            try (ZipFile zip = new ZipFile(source);){
                this.scanEntries(zip);
            }
            catch (IOException e) {
                this.log.error("", (Throwable)e);
            }
        };
    }

    private Consumer<Scanner<?>> explodedScannerConsumer(Path basePath, File source) {
        return s -> {
            try {
                this.scanEntries(source.toPath(), basePath);
            }
            catch (IOException e) {
                this.log.error("", (Throwable)e);
            }
        };
    }

    private void scanSource(PathSource source) {
        if (this.removeTestClassFromScanning && this.transformClassSource(source.getRelativePath()).equals(this.testClass)) {
            return;
        }
        String suffix = this.suffix(source.getSource().getFileName().toString());
        Collection validDetectors = this.detectors.stream().filter(d -> d.extensionToDetect().equals(suffix)).filter(d -> !d.detectionComplete()).collect(Collectors.toList());
        if (validDetectors.size() > 0) {
            this.fireScanner(suffix, s -> {
                try {
                    s.scan(source, this.convertDetectors(validDetectors), this::scanFile);
                }
                catch (IOException e) {
                    this.log.error("", (Throwable)e);
                }
            });
        }
    }

    private void scanSource(ZipEntry entry, ZipFile source) {
        if (this.removeTestClassFromScanning && this.transformClassSource(entry.getName()).equals(this.testClass)) {
            return;
        }
        String suffix = this.suffix(entry.getName());
        Collection validDetectors = this.detectors.stream().filter(d -> d.extensionToDetect().equals(suffix)).filter(d -> !d.detectionComplete()).collect(Collectors.toList());
        if (validDetectors.size() > 0) {
            this.fireScanner(suffix, s -> {
                try {
                    s.scan((PathSource)new ZipPathSource(source, entry), this.convertDetectors(validDetectors), this::scanFile);
                }
                catch (IOException e) {
                    this.log.error("", (Throwable)e);
                }
            });
        }
    }

    private void scanEntries(ZipFile source) throws IOException {
        Enumeration<? extends ZipEntry> entries = source.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            this.scanSource(entry, source);
        }
    }

    private void scanEntries(Path source, final Path basePath) throws IOException {
        if (Files.isDirectory(source, new LinkOption[0])) {
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    FractionUsageAnalyzer.this.scanSource((PathSource)new FilePathSource(basePath, file.toFile()));
                    return super.visitFile(file, attrs);
                }
            });
        } else {
            this.scanSource((PathSource)new FilePathSource(basePath, source.toFile()));
        }
    }

    private <T> Collection<FractionDetector<T>> convertDetectors(Collection<FractionDetector<?>> untypedDetectors) {
        HashSet detectors = new HashSet();
        untypedDetectors.forEach(d -> detectors.add(this.convert((FractionDetector<?>)d)));
        return detectors;
    }

    private <T> FractionDetector<T> convert(FractionDetector<?> detector) {
        return detector;
    }

    private void fireScanner(String suffix, Consumer<Scanner<?>> scannerConsumer) {
        List<Scanner<?>> scanners = this.scanners.stream().filter(s -> s.extension().equals(suffix)).collect(Collectors.toList());
        scanners.forEach(scannerConsumer);
    }

    private String suffix(String name) {
        return name.substring(name.lastIndexOf(46) + 1);
    }

    private void loadDetectorsAndScanners() {
        if (this.detectorsLoaded) {
            return;
        }
        ServiceLoader<FractionDetector> detectorLoader = ServiceLoader.load(FractionDetector.class);
        detectorLoader.forEach(d -> this.detectors.add((FractionDetector<?>)d));
        this.scanners.add(new WarScanner());
        this.scanners.add(new JarScanner());
        this.scanners.add(new ClassAndPackageScanner());
        this.scanners.add(new WebXmlDescriptorScanner());
        this.scanners.add(new FilePresenceScanner());
        ClassAndPackageScanner.classesPackagesAlreadyDetected.clear();
        this.detectorsLoaded = true;
    }

    private String transformClassSource(String entry) {
        entry = entry.replace("WEB-INF/classes/", "");
        entry = entry.replace(".class", "");
        entry = entry.replace("/", ".");
        return entry;
    }
}

