/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.management.runtime.auth;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.domain.management.plugin.AuthenticationPlugIn;
import org.jboss.as.domain.management.plugin.Credential;
import org.jboss.as.domain.management.plugin.DigestCredential;
import org.jboss.as.domain.management.plugin.Identity;
import org.jboss.as.domain.management.plugin.PlugInConfigurationSupport;

public class InMemoryAuthenticationPlugIn
implements AuthenticationPlugIn<Credential>,
PlugInConfigurationSupport {
    private Map<String, String> credentials = new HashMap<String, String>();

    public void init(Map<String, String> configuration, Map<String, Object> sharedState) throws IOException {
        for (String key : configuration.keySet()) {
            if (!key.endsWith(".hash")) continue;
            String userName = key.substring(0, key.length() - ".hash".length());
            String hash = configuration.get(key);
            this.credentials.put(userName, hash);
        }
    }

    public Identity<Credential> loadIdentity(final String userName, String realm) throws IOException {
        if (!this.credentials.containsKey(userName)) {
            return null;
        }
        final String hash = this.credentials.get(userName);
        return new Identity<Credential>(){

            public String getUserName() {
                return userName;
            }

            public Credential getCredential() {
                return new DigestCredential(hash);
            }
        };
    }
}

