/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.microprofile.config.ConfigSource;
import org.wildfly.swarm.config.microprofile.config.ConfigSourceConsumer;
import org.wildfly.swarm.config.microprofile.config.ConfigSourceProvider;
import org.wildfly.swarm.config.microprofile.config.ConfigSourceProviderConsumer;
import org.wildfly.swarm.config.microprofile.config.ConfigSourceProviderSupplier;
import org.wildfly.swarm.config.microprofile.config.ConfigSourceSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=microprofile-config")
@ResourceType(value="subsystem")
@Implicit
public class MicroprofileConfig<T extends MicroprofileConfig<T>>
implements Keyed {
    private String key = "microprofile-config";
    private PropertyChangeSupport pcs;
    private MicroprofileConfigResources subresources = new MicroprofileConfigResources();

    public MicroprofileConfig() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public MicroprofileConfigResources subresources() {
        return this.subresources;
    }

    public T configSources(List<ConfigSource> value) {
        this.subresources.configSources = value;
        return (T)this;
    }

    public T configSource(ConfigSource value) {
        this.subresources.configSources.add(value);
        return (T)this;
    }

    public T configSource(String childKey, ConfigSourceConsumer consumer) {
        ConfigSource child = new ConfigSource(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.configSource(child);
        return (T)this;
    }

    public T configSource(String childKey) {
        this.configSource(childKey, null);
        return (T)this;
    }

    public T configSource(ConfigSourceSupplier supplier) {
        this.configSource(supplier.get());
        return (T)this;
    }

    public T configSourceProviders(List<ConfigSourceProvider> value) {
        this.subresources.configSourceProviders = value;
        return (T)this;
    }

    public T configSourceProvider(ConfigSourceProvider value) {
        this.subresources.configSourceProviders.add(value);
        return (T)this;
    }

    public T configSourceProvider(String childKey, ConfigSourceProviderConsumer consumer) {
        ConfigSourceProvider child = new ConfigSourceProvider(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.configSourceProvider(child);
        return (T)this;
    }

    public T configSourceProvider(String childKey) {
        this.configSourceProvider(childKey, null);
        return (T)this;
    }

    public T configSourceProvider(ConfigSourceProviderSupplier supplier) {
        this.configSourceProvider(supplier.get());
        return (T)this;
    }

    public static class MicroprofileConfigResources {
        @ResourceDocumentation(value="Config Source")
        @SubresourceInfo(value="configSource")
        private List<ConfigSource> configSources = new ArrayList<ConfigSource>();
        @ResourceDocumentation(value="Config Source Provider")
        @SubresourceInfo(value="configSourceProvider")
        private List<ConfigSourceProvider> configSourceProviders = new ArrayList<ConfigSourceProvider>();

        @Subresource
        public List<ConfigSource> configSources() {
            return this.configSources;
        }

        public ConfigSource configSource(String key) {
            return this.configSources.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ConfigSourceProvider> configSourceProviders() {
            return this.configSourceProviders;
        }

        public ConfigSourceProvider configSourceProvider(String key) {
            return this.configSourceProviders.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

