/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.ajp;

import io.undertow.ajp.AjpParseState;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.nio.ByteBuffer;

public class AjpParser {
    public static final int STRING_LENGTH_MASK = Integer.MIN_VALUE;
    public static final AjpParser INSTANCE = new AjpParser();
    private static final HttpString[] HTTP_METHODS = new HttpString[28];
    private static final HttpString[] HTTP_HEADERS;
    private static final String[] ATTRIBUTES;

    public void parse(ByteBuffer buf, AjpParseState state, HttpServerExchange exchange) {
        if (!buf.hasRemaining()) {
            return;
        }
        switch (state.state) {
            case 0: {
                IntegerHolder result = this.parse16BitInteger(buf, state);
                if (!result.readComplete) {
                    return;
                }
                if (result.value != 4660) {
                    throw new IllegalStateException("Wrong magic number");
                }
            }
            case 2: {
                IntegerHolder result = this.parse16BitInteger(buf, state);
                if (!result.readComplete) {
                    state.state = 2;
                    return;
                }
                state.dataSize = result.value;
            }
            case 3: {
                if (!buf.hasRemaining()) {
                    state.state = 3;
                    return;
                }
                byte prefix = buf.get();
                if (prefix != 2) {
                    throw new IllegalArgumentException("We do  not support prefix codes other than 2 yet." + prefix);
                }
            }
            case 4: {
                if (!buf.hasRemaining()) {
                    state.state = 4;
                    return;
                }
                byte method = buf.get();
                if (method > 0 && method < 28) {
                    exchange.setRequestMethod(HTTP_METHODS[method]);
                } else {
                    throw new IllegalArgumentException("Unknown method type " + method);
                }
            }
            case 5: {
                Object result = this.parseString(buf, state, false);
                if (((StringHolder)result).readComplete) {
                    exchange.setProtocol(HttpString.tryFromString(((StringHolder)result).value));
                } else {
                    state.state = 5;
                    return;
                }
            }
            case 6: {
                String res;
                Object result = this.parseString(buf, state, false);
                if (((StringHolder)result).readComplete) {
                    res = ((StringHolder)result).value;
                    exchange.setRequestPath(res);
                    exchange.setRelativePath(res);
                } else {
                    state.state = 6;
                    return;
                }
            }
            case 7: {
                Object result = this.parseString(buf, state, false);
                if (!((StringHolder)result).readComplete) {
                    state.state = 7;
                    return;
                }
            }
            case 8: {
                Object result = this.parseString(buf, state, false);
                if (!((StringHolder)result).readComplete) {
                    state.state = 8;
                    return;
                }
            }
            case 9: {
                Object result = this.parseString(buf, state, false);
                if (!((StringHolder)result).readComplete) {
                    state.state = 9;
                    return;
                }
            }
            case 10: {
                Object result = this.parse16BitInteger(buf, state);
                if (!((IntegerHolder)result).readComplete) {
                    state.state = 10;
                    return;
                }
            }
            case 11: {
                if (!buf.hasRemaining()) {
                    state.state = 11;
                    return;
                }
                byte isSsl = buf.get();
            }
            case 12: {
                IntegerHolder result = this.parse16BitInteger(buf, state);
                if (!result.readComplete) {
                    state.state = 12;
                    return;
                }
                state.numHeaders = result.value;
            }
            case 13: {
                for (int readHeaders = exchange.getRequestHeaders().getHeaderNames().size(); readHeaders < state.numHeaders; ++readHeaders) {
                    StringHolder result;
                    if (state.currentHeader == null) {
                        result = this.parseString(buf, state, true);
                        if (!result.readComplete) {
                            state.state = 13;
                            return;
                        }
                        state.currentHeader = result.header != null ? result.header : HttpString.tryFromString(result.value);
                    }
                    result = this.parseString(buf, state, false);
                    if (!result.readComplete) {
                        state.state = 13;
                        return;
                    }
                    exchange.getRequestHeaders().add(state.currentHeader, result.value);
                    state.currentHeader = null;
                }
            }
            case 14: {
                String res;
                while (true) {
                    if (state.currentAttribute == null && state.currentIntegerPart == -1) {
                        if (!buf.hasRemaining()) {
                            state.state = 14;
                            return;
                        }
                        int val = 0xFF & buf.get();
                        if (val == 255) {
                            state.state = 15;
                            return;
                        }
                        if (val == 10) {
                            state.currentIntegerPart = 1;
                        } else {
                            state.currentAttribute = ATTRIBUTES[val];
                        }
                    }
                    if (state.currentIntegerPart == 1) {
                        StringHolder result = this.parseString(buf, state, false);
                        if (!result.readComplete) {
                            state.state = 14;
                            return;
                        }
                        state.currentAttribute = result.value;
                        state.currentIntegerPart = -1;
                    }
                    StringHolder result = this.parseString(buf, state, false);
                    if (!result.readComplete) {
                        state.state = 14;
                        return;
                    }
                    if (state.currentAttribute.equals(ATTRIBUTES[5])) {
                        res = result.value;
                        exchange.setQueryString(res);
                        int stringStart = 0;
                        String attrName = null;
                        for (int i = 0; i < res.length(); ++i) {
                            char c = res.charAt(i);
                            if (c == '=' && attrName == null) {
                                attrName = res.substring(stringStart, i);
                                stringStart = i + 1;
                                continue;
                            }
                            if (c != '&') continue;
                            if (attrName != null) {
                                exchange.addQueryParam(attrName, res.substring(stringStart, i));
                            } else {
                                exchange.addQueryParam(res.substring(stringStart, i), "");
                            }
                            stringStart = i + 1;
                            attrName = null;
                        }
                        if (attrName != null) {
                            exchange.addQueryParam(attrName, res.substring(stringStart, res.length()));
                        } else if (res.length() != stringStart) {
                            exchange.addQueryParam(res.substring(stringStart, res.length()), "");
                        }
                    }
                    state.currentAttribute = null;
                }
            }
        }
        state.state = 15;
    }

    private IntegerHolder parse16BitInteger(ByteBuffer buf, AjpParseState state) {
        if (!buf.hasRemaining()) {
            return new IntegerHolder(-1, false);
        }
        int number = state.currentIntegerPart;
        if (number == -1) {
            number = buf.get() & 0xFF;
        }
        if (buf.hasRemaining()) {
            byte b = buf.get();
            int result = ((0xFF & number) << 8) + (b & 0xFF);
            state.currentIntegerPart = -1;
            return new IntegerHolder(result, true);
        }
        state.currentIntegerPart = number;
        return new IntegerHolder(-1, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private StringHolder parseString(ByteBuffer buf, AjpParseState state, boolean header) {
        int number;
        if (!buf.hasRemaining()) {
            return new StringHolder(null, false);
        }
        int stringLength = state.stringLength;
        if (stringLength == -1) {
            number = buf.get() & 0xFF;
            if (!buf.hasRemaining()) {
                state.stringLength = number | Integer.MIN_VALUE;
                return new StringHolder(null, false);
            }
            byte b = buf.get();
            stringLength = ((0xFF & number) << 8) + (b & 0xFF);
        } else if ((stringLength & Integer.MIN_VALUE) != 0) {
            number = stringLength & Integer.MAX_VALUE;
            stringLength = ((0xFF & number) << 8) + (buf.get() & 0xFF);
        }
        if (header && (stringLength & 0xFF00) != 0) {
            state.stringLength = -1;
            return new StringHolder(HTTP_HEADERS[stringLength & 0xFF]);
        }
        if (stringLength == 65535) {
            state.stringLength = -1;
            return new StringHolder(null, true);
        }
        StringBuilder builder = state.currentString;
        if (builder == null) {
            state.currentString = builder = new StringBuilder();
        }
        for (int length = builder.length(); length < stringLength; ++length) {
            if (!buf.hasRemaining()) {
                state.stringLength = stringLength;
                return new StringHolder(null, false);
            }
            builder.append((char)buf.get());
        }
        if (buf.hasRemaining()) {
            buf.get();
            state.currentString = null;
            state.stringLength = -1;
            return new StringHolder(builder.toString(), true);
        }
        return new StringHolder(null, false);
    }

    static {
        AjpParser.HTTP_METHODS[1] = Methods.OPTIONS;
        AjpParser.HTTP_METHODS[2] = Methods.GET;
        AjpParser.HTTP_METHODS[3] = Methods.HEAD;
        AjpParser.HTTP_METHODS[4] = Methods.POST;
        AjpParser.HTTP_METHODS[5] = Methods.PUT;
        AjpParser.HTTP_METHODS[6] = Methods.DELETE;
        AjpParser.HTTP_METHODS[7] = Methods.TRACE;
        AjpParser.HTTP_METHODS[8] = Methods.PROPFIND;
        AjpParser.HTTP_METHODS[9] = Methods.PROPPATCH;
        AjpParser.HTTP_METHODS[10] = Methods.MKCOL;
        AjpParser.HTTP_METHODS[11] = Methods.COPY;
        AjpParser.HTTP_METHODS[12] = Methods.MOVE;
        AjpParser.HTTP_METHODS[13] = Methods.LOCK;
        AjpParser.HTTP_METHODS[14] = Methods.UNLOCK;
        AjpParser.HTTP_METHODS[15] = Methods.ACL;
        AjpParser.HTTP_METHODS[16] = Methods.REPORT;
        AjpParser.HTTP_METHODS[17] = Methods.VERSION_CONTROL;
        AjpParser.HTTP_METHODS[18] = Methods.CHECKIN;
        AjpParser.HTTP_METHODS[19] = Methods.CHECKOUT;
        AjpParser.HTTP_METHODS[20] = Methods.UNCHECKOUT;
        AjpParser.HTTP_METHODS[21] = Methods.SEARCH;
        AjpParser.HTTP_METHODS[22] = Methods.MKWORKSPACE;
        AjpParser.HTTP_METHODS[23] = Methods.UPDATE;
        AjpParser.HTTP_METHODS[24] = Methods.LABEL;
        AjpParser.HTTP_METHODS[25] = Methods.MERGE;
        AjpParser.HTTP_METHODS[26] = Methods.BASELINE_CONTROL;
        AjpParser.HTTP_METHODS[27] = Methods.MKACTIVITY;
        HTTP_HEADERS = new HttpString[15];
        AjpParser.HTTP_HEADERS[1] = Headers.ACCEPT;
        AjpParser.HTTP_HEADERS[2] = Headers.ACCEPT_CHARSET;
        AjpParser.HTTP_HEADERS[3] = Headers.ACCEPT_ENCODING;
        AjpParser.HTTP_HEADERS[4] = Headers.ACCEPT_LANGUAGE;
        AjpParser.HTTP_HEADERS[5] = Headers.AUTHORIZATION;
        AjpParser.HTTP_HEADERS[6] = Headers.CONNECTION;
        AjpParser.HTTP_HEADERS[7] = Headers.CONTENT_TYPE;
        AjpParser.HTTP_HEADERS[8] = Headers.CONTENT_LENGTH;
        AjpParser.HTTP_HEADERS[9] = Headers.COOKIE;
        AjpParser.HTTP_HEADERS[10] = Headers.COOKIE2;
        AjpParser.HTTP_HEADERS[11] = Headers.HOST;
        AjpParser.HTTP_HEADERS[12] = Headers.PRAGMA;
        AjpParser.HTTP_HEADERS[13] = Headers.REFERER;
        AjpParser.HTTP_HEADERS[14] = Headers.USER_AGENT;
        ATTRIBUTES = new String[14];
        AjpParser.ATTRIBUTES[1] = "context";
        AjpParser.ATTRIBUTES[2] = "servlet_path";
        AjpParser.ATTRIBUTES[3] = "remote_user";
        AjpParser.ATTRIBUTES[4] = "auth_type";
        AjpParser.ATTRIBUTES[5] = "query_string";
        AjpParser.ATTRIBUTES[6] = "route";
        AjpParser.ATTRIBUTES[7] = "ssl_cert";
        AjpParser.ATTRIBUTES[8] = "ssl_cipher";
        AjpParser.ATTRIBUTES[9] = "ssl_session";
        AjpParser.ATTRIBUTES[10] = "req_attribute";
        AjpParser.ATTRIBUTES[11] = "ssl_key_size";
        AjpParser.ATTRIBUTES[12] = "secret";
        AjpParser.ATTRIBUTES[13] = "stored_method";
    }

    private static class StringHolder {
        final String value;
        final HttpString header;
        final boolean readComplete;

        private StringHolder(String value, boolean readComplete) {
            this.value = value;
            this.readComplete = readComplete;
            this.header = null;
        }

        private StringHolder(HttpString value) {
            this.value = null;
            this.readComplete = true;
            this.header = value;
        }
    }

    private static class IntegerHolder {
        final int value;
        final boolean readComplete;

        private IntegerHolder(int value, boolean readComplete) {
            this.value = value;
            this.readComplete = readComplete;
        }
    }
}

