/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.api;

import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.StatusCodes;

public interface AuthenticationMechanism {
    public String getName();

    public AuthenticationMechanismOutcome authenticate(HttpServerExchange var1, SecurityContext var2);

    public ChallengeResult sendChallenge(HttpServerExchange var1, SecurityContext var2);

    public static class ChallengeResult {
        private final boolean challengeSent;
        private final StatusCodes statusCode;

        public ChallengeResult(boolean challengeSent, StatusCodes statusCode) {
            this.statusCode = statusCode;
            this.challengeSent = challengeSent;
        }

        public ChallengeResult(boolean challengeSent) {
            this(challengeSent, null);
        }

        public StatusCodes getDesiredResponseCode() {
            return this.statusCode;
        }

        public boolean isChallengeSent() {
            return this.challengeSent;
        }
    }

    public static enum AuthenticationMechanismOutcome {
        AUTHENTICATED,
        NOT_ATTEMPTED,
        NOT_AUTHENTICATED;

    }
}

