/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public final class GatedStreamSourceChannel
implements StreamSourceChannel {
    private final StreamSourceChannel delegate;
    private final ChannelListener.SimpleSetter<GatedStreamSourceChannel> readSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<GatedStreamSourceChannel> closeSetter = new ChannelListener.SimpleSetter();
    private int state;
    private static final int FLAG_GATE_OPEN = 1;
    private static final int FLAG_READS_RESUMED = 2;
    private static final int FLAG_CLOSE_REQUESTED = 4;
    private static final int FLAG_CLOSED = 8;

    public GatedStreamSourceChannel(StreamSourceChannel delegate) {
        this.delegate = delegate;
    }

    public void openGate() throws IOException {
        int val = this.state;
        if (Bits.allAreSet((int)val, (int)1)) {
            return;
        }
        this.state |= 1;
        if (Bits.allAreSet((int)val, (int)8)) {
            this.delegate.close();
        } else {
            if (Bits.allAreSet((int)val, (int)4)) {
                this.delegate.shutdownReads();
            }
            if (Bits.allAreSet((int)val, (int)2)) {
                this.delegate.wakeupReads();
            }
        }
    }

    public boolean isGateOpen() {
        return Bits.allAreSet((int)this.state, (int)1);
    }

    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    public XnioIoThread getIoThread() {
        return this.delegate.getIoThread();
    }

    public long transferTo(long position, long count, FileChannel target) throws IOException {
        int val = this.state;
        if (Bits.anyAreSet((int)val, (int)4)) {
            return -1L;
        }
        if (Bits.anyAreClear((int)val, (int)1)) {
            return 0L;
        }
        return this.delegate.transferTo(position, count, target);
    }

    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        int val = this.state;
        if (Bits.anyAreSet((int)val, (int)4)) {
            return -1L;
        }
        if (Bits.anyAreClear((int)val, (int)1)) {
            return 0L;
        }
        return this.delegate.transferTo(count, throughBuffer, target);
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        int val = this.state;
        if (Bits.anyAreSet((int)val, (int)4)) {
            return -1L;
        }
        if (Bits.anyAreClear((int)val, (int)1)) {
            return 0L;
        }
        return this.delegate.read(dsts, offset, length);
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        int val = this.state;
        if (Bits.anyAreSet((int)val, (int)4)) {
            return -1L;
        }
        if (Bits.anyAreClear((int)val, (int)1)) {
            return 0L;
        }
        return this.delegate.read(dsts);
    }

    public int read(ByteBuffer dst) throws IOException {
        int val = this.state;
        if (Bits.anyAreSet((int)val, (int)4)) {
            return -1;
        }
        if (Bits.anyAreClear((int)val, (int)1)) {
            return 0;
        }
        return this.delegate.read(dst);
    }

    public void suspendReads() {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.delegate.suspendReads();
        } else {
            this.state &= 0xFFFFFFFD;
        }
    }

    public void resumeReads() {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.delegate.resumeReads();
        } else {
            this.state |= 2;
        }
    }

    public boolean isReadResumed() {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            return this.delegate.isReadResumed();
        }
        return Bits.anyAreSet((int)this.state, (int)2);
    }

    public void wakeupReads() {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.delegate.resumeReads();
        } else {
            this.state |= 2;
            this.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    ChannelListeners.invokeChannelListener((Channel)((Object)GatedStreamSourceChannel.this), (ChannelListener)GatedStreamSourceChannel.this.readSetter.get());
                }
            });
        }
    }

    public void shutdownReads() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.delegate.shutdownReads();
        } else {
            this.state |= 4;
        }
    }

    public void awaitReadable() throws IOException {
        if (!Bits.anyAreSet((int)this.state, (int)1)) {
            throw new IllegalStateException();
        }
        this.delegate.awaitReadable();
    }

    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        if (!Bits.anyAreSet((int)this.state, (int)1)) {
            throw new IllegalStateException();
        }
        this.delegate.awaitReadable(time, timeUnit);
    }

    public XnioExecutor getReadThread() {
        return this.delegate.getIoThread();
    }

    public ChannelListener.Setter<? extends StreamSourceChannel> getReadSetter() {
        return this.readSetter;
    }

    public ChannelListener.Setter<? extends StreamSourceChannel> getCloseSetter() {
        return this.closeSetter;
    }

    public void close() throws IOException {
        if (Bits.allAreSet((int)this.state, (int)8)) {
            return;
        }
        this.state |= 8;
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            this.delegate.close();
        }
    }

    public boolean isOpen() {
        return Bits.allAreClear((int)this.state, (int)8);
    }

    public boolean supportsOption(Option<?> option) {
        return false;
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return null;
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return null;
    }

    public StreamSourceChannel getChannel() {
        return Bits.allAreSet((int)this.state, (int)1) ? this.delegate : this;
    }
}

