/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeParser;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;

public class RedirectHandler
implements HttpHandler {
    private final ExchangeAttribute attribute;

    public RedirectHandler(String location) {
        ExchangeAttributeParser parser = ExchangeAttributes.parser(this.getClass().getClassLoader());
        this.attribute = parser.parse(location);
    }

    public RedirectHandler(String location, ClassLoader classLoader) {
        ExchangeAttributeParser parser = ExchangeAttributes.parser(classLoader);
        this.attribute = parser.parse(location);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.setResponseCode(302);
        exchange.getResponseHeaders().put(Headers.LOCATION, this.attribute.readAttribute(exchange));
        exchange.endExchange();
    }
}

