/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.QueryParameterUtils;

public class RequestURLAttribute
implements ExchangeAttribute {
    public static final String REQUEST_URL_SHORT = "%U";
    public static final String REQUEST_URL = "%{REQUEST_URL}";
    public static final ExchangeAttribute INSTANCE = new RequestURLAttribute();

    private RequestURLAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        return exchange.getRequestURI();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        int pos = newValue.indexOf(63);
        if (pos == -1) {
            exchange.setRelativePath(newValue);
            exchange.setRequestURI(newValue);
            exchange.setRequestPath(newValue);
            exchange.setResolvedPath("");
        } else {
            String path = newValue.substring(0, pos);
            exchange.setRelativePath(path);
            exchange.setRequestURI(path);
            exchange.setRequestPath(path);
            exchange.setResolvedPath("");
            String newQueryString = newValue.substring(pos);
            exchange.setQueryString(newQueryString);
            exchange.getQueryParameters().putAll(QueryParameterUtils.parseQueryString(newQueryString.substring(1), QueryParameterUtils.getQueryParamEncoding(exchange)));
        }
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Request URL";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(RequestURLAttribute.REQUEST_URL) || token.equals(RequestURLAttribute.REQUEST_URL_SHORT)) {
                return INSTANCE;
            }
            return null;
        }
    }
}

