/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.error;

import io.undertow.Handlers;
import io.undertow.UndertowLogger;
import io.undertow.server.DefaultResponseListener;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.Headers;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.xnio.FileAccess;
import org.xnio.IoUtils;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.SuspendableWriteChannel;

public class FileErrorPageHandler
implements HttpHandler {
    private static final Logger log = Logger.getLogger((String)"io.undertow.server.error.file");
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;
    private volatile Set<Integer> responseCodes;
    private volatile File file;

    public FileErrorPageHandler(File file, Integer ... responseCodes) {
        this.file = file;
        this.responseCodes = new HashSet<Integer>(Arrays.asList(responseCodes));
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addDefaultResponseListener(new DefaultResponseListener(){

            @Override
            public boolean handleDefaultResponse(HttpServerExchange exchange) {
                Set codes = FileErrorPageHandler.this.responseCodes;
                if (!exchange.isResponseStarted() && codes.contains(exchange.getResponseCode())) {
                    FileErrorPageHandler.this.serveFile(exchange);
                    return true;
                }
                return false;
            }
        });
        this.next.handleRequest(exchange);
    }

    private void serveFile(final HttpServerExchange exchange) {
        exchange.dispatch(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FileChannel fileChannel;
                try {
                    try {
                        fileChannel = exchange.getConnection().getWorker().getXnio().openFile(FileErrorPageHandler.this.file, FileAccess.READ_ONLY);
                    }
                    catch (FileNotFoundException e) {
                        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                        exchange.endExchange();
                        return;
                    }
                }
                catch (IOException e) {
                    UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                    exchange.endExchange();
                    return;
                }
                exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, FileErrorPageHandler.this.file.length());
                StreamSinkChannel response = exchange.getResponseChannel();
                exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

                    @Override
                    public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                        IoUtils.safeClose((Closeable)fileChannel);
                        nextListener.proceed();
                    }
                });
                try {
                    log.tracef("Serving file %s (blocking)", (Object)fileChannel);
                    Channels.transferBlocking((StreamSinkChannel)response, (FileChannel)fileChannel, (long)0L, (long)FileErrorPageHandler.this.file.length());
                    log.tracef("Finished serving %s, shutting down (blocking)", (Object)fileChannel);
                    response.shutdownWrites();
                    log.tracef("Finished serving %s, flushing (blocking)", (Object)fileChannel);
                    Channels.flushBlocking((SuspendableWriteChannel)response);
                    log.tracef("Finished serving %s (complete)", (Object)fileChannel);
                    exchange.endExchange();
                }
                catch (IOException ignored) {
                    log.tracef("Failed to serve %s: %s", (Object)fileChannel, (Object)ignored);
                    exchange.endExchange();
                    IoUtils.safeClose((Closeable)response);
                }
                finally {
                    IoUtils.safeClose((Closeable)fileChannel);
                }
            }
        });
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public FileErrorPageHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    public Set<Integer> getResponseCodes() {
        return Collections.unmodifiableSet(this.responseCodes);
    }

    public FileErrorPageHandler setResponseCodes(Set<Integer> responseCodes) {
        this.responseCodes = responseCodes == null ? Collections.emptySet() : new HashSet<Integer>(responseCodes);
        return this;
    }

    public FileErrorPageHandler setResponseCodes(Integer ... responseCodes) {
        this.responseCodes = new HashSet<Integer>(Arrays.asList(responseCodes));
        return this;
    }

    public File getFile() {
        return this.file;
    }

    public FileErrorPageHandler setFile(File file) {
        this.file = file;
        return this;
    }
}

