/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientProvider;
import io.undertow.client.UndertowClientMessages;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

public final class UndertowClient {
    private final Map<String, ClientProvider> clientProviders;
    private static final UndertowClient INSTANCE = new UndertowClient();

    private UndertowClient() {
        this(UndertowClient.class.getClassLoader());
    }

    private UndertowClient(ClassLoader classLoader) {
        ServiceLoader<ClientProvider> providers = ServiceLoader.load(ClientProvider.class, classLoader);
        HashMap<String, ClientProvider> map = new HashMap<String, ClientProvider>();
        for (ClientProvider provider : providers) {
            for (String scheme : provider.handlesSchemes()) {
                map.put(scheme, provider);
            }
        }
        this.clientProviders = Collections.unmodifiableMap(map);
    }

    public IoFuture<ClientConnection> connect(URI uri, XnioWorker worker, Pool<ByteBuffer> bufferPool, OptionMap options) {
        return this.connect(uri, worker, null, bufferPool, options);
    }

    public IoFuture<ClientConnection> connect(URI uri, XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        final FutureResult result = new FutureResult();
        provider.connect(new ClientCallback<ClientConnection>(){

            @Override
            public void completed(ClientConnection r) {
                result.setResult((Object)r);
            }

            @Override
            public void failed(IOException e) {
                result.setException(e);
            }
        }, uri, worker, ssl, bufferPool, options);
        return result.getIoFuture();
    }

    public IoFuture<ClientConnection> connect(URI uri, XnioIoThread ioThread, Pool<ByteBuffer> bufferPool, OptionMap options) {
        return this.connect(uri, ioThread, null, bufferPool, options);
    }

    public IoFuture<ClientConnection> connect(URI uri, XnioIoThread ioThread, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        final FutureResult result = new FutureResult();
        provider.connect(new ClientCallback<ClientConnection>(){

            @Override
            public void completed(ClientConnection r) {
                result.setResult((Object)r);
            }

            @Override
            public void failed(IOException e) {
                result.setException(e);
            }
        }, uri, ioThread, ssl, bufferPool, options);
        return result.getIoFuture();
    }

    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, Pool<ByteBuffer> bufferPool, OptionMap options) {
        this.connect(listener, uri, worker, null, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, uri, worker, ssl, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, Pool<ByteBuffer> bufferPool, OptionMap options) {
        this.connect(listener, uri, ioThread, null, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, uri, ioThread, ssl, bufferPool, options);
    }

    private ClientProvider getClientProvider(URI uri) {
        ClientProvider provider = this.clientProviders.get(uri.getScheme());
        if (provider == null) {
            throw UndertowClientMessages.MESSAGES.unknownScheme(uri);
        }
        return provider;
    }

    public static UndertowClient getInstance() {
        return INSTANCE;
    }

    public static UndertowClient getInstance(ClassLoader classLoader) {
        return new UndertowClient(classLoader);
    }
}

