/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.PathTemplate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PathTemplatePredicate
implements Predicate {
    private final ExchangeAttribute attribute;
    private final PathTemplate value;

    public PathTemplatePredicate(String template, ExchangeAttribute attribute) {
        this.attribute = attribute;
        this.value = PathTemplate.create(template);
    }

    @Override
    public boolean resolve(HttpServerExchange exchange) {
        Map context;
        HashMap<String, String> params = new HashMap<String, String>();
        boolean result = this.value.matches(this.attribute.readAttribute(exchange), params);
        if (result && (context = (Map)exchange.getAttachment(PREDICATE_CONTEXT)) != null) {
            context.putAll(params);
        }
        return result;
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "path-template";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("value", String.class);
            params.put("match", ExchangeAttribute.class);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            HashSet<String> params = new HashSet<String>();
            params.add("value");
            return params;
        }

        @Override
        public String defaultParameter() {
            return "value";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            ExchangeAttribute match = (ExchangeAttribute)config.get("match");
            if (match == null) {
                match = ExchangeAttributes.relativePath();
            }
            String value = (String)config.get("value");
            return new PathTemplatePredicate(value, match);
        }
    }
}

