/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.spdy;

import io.undertow.server.protocol.framed.FramePriority;
import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.spdy.SpdyChannel;
import io.undertow.spdy.SpdyStreamSinkChannel;
import io.undertow.spdy.SpdyStreamSourceChannel;
import io.undertow.spdy.SpdyStreamStreamSinkChannel;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

class SpdyFramePriority
implements FramePriority<SpdyChannel, SpdyStreamSourceChannel, SpdyStreamSinkChannel> {
    public static SpdyFramePriority INSTANCE = new SpdyFramePriority();

    SpdyFramePriority() {
    }

    @Override
    public boolean insertFrame(SpdyStreamSinkChannel newFrame, List<SpdyStreamSinkChannel> pendingFrames) {
        SendFrameHeader header;
        if (newFrame instanceof SpdyStreamStreamSinkChannel && (header = ((SpdyStreamStreamSinkChannel)newFrame).generateSendFrameHeader()).getByteBuffer() == null) {
            return false;
        }
        pendingFrames.add(newFrame);
        return true;
    }

    @Override
    public void frameAdded(SpdyStreamSinkChannel addedFrame, List<SpdyStreamSinkChannel> pendingFrames, Deque<SpdyStreamSinkChannel> holdFrames) {
        Iterator<SpdyStreamSinkChannel> it = pendingFrames.iterator();
        while (it.hasNext()) {
            SendFrameHeader header;
            SpdyStreamSinkChannel pending = it.next();
            if (!(pending instanceof SpdyStreamStreamSinkChannel) || (header = ((SpdyStreamStreamSinkChannel)pending).generateSendFrameHeader()).getByteBuffer() == null) continue;
            pendingFrames.add(pending);
            it.remove();
        }
    }
}

