/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowMessages;
import io.undertow.conduits.ChunkReader;
import io.undertow.conduits.ConduitListener;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.HttpAttachments;
import io.undertow.server.protocol.http.HttpServerConnection;
import io.undertow.util.Attachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.ConduitReadableByteChannel;
import org.xnio.conduits.PushBackStreamSourceConduit;
import org.xnio.conduits.StreamSourceConduit;

public class ChunkedStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    @Deprecated
    public static final AttachmentKey<HeaderMap> TRAILERS = HttpAttachments.REQUEST_TRAILERS;
    private final BufferWrapper bufferWrapper;
    private final ConduitListener<? super ChunkedStreamSourceConduit> finishListener;
    private final HttpServerExchange exchange;
    private boolean closed;
    private long remainingAllowed;
    private final ChunkReader chunkReader;

    public ChunkedStreamSourceConduit(StreamSourceConduit next, final PushBackStreamSourceConduit channel, final Pool<ByteBuffer> pool, ConduitListener<? super ChunkedStreamSourceConduit> finishListener, Attachable attachable) {
        this(next, new BufferWrapper(){

            @Override
            public Pooled<ByteBuffer> allocate() {
                return pool.allocate();
            }

            @Override
            public void pushBack(Pooled<ByteBuffer> pooled) {
                channel.pushBack(pooled);
            }
        }, finishListener, attachable, null);
    }

    public ChunkedStreamSourceConduit(StreamSourceConduit next, final HttpServerExchange exchange, ConduitListener<? super ChunkedStreamSourceConduit> finishListener) {
        this(next, new BufferWrapper(){

            @Override
            public Pooled<ByteBuffer> allocate() {
                return exchange.getConnection().getBufferPool().allocate();
            }

            @Override
            public void pushBack(Pooled<ByteBuffer> pooled) {
                ((HttpServerConnection)exchange.getConnection()).ungetRequestBytes(pooled);
            }
        }, finishListener, exchange, exchange);
    }

    protected ChunkedStreamSourceConduit(StreamSourceConduit next, BufferWrapper bufferWrapper, ConduitListener<? super ChunkedStreamSourceConduit> finishListener, Attachable attachable, HttpServerExchange exchange) {
        super(next);
        this.bufferWrapper = bufferWrapper;
        this.finishListener = finishListener;
        this.remainingAllowed = Long.MIN_VALUE;
        this.chunkReader = new ChunkReader<ChunkedStreamSourceConduit>(attachable, HttpAttachments.REQUEST_TRAILERS, finishListener, this);
        this.exchange = exchange;
    }

    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return target.transferFrom((ReadableByteChannel)new ConduitReadableByteChannel((StreamSourceConduit)this), position, count);
    }

    private void updateRemainingAllowed(int written) throws IOException {
        if (this.remainingAllowed == Long.MIN_VALUE) {
            if (this.exchange == null) {
                return;
            }
            long maxEntitySize = this.exchange.getMaxEntitySize();
            if (maxEntitySize <= 0L) {
                return;
            }
            this.remainingAllowed = maxEntitySize;
        }
        this.remainingAllowed -= (long)written;
        if (this.remainingAllowed < 0L) {
            Connectors.terminateRequest(this.exchange);
            this.closed = true;
            this.exchange.setPersistent(false);
            this.finishListener.handleEvent(this);
            throw UndertowMessages.MESSAGES.requestEntityWasTooLarge(this.exchange.getMaxEntitySize());
        }
    }

    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return IoUtils.transfer((ReadableByteChannel)new ConduitReadableByteChannel((StreamSourceConduit)this), (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)target);
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        for (int i = offset; i < length; ++i) {
            if (!dsts[i].hasRemaining()) continue;
            return this.read(dsts[i]);
        }
        return 0L;
    }

    public void terminateReads() throws IOException {
        if (!this.isFinished()) {
            super.terminateReads();
            throw UndertowMessages.MESSAGES.chunkedChannelClosedMidChunk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer dst) throws IOException {
        long chunkRemaining = this.chunkReader.getChunkRemaining();
        if (chunkRemaining == -1L) {
            return -1;
        }
        if (this.closed) {
            throw new ClosedChannelException();
        }
        Pooled<ByteBuffer> pooled = this.bufferWrapper.allocate();
        ByteBuffer buf = (ByteBuffer)pooled.getResource();
        try {
            int n;
            long chunkInBuffer;
            int read;
            int originalLimit;
            block29: {
                int r = ((StreamSourceConduit)this.next).read(buf);
                buf.flip();
                if (r == -1) {
                    throw new ClosedChannelException();
                }
                if (r == 0) {
                    int n2 = 0;
                    return n2;
                }
                if (chunkRemaining == 0L && (chunkRemaining = this.chunkReader.readChunk(buf)) <= 0L) {
                    int n3 = (int)chunkRemaining;
                    return n3;
                }
                originalLimit = dst.limit();
                read = 0;
                chunkInBuffer = Math.min((long)buf.remaining(), chunkRemaining);
                int remaining = dst.remaining();
                if (chunkInBuffer <= (long)remaining) break block29;
                int orig = buf.limit();
                buf.limit(buf.position() + remaining);
                dst.put(buf);
                buf.limit(orig);
                chunkRemaining -= (long)remaining;
                this.updateRemainingAllowed(remaining);
                int n4 = remaining;
                dst.limit(originalLimit);
                return n4;
            }
            try {
                int old;
                if (buf.hasRemaining()) {
                    old = buf.limit();
                    buf.limit((int)Math.min((long)old, (long)buf.position() + chunkInBuffer));
                    try {
                        dst.put(buf);
                    }
                    finally {
                        buf.limit(old);
                    }
                    read = (int)((long)read + chunkInBuffer);
                    chunkRemaining -= chunkInBuffer;
                }
                if (chunkRemaining > 0L) {
                    old = dst.limit();
                    try {
                        if (chunkRemaining < (long)dst.remaining()) {
                            dst.limit((int)((long)dst.position() + chunkRemaining));
                        }
                        int c = 0;
                        do {
                            if ((c = ((StreamSourceConduit)this.next).read(dst)) <= 0) continue;
                            read += c;
                            chunkRemaining -= (long)c;
                        } while (c > 0 && chunkRemaining > 0L);
                        if (c == -1) {
                            throw new ClosedChannelException();
                        }
                    }
                    finally {
                        dst.limit(old);
                    }
                }
                this.updateRemainingAllowed(read);
                n = read;
                dst.limit(originalLimit);
            }
            catch (Throwable throwable) {
                dst.limit(originalLimit);
                throw throwable;
            }
            return n;
        }
        finally {
            if (chunkRemaining >= 0L) {
                this.chunkReader.setChunkRemaining(chunkRemaining);
            }
            if (buf.hasRemaining()) {
                this.bufferWrapper.pushBack(pooled);
            } else {
                pooled.free();
            }
        }
    }

    public boolean isFinished() {
        return this.chunkReader.getChunkRemaining() == -1L;
    }

    static interface BufferWrapper {
        public Pooled<ByteBuffer> allocate();

        public void pushBack(Pooled<ByteBuffer> var1);
    }
}

