/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.io;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.channels.Channels;
import org.xnio.channels.EmptyStreamSourceChannel;
import org.xnio.channels.StreamSourceChannel;

public class UndertowInputStream
extends InputStream {
    private final StreamSourceChannel channel;
    private final Pool<ByteBuffer> bufferPool;
    private static final int FLAG_CLOSED = 1;
    private static final int FLAG_FINISHED = 2;
    private int state;
    private Pooled<ByteBuffer> pooled;

    public UndertowInputStream(HttpServerExchange exchange) {
        this.channel = exchange.isRequestChannelAvailable() ? exchange.getRequestChannel() : new EmptyStreamSourceChannel(exchange.getIoThread());
        this.bufferPool = exchange.getConnection().getBufferPool();
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b);
        if (read == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (Thread.currentThread() == this.channel.getIoThread()) {
            throw UndertowMessages.MESSAGES.blockingIoFromIOThread();
        }
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        this.readIntoBuffer();
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        ByteBuffer buffer = (ByteBuffer)this.pooled.getResource();
        int copied = Buffers.copy((ByteBuffer)ByteBuffer.wrap(b, off, len), (ByteBuffer)buffer);
        if (!buffer.hasRemaining()) {
            this.pooled.free();
            this.pooled = null;
        }
        return copied;
    }

    private void readIntoBuffer() throws IOException {
        if (this.pooled == null && !Bits.anyAreSet((int)this.state, (int)2)) {
            this.pooled = this.bufferPool.allocate();
            int res = Channels.readBlocking((ReadableByteChannel)this.channel, (ByteBuffer)((ByteBuffer)this.pooled.getResource()));
            ((ByteBuffer)this.pooled.getResource()).flip();
            if (res == -1) {
                this.state |= 2;
                this.pooled.free();
                this.pooled = null;
            }
        }
    }

    private void readIntoBufferNonBlocking() throws IOException {
        if (this.pooled == null && !Bits.anyAreSet((int)this.state, (int)2)) {
            this.pooled = this.bufferPool.allocate();
            int res = this.channel.read((ByteBuffer)this.pooled.getResource());
            if (res == 0) {
                this.pooled.free();
                this.pooled = null;
                return;
            }
            ((ByteBuffer)this.pooled.getResource()).flip();
            if (res == -1) {
                this.state |= 2;
                this.pooled.free();
                this.pooled = null;
            }
        }
    }

    @Override
    public int available() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        this.readIntoBufferNonBlocking();
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            return -1;
        }
        if (this.pooled == null) {
            return 0;
        }
        return ((ByteBuffer)this.pooled.getResource()).remaining();
    }

    @Override
    public void close() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            return;
        }
        this.state |= 1;
        try {
            while (Bits.allAreClear((int)this.state, (int)2)) {
                this.readIntoBuffer();
                if (this.pooled == null) continue;
                this.pooled.free();
                this.pooled = null;
            }
        }
        finally {
            if (this.pooled != null) {
                this.pooled.free();
                this.pooled = null;
            }
            this.channel.shutdownReads();
            this.state |= 2;
        }
    }
}

