/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.spdy;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.protocols.spdy.SpdyFramePriority;
import io.undertow.protocols.spdy.SpdyGoAwayParser;
import io.undertow.protocols.spdy.SpdyGoAwayStreamSinkChannel;
import io.undertow.protocols.spdy.SpdyGoAwayStreamSourceChannel;
import io.undertow.protocols.spdy.SpdyHeadersParser;
import io.undertow.protocols.spdy.SpdyPingParser;
import io.undertow.protocols.spdy.SpdyPingStreamSinkChannel;
import io.undertow.protocols.spdy.SpdyPingStreamSourceChannel;
import io.undertow.protocols.spdy.SpdyProtocolUtils;
import io.undertow.protocols.spdy.SpdyPushBackParser;
import io.undertow.protocols.spdy.SpdyRstStreamParser;
import io.undertow.protocols.spdy.SpdyRstStreamSinkChannel;
import io.undertow.protocols.spdy.SpdyRstStreamStreamSourceChannel;
import io.undertow.protocols.spdy.SpdySetting;
import io.undertow.protocols.spdy.SpdySettingsParser;
import io.undertow.protocols.spdy.SpdySettingsStreamSourceChannel;
import io.undertow.protocols.spdy.SpdyStreamSinkChannel;
import io.undertow.protocols.spdy.SpdyStreamSourceChannel;
import io.undertow.protocols.spdy.SpdyStreamStreamSinkChannel;
import io.undertow.protocols.spdy.SpdyStreamStreamSourceChannel;
import io.undertow.protocols.spdy.SpdySynReplyParser;
import io.undertow.protocols.spdy.SpdySynReplyStreamSinkChannel;
import io.undertow.protocols.spdy.SpdySynReplyStreamSourceChannel;
import io.undertow.protocols.spdy.SpdySynStreamParser;
import io.undertow.protocols.spdy.SpdySynStreamStreamSinkChannel;
import io.undertow.protocols.spdy.SpdySynStreamStreamSourceChannel;
import io.undertow.protocols.spdy.SpdyWindowUpdateParser;
import io.undertow.protocols.spdy.SpdyWindowUpdateStreamSinkChannel;
import io.undertow.server.protocol.framed.AbstractFramedChannel;
import io.undertow.server.protocol.framed.AbstractFramedStreamSinkChannel;
import io.undertow.server.protocol.framed.AbstractFramedStreamSourceChannel;
import io.undertow.server.protocol.framed.FrameHeaderData;
import io.undertow.util.Attachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.AttachmentList;
import io.undertow.util.HeaderMap;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.net.ssl.SSLSession;
import org.xnio.Bits;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.ssl.SslConnection;

public class SpdyChannel
extends AbstractFramedChannel<SpdyChannel, SpdyStreamSourceChannel, SpdyStreamSinkChannel>
implements Attachable {
    static final int DEFAULT_INITIAL_WINDOW_SIZE = 65536;
    static final int SYN_STREAM = 1;
    static final int SYN_REPLY = 2;
    static final int RST_STREAM = 3;
    static final int SETTINGS = 4;
    static final int PING = 6;
    static final int GOAWAY = 7;
    static final int HEADERS = 8;
    static final int WINDOW_UPDATE = 9;
    public static final int CLOSE_OK = 0;
    public static final int CLOSE_PROTOCOL_ERROR = 1;
    public static final int CLOSE_INTERNAL_ERROR = 2;
    static final int FLAG_FIN = 1;
    static final int FLAG_UNIDIRECTIONAL = 2;
    static final int CONTROL_FRAME = Integer.MIN_VALUE;
    public static final int RST_STATUS_PROTOCOL_ERROR = 1;
    public static final int RST_STATUS_INVALID_STREAM = 2;
    public static final int RST_STATUS_REFUSED_STREAM = 3;
    public static final int RST_STATUS_UNSUPPORTED_VERSION = 4;
    public static final int RST_STATUS_CANCEL = 5;
    public static final int RST_STATUS_INTERNAL_ERROR = 6;
    public static final int RST_STATUS_FLOW_CONTROL_ERROR = 7;
    public static final int RST_STATUS_STREAM_IN_USE = 8;
    public static final int RST_STATUS_STREAM_ALREADY_CLOSED = 9;
    public static final int RST_STATUS_FRAME_TOO_LARGE = 11;
    private final Inflater inflater = new Inflater(false);
    private final Deflater deflater = new Deflater(6);
    private SpdyFrameParser frameParser;
    private final Map<Integer, SpdyStreamStreamSourceChannel> incomingStreams = new ConcurrentHashMap<Integer, SpdyStreamStreamSourceChannel>();
    private final Map<Integer, SpdyStreamStreamSinkChannel> outgoingStreams = new ConcurrentHashMap<Integer, SpdyStreamStreamSinkChannel>();
    private volatile int initialWindowSize;
    private volatile int receiveWindowSize = this.initialWindowSize = 65536;
    private volatile int sendWindowSize = this.initialWindowSize;
    private final Pool<ByteBuffer> heapBufferPool;
    private boolean thisGoneAway = false;
    private boolean peerGoneAway = false;
    private boolean lastDataRead = false;
    private int streamIdCounter;
    private int lastGoodStreamId;
    private final Map<AttachmentKey<?>, Object> attachments = Collections.synchronizedMap(new HashMap());

    public SpdyChannel(StreamConnection connectedStreamChannel, Pool<ByteBuffer> bufferPool, Pooled<ByteBuffer> data, Pool<ByteBuffer> heapBufferPool, boolean clientSide, OptionMap options) {
        super(connectedStreamChannel, bufferPool, SpdyFramePriority.INSTANCE, data, options);
        this.heapBufferPool = heapBufferPool;
        this.deflater.setDictionary(SpdyProtocolUtils.SPDY_DICT);
        this.streamIdCounter = clientSide ? 1 : 2;
    }

    @Override
    protected SpdyStreamSourceChannel createChannel(FrameHeaderData frameHeaderData, Pooled<ByteBuffer> frameData) throws IOException {
        SpdyStreamSourceChannel channel;
        SpdyFrameParser frameParser = (SpdyFrameParser)frameHeaderData;
        if (!frameParser.control) {
            UndertowLogger.REQUEST_LOGGER.tracef("Dropping Frame of length %s for stream %s", frameParser.getFrameLength(), frameParser.dataFrameStreamId);
            return null;
        }
        switch (frameParser.type) {
            case 1: {
                SpdySynStreamParser parser = (SpdySynStreamParser)frameParser.parser;
                channel = new SpdySynStreamStreamSourceChannel(this, frameData, frameHeaderData.getFrameLength(), this.deflater, parser.getHeaderMap(), parser.streamId);
                this.lastGoodStreamId = parser.streamId;
                if (Bits.anyAreSet((int)frameParser.flags, (int)1)) break;
                this.incomingStreams.put(parser.streamId, (SpdyStreamStreamSourceChannel)channel);
                break;
            }
            case 2: {
                SpdySynReplyParser parser = (SpdySynReplyParser)frameParser.parser;
                channel = new SpdySynReplyStreamSourceChannel(this, frameData, frameHeaderData.getFrameLength(), parser.getHeaderMap(), parser.streamId);
                this.lastGoodStreamId = parser.streamId;
                if (Bits.anyAreSet((int)frameParser.flags, (int)1)) break;
                this.incomingStreams.put(parser.streamId, (SpdyStreamStreamSourceChannel)channel);
                break;
            }
            case 3: {
                SpdyRstStreamParser parser = (SpdyRstStreamParser)frameParser.parser;
                channel = new SpdyRstStreamStreamSourceChannel(this, frameData, frameParser.getFrameLength(), parser.getStreamId());
                this.handleRstStream(parser.getStreamId());
                break;
            }
            case 4: {
                this.updateSettings(((SpdySettingsParser)frameParser.parser).getSettings());
                channel = new SpdySettingsStreamSourceChannel(this, frameData, frameParser.getFrameLength(), ((SpdySettingsParser)frameParser.parser).getSettings());
                break;
            }
            case 6: {
                channel = new SpdyPingStreamSourceChannel(this, frameData, frameParser.getFrameLength(), ((SpdyPingParser)frameParser.parser).getId());
                break;
            }
            case 7: {
                SpdyGoAwayParser spdyGoAwayParser = (SpdyGoAwayParser)frameParser.parser;
                channel = new SpdyGoAwayStreamSourceChannel(this, frameData, frameParser.getFrameLength(), spdyGoAwayParser.getStatusCode(), spdyGoAwayParser.getLastGoodStreamId());
                this.peerGoneAway = true;
                break;
            }
            case 9: {
                SpdyWindowUpdateParser parser = (SpdyWindowUpdateParser)frameParser.parser;
                this.handleWindowUpdate(parser.getStreamId(), parser.getDeltaWindowSize());
                frameData.free();
                return null;
            }
            default: {
                throw UndertowMessages.MESSAGES.unexpectedFrameType(frameParser.type);
            }
        }
        if (Bits.anyAreSet((int)frameParser.flags, (int)1)) {
            channel.lastFrame();
        }
        return channel;
    }

    @Override
    protected FrameHeaderData parseFrame(ByteBuffer data) throws IOException {
        SpdyFrameParser frameParser = this.frameParser;
        if (frameParser == null) {
            this.frameParser = frameParser = new SpdyFrameParser();
        }
        if (!frameParser.handle(data)) {
            return null;
        }
        this.frameParser = null;
        return frameParser;
    }

    @Override
    protected void lastDataRead() {
        this.lastDataRead = true;
        if (!this.peerGoneAway && !this.thisGoneAway) {
            if (this.incomingStreams.size() > 0) {
                this.sendGoAway(1);
            } else {
                IoUtils.safeClose((Closeable)((Object)this));
            }
            this.peerGoneAway = true;
        }
    }

    @Override
    public boolean isOpen() {
        return super.isOpen() && !this.thisGoneAway && !this.peerGoneAway;
    }

    @Override
    protected boolean isLastFrameReceived() {
        return this.lastDataRead;
    }

    @Override
    protected boolean isLastFrameSent() {
        return this.thisGoneAway;
    }

    @Override
    protected void handleBrokenSourceChannel(Throwable e) {
        UndertowLogger.REQUEST_LOGGER.debugf(e, "Closing SPDY channel to %s due to broken read side", this.getPeerAddress());
        this.sendGoAway(1, new SpdyControlMessageExceptionHandler());
    }

    @Override
    protected void handleBrokenSinkChannel(Throwable e) {
        UndertowLogger.REQUEST_LOGGER.debugf(e, "Closing SPDY channel to %s due to broken write side", this.getPeerAddress());
        IoUtils.safeClose((Closeable)((Object)this));
    }

    @Override
    protected void closeSubChannels() {
        Object receiver;
        for (Map.Entry<Integer, SpdyStreamStreamSourceChannel> entry : this.incomingStreams.entrySet()) {
            receiver = entry.getValue();
            if (((AbstractFramedStreamSourceChannel)receiver).isReadResumed()) {
                ChannelListeners.invokeChannelListener((Executor)((AbstractFramedStreamSourceChannel)receiver).getIoThread(), (Channel)receiver, (ChannelListener)((ChannelListener.SimpleSetter)((AbstractFramedStreamSourceChannel)receiver).getReadSetter()).get());
            }
            IoUtils.safeClose((Closeable)receiver);
        }
        this.incomingStreams.clear();
        for (Map.Entry<Integer, Object> entry : this.outgoingStreams.entrySet()) {
            receiver = (SpdyStreamStreamSinkChannel)entry.getValue();
            if (((AbstractFramedStreamSinkChannel)receiver).isWritesShutdown()) {
                ChannelListeners.invokeChannelListener((Executor)((AbstractFramedStreamSinkChannel)receiver).getIoThread(), (Channel)receiver, (ChannelListener)((ChannelListener.SimpleSetter)((AbstractFramedStreamSinkChannel)receiver).getWriteSetter()).get());
            }
            IoUtils.safeClose((Closeable)receiver);
        }
        this.outgoingStreams.clear();
    }

    synchronized void updateSettings(List<SpdySetting> settings) {
        for (SpdySetting setting : settings) {
            if (setting.getId() != 7) continue;
            int old = this.initialWindowSize;
            this.initialWindowSize = setting.getValue();
            int difference = this.initialWindowSize - old;
            this.receiveWindowSize += difference;
            this.sendWindowSize += difference;
        }
    }

    public int getSpdyVersion() {
        return 3;
    }

    Pool<ByteBuffer> getHeapBufferPool() {
        return this.heapBufferPool;
    }

    int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public synchronized void handleWindowUpdate(int streamId, int deltaWindowSize) throws IOException {
        if (streamId == 0) {
            boolean exhausted = this.sendWindowSize == 0;
            this.sendWindowSize += deltaWindowSize;
            if (exhausted) {
                this.notifyFlowControlAllowed();
            }
        } else {
            SpdyStreamStreamSinkChannel stream = this.outgoingStreams.get(streamId);
            if (stream != null) {
                stream.updateFlowControlWindow(deltaWindowSize);
            }
        }
    }

    synchronized void notifyFlowControlAllowed() throws IOException {
        super.recalculateHeldFrames();
    }

    public void sendPing(int id) {
        this.sendPing(id, new SpdyControlMessageExceptionHandler());
    }

    public void sendPing(int id, ChannelExceptionHandler<SpdyStreamSinkChannel> exceptionHandler) {
        SpdyPingStreamSinkChannel ping = new SpdyPingStreamSinkChannel(this, id);
        try {
            ping.shutdownWrites();
            if (!ping.flush()) {
                ping.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, exceptionHandler));
                ping.resumeWrites();
            }
        }
        catch (IOException e) {
            exceptionHandler.handleException((Channel)((Object)ping), e);
        }
    }

    public void sendGoAway(int status) {
        this.sendGoAway(status, new SpdyControlMessageExceptionHandler());
    }

    public void sendGoAway(int status, ChannelExceptionHandler<SpdyStreamSinkChannel> exceptionHandler) {
        if (this.thisGoneAway) {
            return;
        }
        this.thisGoneAway = true;
        SpdyGoAwayStreamSinkChannel goAway = new SpdyGoAwayStreamSinkChannel(this, status, this.lastGoodStreamId);
        try {
            goAway.shutdownWrites();
            if (!goAway.flush()) {
                goAway.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, exceptionHandler));
                goAway.resumeWrites();
            }
        }
        catch (IOException e) {
            exceptionHandler.handleException((Channel)((Object)goAway), e);
        }
    }

    public void sendUpdateWindowSize(int streamId, int delta) {
        SpdyWindowUpdateStreamSinkChannel windowUpdateStreamSinkChannel = new SpdyWindowUpdateStreamSinkChannel(this, streamId, delta);
        try {
            windowUpdateStreamSinkChannel.shutdownWrites();
            if (!windowUpdateStreamSinkChannel.flush()) {
                windowUpdateStreamSinkChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, (ChannelExceptionHandler)new SpdyControlMessageExceptionHandler()));
                windowUpdateStreamSinkChannel.resumeWrites();
            }
        }
        catch (IOException e) {
            this.handleBrokenSinkChannel(e);
        }
    }

    public SSLSession getSslSession() {
        StreamConnection con = this.getUnderlyingConnection();
        if (con instanceof SslConnection) {
            return ((SslConnection)con).getSslSession();
        }
        return null;
    }

    public synchronized void updateReceiveFlowControlWindow(int read) {
        if (read <= 0) {
            return;
        }
        this.receiveWindowSize -= read;
        int initialWindowSize = this.initialWindowSize;
        if (this.receiveWindowSize < initialWindowSize / 2) {
            int delta = initialWindowSize - this.receiveWindowSize;
            this.receiveWindowSize += delta;
            this.sendUpdateWindowSize(0, delta);
        }
    }

    public synchronized SpdySynStreamStreamSinkChannel createStream(HeaderMap requestHeaders) throws IOException {
        return this.createStream(0, requestHeaders);
    }

    public synchronized SpdySynStreamStreamSinkChannel createStream(int associatedStreamId, HeaderMap requestHeaders) throws IOException {
        if (!this.isOpen()) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        int streamId = this.streamIdCounter;
        this.streamIdCounter += 2;
        SpdySynStreamStreamSinkChannel spdySynStreamStreamSinkChannel = new SpdySynStreamStreamSinkChannel(this, requestHeaders, streamId, this.deflater, associatedStreamId);
        this.outgoingStreams.put(streamId, spdySynStreamStreamSinkChannel);
        return spdySynStreamStreamSinkChannel;
    }

    synchronized int grabFlowControlBytes(int bytesToGrab) {
        int min = Math.min(bytesToGrab, this.sendWindowSize);
        this.sendWindowSize -= min;
        return min;
    }

    void registerStreamSink(SpdySynReplyStreamSinkChannel synResponse) {
        this.outgoingStreams.put(synResponse.getStreamId(), synResponse);
    }

    void removeStreamSink(int streamId) {
        this.outgoingStreams.remove(streamId);
        if (this.isLastFrameReceived() && this.outgoingStreams.isEmpty()) {
            this.sendGoAway(0);
        }
    }

    public boolean isClient() {
        return this.streamIdCounter % 2 == 1;
    }

    @Override
    public <T> T getAttachment(AttachmentKey<T> key) {
        if (key == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("key");
        }
        return (T)this.attachments.get(key);
    }

    @Override
    public <T> List<T> getAttachmentList(AttachmentKey<? extends List<T>> key) {
        if (key == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("key");
        }
        Object o = this.attachments.get(key);
        if (o == null) {
            return Collections.emptyList();
        }
        return (List)o;
    }

    @Override
    public <T> T putAttachment(AttachmentKey<T> key, T value) {
        if (key == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("key");
        }
        return key.cast(this.attachments.put(key, key.cast(value)));
    }

    @Override
    public <T> T removeAttachment(AttachmentKey<T> key) {
        return key.cast(this.attachments.remove(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addToAttachmentList(AttachmentKey<AttachmentList<T>> key, T value) {
        Map<AttachmentKey<?>, Object> attachments;
        if (key == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("key");
        }
        Map<AttachmentKey<?>, Object> map = attachments = this.attachments;
        synchronized (map) {
            List list = key.cast(attachments.get(key));
            if (list == null) {
                AttachmentList<Object> newList = new AttachmentList<Object>(Object.class);
                attachments.put(key, newList);
                newList.add(value);
            } else {
                list.add(value);
            }
        }
    }

    public void sendRstStream(int streamId, int statusCode) {
        this.handleRstStream(streamId);
        try {
            SpdyRstStreamSinkChannel channel = new SpdyRstStreamSinkChannel(this, streamId, statusCode);
            channel.shutdownWrites();
            if (!channel.flush()) {
                channel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, (ChannelExceptionHandler)new ChannelExceptionHandler<SpdyStreamSinkChannel>(){

                    public void handleException(SpdyStreamSinkChannel channel, IOException exception) {
                        SpdyChannel.this.markWritesBroken(exception);
                    }
                }));
                channel.resumeWrites();
            }
        }
        catch (IOException e) {
            this.markWritesBroken(e);
        }
    }

    private void handleRstStream(int streamId) {
        SpdyStreamStreamSinkChannel outgoing;
        SpdyStreamSourceChannel incoming = this.incomingStreams.remove(streamId);
        if (incoming != null) {
            incoming.rstStream();
        }
        if ((outgoing = this.outgoingStreams.remove(streamId)) != null) {
            outgoing.rstStream();
        }
    }

    private class SpdyControlMessageExceptionHandler
    implements ChannelExceptionHandler<SpdyStreamSinkChannel> {
        private SpdyControlMessageExceptionHandler() {
        }

        public void handleException(SpdyStreamSinkChannel channel, IOException exception) {
            IoUtils.safeClose((Closeable)((Object)channel));
            SpdyChannel.this.handleBrokenSinkChannel(exception);
        }
    }

    class SpdyFrameParser
    implements FrameHeaderData {
        final byte[] header = new byte[8];
        int read = 0;
        boolean control;
        int version;
        int type;
        int dataFrameStreamId;
        int flags;
        int length;
        SpdyPushBackParser parser = null;
        private static final int CONTROL_MASK = 128;

        SpdyFrameParser() {
        }

        public boolean handle(ByteBuffer byteBuffer) throws IOException {
            if (this.parser == null) {
                if (!this.parseFrameHeader(byteBuffer)) {
                    return false;
                }
                if (!this.control) {
                    return true;
                }
                switch (this.type) {
                    case 1: {
                        this.parser = new SpdySynStreamParser(SpdyChannel.this.getBufferPool(), SpdyChannel.this, this.length, SpdyChannel.this.inflater);
                        break;
                    }
                    case 3: {
                        this.parser = new SpdyRstStreamParser(SpdyChannel.this.getBufferPool(), this.length);
                        break;
                    }
                    case 8: {
                        this.parser = new SpdyHeadersParser(SpdyChannel.this.getBufferPool(), SpdyChannel.this, this.length, SpdyChannel.this.inflater);
                        break;
                    }
                    case 2: {
                        this.parser = new SpdySynReplyParser(SpdyChannel.this.getBufferPool(), SpdyChannel.this, this.length, SpdyChannel.this.inflater);
                        break;
                    }
                    case 7: {
                        this.parser = new SpdyGoAwayParser(SpdyChannel.this.getBufferPool(), this.length);
                        SpdyChannel.this.peerGoneAway = true;
                        break;
                    }
                    case 6: {
                        this.parser = new SpdyPingParser(SpdyChannel.this.getBufferPool(), this.length);
                        break;
                    }
                    case 4: {
                        this.parser = new SpdySettingsParser(this.length);
                        break;
                    }
                    case 9: {
                        this.parser = new SpdyWindowUpdateParser(this.length);
                        break;
                    }
                    default: {
                        return true;
                    }
                }
            }
            this.parser.parse(byteBuffer);
            return this.parser.isFinished();
        }

        private boolean parseFrameHeader(ByteBuffer byteBuffer) {
            while (this.read < 8 && byteBuffer.hasRemaining()) {
                this.header[this.read++] = byteBuffer.get();
            }
            if (this.read != 8) {
                return false;
            }
            boolean bl = this.control = (this.header[0] & 0x80) != 0;
            if (this.control) {
                this.version = (this.header[0] & 0xFFFFFF7F & 0xFF) << 8;
                this.version += this.header[1] & 0xFF;
                this.type = (this.header[2] & 0xFF) << 8;
                this.type += this.header[3] & 0xFF;
            } else {
                this.dataFrameStreamId = (this.header[0] & 0xFFFFFF7F & 0xFF) << 24;
                this.dataFrameStreamId += (this.header[1] & 0xFF) << 16;
                this.dataFrameStreamId += (this.header[2] & 0xFF) << 8;
                this.dataFrameStreamId += this.header[3] & 0xFF;
            }
            this.flags = this.header[4] & 0xFF;
            this.length = (this.header[5] & 0xFF) << 16;
            this.length = (this.header[6] & 0xFF) << 8;
            this.length += this.header[7] & 0xFF;
            return true;
        }

        @Override
        public long getFrameLength() {
            if (this.control) {
                return 0L;
            }
            return this.length;
        }

        @Override
        public AbstractFramedStreamSourceChannel<?, ?, ?> getExistingChannel() {
            int id;
            if (this.type == 1 || this.type == 9) {
                return null;
            }
            if (this.control) {
                id = this.parser.getStreamId();
                if (id == -1) {
                    return null;
                }
            } else {
                id = this.dataFrameStreamId;
            }
            if (Bits.anyAreSet((int)this.flags, (int)1)) {
                return (AbstractFramedStreamSourceChannel)SpdyChannel.this.incomingStreams.remove(id);
            }
            return (AbstractFramedStreamSourceChannel)SpdyChannel.this.incomingStreams.get(id);
        }
    }
}

