/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.handlers.resource.PathResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeEvent;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.xnio.FileChangeCallback;
import org.xnio.FileChangeEvent;
import org.xnio.FileSystemWatcher;
import org.xnio.OptionMap;
import org.xnio.Xnio;

public class PathResourceManager
implements ResourceManager {
    private final List<ResourceChangeListener> listeners = new ArrayList<ResourceChangeListener>();
    private FileSystemWatcher fileSystemWatcher;
    protected volatile String base;
    private final long transferMinSize;
    private final boolean caseSensitive;
    private final boolean followLinks;
    private final TreeSet<String> safePaths = new TreeSet();

    public PathResourceManager(Path base, long transferMinSize) {
        this(base, transferMinSize, true, false, null);
    }

    public PathResourceManager(Path base, long transferMinSize, boolean caseSensitive) {
        this(base, transferMinSize, caseSensitive, false, null);
    }

    public PathResourceManager(Path base, long transferMinSize, boolean followLinks, String ... safePaths) {
        this(base, transferMinSize, true, followLinks, safePaths);
    }

    protected PathResourceManager(long transferMinSize, boolean caseSensitive, boolean followLinks, String ... safePaths) {
        this.caseSensitive = caseSensitive;
        this.followLinks = followLinks;
        this.transferMinSize = transferMinSize;
        if (this.followLinks) {
            if (safePaths == null) {
                throw UndertowMessages.MESSAGES.argumentCannotBeNull("safePaths");
            }
            for (String safePath : safePaths) {
                if (safePath != null) continue;
                throw UndertowMessages.MESSAGES.argumentCannotBeNull("safePaths");
            }
            this.safePaths.addAll(Arrays.asList(safePaths));
        }
    }

    public PathResourceManager(Path base, long transferMinSize, boolean caseSensitive, boolean followLinks, String ... safePaths) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        String basePath = base.toAbsolutePath().toString();
        if (!basePath.endsWith("/")) {
            basePath = basePath + '/';
        }
        this.base = basePath;
        this.transferMinSize = transferMinSize;
        this.caseSensitive = caseSensitive;
        this.followLinks = followLinks;
        if (this.followLinks) {
            if (safePaths == null) {
                throw UndertowMessages.MESSAGES.argumentCannotBeNull("safePaths");
            }
            for (String safePath : safePaths) {
                if (safePath != null) continue;
                throw UndertowMessages.MESSAGES.argumentCannotBeNull("safePaths");
            }
            this.safePaths.addAll(Arrays.asList(safePaths));
        }
    }

    public Path getBasePath() {
        return Paths.get(this.base, new String[0]);
    }

    public PathResourceManager setBase(Path base) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        String basePath = base.toAbsolutePath().toString();
        if (!basePath.endsWith("/")) {
            basePath = basePath + '/';
        }
        this.base = basePath;
        return this;
    }

    public PathResourceManager setBase(File base) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        String basePath = base.getAbsolutePath();
        if (!basePath.endsWith("/")) {
            basePath = basePath + '/';
        }
        this.base = basePath;
        return this;
    }

    @Override
    public Resource getResource(String p) {
        String path = p.startsWith("/") ? p.substring(1) : p;
        try {
            Path file = Paths.get(this.base, path);
            if (Files.exists(file, new LinkOption[0])) {
                boolean followAll;
                if (path.endsWith("/") && !Files.isDirectory(file, new LinkOption[0])) {
                    return null;
                }
                boolean bl = followAll = this.followLinks && this.safePaths.isEmpty();
                if (!followAll && this.isSymlinkPath(this.base, file)) {
                    if (this.followLinks && this.isSymlinkSafe(file)) {
                        return this.getFileResource(file, path);
                    }
                } else {
                    return this.getFileResource(file, path);
                }
            }
            return null;
        }
        catch (Exception e) {
            UndertowLogger.REQUEST_LOGGER.debugf(e, "Invalid path %s", new Object[0]);
            return null;
        }
    }

    @Override
    public boolean isResourceChangeListenerSupported() {
        return true;
    }

    @Override
    public synchronized void registerResourceChangeListener(ResourceChangeListener listener) {
        this.listeners.add(listener);
        if (this.fileSystemWatcher == null) {
            this.fileSystemWatcher = Xnio.getInstance().createFileSystemWatcher("Watcher for " + this.base, OptionMap.EMPTY);
            this.fileSystemWatcher.watchPath(new File(this.base), new FileChangeCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleChanges(Collection<FileChangeEvent> changes) {
                    PathResourceManager pathResourceManager = PathResourceManager.this;
                    synchronized (pathResourceManager) {
                        ArrayList<ResourceChangeEvent> events = new ArrayList<ResourceChangeEvent>();
                        for (FileChangeEvent change : changes) {
                            if (!change.getFile().getAbsolutePath().startsWith(PathResourceManager.this.base)) continue;
                            String path = change.getFile().getAbsolutePath().substring(PathResourceManager.this.base.length());
                            events.add(new ResourceChangeEvent(path, ResourceChangeEvent.Type.valueOf(change.getType().name())));
                        }
                        for (ResourceChangeListener listener : PathResourceManager.this.listeners) {
                            listener.handleChanges(events);
                        }
                    }
                }
            });
        }
    }

    @Override
    public synchronized void removeResourceChangeListener(ResourceChangeListener listener) {
        this.listeners.remove(listener);
    }

    public long getTransferMinSize() {
        return this.transferMinSize;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.fileSystemWatcher != null) {
            this.fileSystemWatcher.close();
        }
    }

    private boolean isSymlinkPath(String base, Path file) throws IOException {
        Path root;
        int rootCount;
        int nameCount = file.getNameCount();
        if (nameCount > (rootCount = (root = Paths.get(base, new String[0])).getNameCount())) {
            Path f = root;
            for (int i = rootCount; i < nameCount; ++i) {
                if (!Files.isSymbolicLink(f = f.resolve(file.getName(i).toString()))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isFileSameCase(Path file) throws IOException {
        String canonicalName = file.toRealPath(new LinkOption[0]).getFileName().toString();
        if (canonicalName.equals(file.getFileName().toString())) {
            return true;
        }
        return !canonicalName.equalsIgnoreCase(file.getFileName().toString());
    }

    private boolean isSymlinkSafe(Path file) throws IOException {
        String canonicalPath = file.toRealPath(new LinkOption[0]).toString();
        for (String safePath : this.safePaths) {
            String absSafePath;
            Path absSafePathFile;
            String canonicalSafePath;
            if (safePath.length() <= 0 || !(safePath.charAt(0) == '/' ? safePath.length() > 0 && canonicalPath.length() >= safePath.length() && canonicalPath.startsWith(safePath) : (canonicalSafePath = (absSafePathFile = Paths.get(absSafePath = this.base + '/' + safePath, new String[0])).toRealPath(new LinkOption[0]).toString()).length() > 0 && canonicalPath.length() >= canonicalSafePath.length() && canonicalPath.startsWith(canonicalSafePath))) continue;
            return true;
        }
        return false;
    }

    protected PathResource getFileResource(Path file, String path) throws IOException {
        if (this.caseSensitive) {
            if (this.isFileSameCase(file)) {
                return new PathResource(file, this, path);
            }
            return null;
        }
        return new PathResource(file, this, path);
    }
}

