/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ServletSessionAttribute
implements ExchangeAttribute {
    private final String attributeName;

    public ServletSessionAttribute(String attributeName) {
        this.attributeName = attributeName;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        Object result;
        HttpSession session;
        ServletRequest req;
        ServletRequestContext context = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (context != null && (req = context.getServletRequest()) instanceof HttpServletRequest && (session = ((HttpServletRequest)req).getSession(false)) != null && (result = session.getAttribute(this.attributeName)) != null) {
            return result.toString();
        }
        return null;
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        HttpSession session;
        ServletRequest req;
        ServletRequestContext context = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (context != null && (req = context.getServletRequest()) instanceof HttpServletRequest && (session = ((HttpServletRequest)req).getSession(false)) != null) {
            session.setAttribute(this.attributeName, newValue);
        }
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Servlet session attribute";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("%{s,") && token.endsWith("}")) {
                String attributeName = token.substring(4, token.length() - 1);
                return new ServletSessionAttribute(attributeName);
            }
            return null;
        }
    }
}

