/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.error;

import io.undertow.io.Sender;
import io.undertow.server.DefaultResponseListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.Headers;
import io.undertow.util.StatusCodes;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SimpleErrorPageHandler
implements HttpHandler {
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;
    private volatile Set<Integer> responseCodes = null;

    public SimpleErrorPageHandler(HttpHandler next) {
        this.next = next;
    }

    public SimpleErrorPageHandler() {
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addDefaultResponseListener(new DefaultResponseListener(){

            @Override
            public boolean handleDefaultResponse(HttpServerExchange exchange) {
                if (!exchange.isResponseChannelAvailable()) {
                    return false;
                }
                Set codes = SimpleErrorPageHandler.this.responseCodes;
                if (codes == null ? exchange.getResponseCode() >= 400 : codes.contains(exchange.getResponseCode())) {
                    String errorPage = "<html><head><title>Error</title></head><body>" + exchange.getResponseCode() + " - " + StatusCodes.getReason(exchange.getResponseCode()) + "</body></html>";
                    exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "" + errorPage.length());
                    exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/html");
                    Sender sender = exchange.getResponseSender();
                    sender.send(errorPage);
                    return true;
                }
                return false;
            }
        });
        this.next.handleRequest(exchange);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public SimpleErrorPageHandler setNext(HttpHandler next) {
        HttpHandlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    public Set<Integer> getResponseCodes() {
        return Collections.unmodifiableSet(this.responseCodes);
    }

    public SimpleErrorPageHandler setResponseCodes(Set<Integer> responseCodes) {
        this.responseCodes = new HashSet<Integer>(responseCodes);
        return this;
    }

    public SimpleErrorPageHandler setResponseCodes(Integer ... responseCodes) {
        this.responseCodes = new HashSet<Integer>(Arrays.asList(responseCodes));
        return this;
    }
}

