/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio._private.Messages;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.ssl.JsseSslConduitEngine;

final class JsseSslStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final JsseSslConduitEngine sslEngine;
    private volatile boolean tls;

    protected JsseSslStreamSinkConduit(StreamSinkConduit next, JsseSslConduitEngine sslEngine, boolean tls) {
        super(next);
        if (sslEngine == null) {
            throw Messages.msg.nullParameter("sslEngine");
        }
        this.sslEngine = sslEngine;
        this.tls = tls;
    }

    public void enableTls() {
        this.tls = true;
        if (this.isWriteResumed()) {
            this.wakeupWrites();
        }
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return Conduits.transfer(source, count, throughBuffer, this);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!this.tls) {
            return super.write(src);
        }
        int wrappedBytes = this.sslEngine.wrap(src);
        if (wrappedBytes > 0) {
            this.writeWrappedBuffer();
        }
        return wrappedBytes;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        if (!this.tls) {
            return super.write(srcs, offs, len);
        }
        long wrappedBytes = this.sslEngine.wrap(srcs, offs, len);
        if (wrappedBytes > 0L) {
            this.writeWrappedBuffer();
        }
        return wrappedBytes;
    }

    @Override
    public void resumeWrites() {
        if (this.tls && this.sslEngine.isFirstHandshake()) {
            super.wakeupWrites();
        } else {
            super.resumeWrites();
        }
    }

    @Override
    public void terminateWrites() throws IOException {
        if (!this.tls) {
            super.terminateWrites();
            return;
        }
        this.sslEngine.closeOutbound();
        this.flush();
    }

    @Override
    public void awaitWritable() throws IOException {
        if (this.tls) {
            this.sslEngine.awaitCanWrap();
        }
        super.awaitWritable();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (!this.tls) {
            super.awaitWritable(time, timeUnit);
            return;
        }
        long duration = timeUnit.toNanos(time);
        long awaited = System.nanoTime();
        this.sslEngine.awaitCanWrap(time, timeUnit);
        awaited = System.nanoTime() - awaited;
        if (awaited > duration) {
            return;
        }
        super.awaitWritable(duration - awaited, TimeUnit.NANOSECONDS);
    }

    @Override
    public void truncateWrites() throws IOException {
        if (this.tls) {
            this.sslEngine.closeOutbound();
        }
        super.truncateWrites();
    }

    @Override
    public boolean flush() throws IOException {
        if (!this.tls) {
            return super.flush();
        }
        if (this.sslEngine.isOutboundClosed()) {
            if (this.sslEngine.flush() && this.writeWrappedBuffer() && super.flush()) {
                super.terminateWrites();
                return true;
            }
            return false;
        }
        return this.sslEngine.flush() && this.writeWrappedBuffer() && super.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeWrappedBuffer() throws IOException {
        Object object = this.sslEngine.getWrapLock();
        synchronized (object) {
            ByteBuffer wrapBuffer = this.sslEngine.getWrappedBuffer();
            while (true) {
                try {
                    do {
                        if (wrapBuffer.flip().hasRemaining()) continue;
                        boolean bl = true;
                        return bl;
                    } while (super.write(wrapBuffer) != 0);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    wrapBuffer.compact();
                    continue;
                }
                break;
            }
        }
    }
}

