/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.PathMatcher;

public class PathHandler
implements HttpHandler {
    private final PathMatcher<HttpHandler> pathMatcher = new PathMatcher();

    public PathHandler(HttpHandler defaultHandler) {
        this.pathMatcher.addPrefixPath("/", defaultHandler);
    }

    public PathHandler() {
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        PathMatcher.PathMatch<HttpHandler> match = this.pathMatcher.match(exchange.getRelativePath());
        if (match.getValue() == null) {
            ResponseCodeHandler.HANDLE_404.handleRequest(exchange);
            return;
        }
        exchange.setRelativePath(match.getRemaining());
        exchange.setResolvedPath(exchange.getRequestPath().substring(0, exchange.getRequestPath().length() - match.getRemaining().length()));
        match.getValue().handleRequest(exchange);
    }

    @Deprecated
    public synchronized PathHandler addPath(String path, HttpHandler handler) {
        return this.addPrefixPath(path, handler);
    }

    public synchronized PathHandler addPrefixPath(String path, HttpHandler handler) {
        Handlers.handlerNotNull(handler);
        this.pathMatcher.addPrefixPath(path, handler);
        return this;
    }

    public synchronized PathHandler addExactPath(String path, HttpHandler handler) {
        Handlers.handlerNotNull(handler);
        this.pathMatcher.addExactPath(path, handler);
        return this;
    }

    @Deprecated
    public synchronized PathHandler removePath(String path) {
        return this.removePrefixPath(path);
    }

    public synchronized PathHandler removePrefixPath(String path) {
        this.pathMatcher.removePrefixPath(path);
        return this;
    }

    public synchronized PathHandler removeExactPath(String path) {
        this.pathMatcher.removeExactPath(path);
        return this;
    }

    public synchronized PathHandler clearPaths() {
        this.pathMatcher.clearPaths();
        return this;
    }
}

