/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.api;

import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.ConfidentialPortManager;
import io.undertow.servlet.api.DefaultServletConfig;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.FilterMappingInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.MimeMapping;
import io.undertow.servlet.api.ResourceLoader;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.util.DefaultClassIntrospector;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.servlet.DispatcherType;
import javax.servlet.descriptor.JspConfigDescriptor;

public class DeploymentInfo
implements Cloneable {
    private volatile String deploymentName;
    private volatile String displayName;
    private volatile String contextPath;
    private volatile ClassLoader classLoader;
    private volatile ResourceLoader resourceLoader = ResourceLoader.EMPTY_RESOURCE_LOADER;
    private volatile ClassIntrospecter classIntrospecter = DefaultClassIntrospector.INSTANCE;
    private volatile int majorVersion = 3;
    private volatile int minorVersion;
    private volatile InstanceFactory<Executor> executorFactory;
    private volatile InstanceFactory<Executor> asyncExecutorFactory;
    private volatile File tempDir;
    private volatile JspConfigDescriptor jspConfigDescriptor;
    private volatile DefaultServletConfig defaultServletConfig;
    private volatile SessionManager sessionManager = new InMemorySessionManager();
    private volatile LoginConfig loginConfig;
    private volatile IdentityManager identityManager;
    private volatile ConfidentialPortManager confidentialPortManager;
    private final Map<String, ServletInfo> servlets = new HashMap<String, ServletInfo>();
    private final Map<String, FilterInfo> filters = new HashMap<String, FilterInfo>();
    private final List<FilterMappingInfo> filterServletNameMappings = new ArrayList<FilterMappingInfo>();
    private final List<FilterMappingInfo> filterUrlMappings = new ArrayList<FilterMappingInfo>();
    private final List<ListenerInfo> listeners = new ArrayList<ListenerInfo>();
    private final List<ServletContainerInitializerInfo> servletContainerInitializers = new ArrayList<ServletContainerInitializerInfo>();
    private final List<ThreadSetupAction> threadSetupActions = new ArrayList<ThreadSetupAction>();
    private final Map<String, String> initParameters = new HashMap<String, String>();
    private final Map<String, Object> servletContextAttributes = new HashMap<String, Object>();
    private final Map<String, String> localeCharsetMapping = new HashMap<String, String>();
    private final List<String> welcomePages = new ArrayList<String>();
    private final List<ErrorPage> errorPages = new ArrayList<ErrorPage>();
    private final List<MimeMapping> mimeMappings = new ArrayList<MimeMapping>();
    private final List<SecurityConstraint> securityConstraints = new ArrayList<SecurityConstraint>();
    private final Map<String, Set<String>> principleVsRoleMapping = new HashMap<String, Set<String>>();
    private final Set<String> securityRoles = new HashSet<String>();
    private final List<NotificationReceiver> notificationReceivers = new ArrayList<NotificationReceiver>();
    private final List<HandlerWrapper> outerHandlerChainWrappers = new ArrayList<HandlerWrapper>();
    private final List<HandlerWrapper> innerHandlerChainWrappers = new ArrayList<HandlerWrapper>();
    private final List<HandlerWrapper> dispatchedHandlerChainWrappers = new ArrayList<HandlerWrapper>();

    public void validate() {
        if (this.deploymentName == null) {
            throw UndertowServletMessages.MESSAGES.paramCannotBeNull("deploymentName");
        }
        if (this.contextPath == null) {
            throw UndertowServletMessages.MESSAGES.paramCannotBeNull("contextName");
        }
        if (this.classLoader == null) {
            throw UndertowServletMessages.MESSAGES.paramCannotBeNull("classLoader");
        }
        if (this.resourceLoader == null) {
            throw UndertowServletMessages.MESSAGES.paramCannotBeNull("resourceLoader");
        }
        if (this.classIntrospecter == null) {
            throw UndertowServletMessages.MESSAGES.paramCannotBeNull("classIntrospecter");
        }
        for (ServletInfo servlet : this.servlets.values()) {
            servlet.validate();
        }
        for (FilterInfo filter : this.filters.values()) {
            filter.validate();
        }
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public DeploymentInfo setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public DeploymentInfo setContextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public DeploymentInfo setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public DeploymentInfo setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        return this;
    }

    public ClassIntrospecter getClassIntrospecter() {
        return this.classIntrospecter;
    }

    public DeploymentInfo setClassIntrospecter(ClassIntrospecter classIntrospecter) {
        this.classIntrospecter = classIntrospecter;
        return this;
    }

    public DeploymentInfo addServlet(ServletInfo servlet) {
        this.servlets.put(servlet.getName(), servlet);
        return this;
    }

    public DeploymentInfo addServlets(ServletInfo ... servlets) {
        for (ServletInfo servlet : servlets) {
            this.servlets.put(servlet.getName(), servlet);
        }
        return this;
    }

    public DeploymentInfo addServlets(Collection<ServletInfo> servlets) {
        for (ServletInfo servlet : servlets) {
            this.servlets.put(servlet.getName(), servlet);
        }
        return this;
    }

    public Map<String, ServletInfo> getServlets() {
        return Collections.unmodifiableMap(this.servlets);
    }

    public DeploymentInfo addFilter(FilterInfo filter) {
        this.filters.put(filter.getName(), filter);
        return this;
    }

    public DeploymentInfo addFilters(FilterInfo ... filters) {
        for (FilterInfo filter : filters) {
            this.filters.put(filter.getName(), filter);
        }
        return this;
    }

    public DeploymentInfo addFilters(Collection<FilterInfo> filters) {
        for (FilterInfo filter : filters) {
            this.filters.put(filter.getName(), filter);
        }
        return this;
    }

    public Map<String, FilterInfo> getFilters() {
        return Collections.unmodifiableMap(this.filters);
    }

    public DeploymentInfo addFilterUrlMapping(String filterName, String mapping, DispatcherType dispatcher) {
        this.filterUrlMappings.add(new FilterMappingInfo(filterName, FilterMappingInfo.MappingType.URL, mapping, dispatcher));
        return this;
    }

    public DeploymentInfo addFilterServletNameMapping(String filterName, String mapping, DispatcherType dispatcher) {
        this.filterServletNameMappings.add(new FilterMappingInfo(filterName, FilterMappingInfo.MappingType.SERVLET, mapping, dispatcher));
        return this;
    }

    public DeploymentInfo insertFilterUrlMapping(int pos, String filterName, String mapping, DispatcherType dispatcher) {
        this.filterUrlMappings.add(pos, new FilterMappingInfo(filterName, FilterMappingInfo.MappingType.URL, mapping, dispatcher));
        return this;
    }

    public DeploymentInfo insertFilterServletNameMapping(int pos, String filterName, String mapping, DispatcherType dispatcher) {
        this.filterServletNameMappings.add(pos, new FilterMappingInfo(filterName, FilterMappingInfo.MappingType.SERVLET, mapping, dispatcher));
        return this;
    }

    public List<FilterMappingInfo> getFilterMappings() {
        ArrayList<FilterMappingInfo> ret = new ArrayList<FilterMappingInfo>(this.filterUrlMappings);
        ret.addAll(this.filterServletNameMappings);
        return Collections.unmodifiableList(ret);
    }

    public DeploymentInfo addListener(ListenerInfo listener) {
        this.listeners.add(listener);
        return this;
    }

    public DeploymentInfo addListeners(ListenerInfo ... listeners) {
        this.listeners.addAll(Arrays.asList(listeners));
        return this;
    }

    public DeploymentInfo addListeners(Collection<ListenerInfo> listeners) {
        this.listeners.addAll(listeners);
        return this;
    }

    public List<ListenerInfo> getListeners() {
        return this.listeners;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public DeploymentInfo setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
        return this;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public DeploymentInfo setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
        return this;
    }

    public DeploymentInfo addServletContainerInitalizer(ServletContainerInitializerInfo servletContainerInitializer) {
        this.servletContainerInitializers.add(servletContainerInitializer);
        return this;
    }

    public DeploymentInfo addServletContainerInitalizers(ServletContainerInitializerInfo ... servletContainerInitializer) {
        this.servletContainerInitializers.addAll(Arrays.asList(servletContainerInitializer));
        return this;
    }

    public DeploymentInfo addServletContainerInitalizers(List<ServletContainerInitializerInfo> servletContainerInitializer) {
        this.servletContainerInitializers.addAll(servletContainerInitializer);
        return this;
    }

    public List<ServletContainerInitializerInfo> getServletContainerInitializers() {
        return this.servletContainerInitializers;
    }

    public DeploymentInfo addThreadSetupAction(ThreadSetupAction action) {
        this.threadSetupActions.add(action);
        return this;
    }

    public List<ThreadSetupAction> getThreadSetupActions() {
        return this.threadSetupActions;
    }

    public DeploymentInfo addInitParameter(String name, String value) {
        this.initParameters.put(name, value);
        return this;
    }

    public Map<String, String> getInitParameters() {
        return Collections.unmodifiableMap(this.initParameters);
    }

    public DeploymentInfo addServletContextAttribute(String name, Object value) {
        this.servletContextAttributes.put(name, value);
        return this;
    }

    public Map<String, Object> getServletContextAttributes() {
        return Collections.unmodifiableMap(this.servletContextAttributes);
    }

    public DeploymentInfo addWelcomePages(String welcomePage) {
        this.welcomePages.add(welcomePage);
        return this;
    }

    public DeploymentInfo addWelcomePages(String ... welcomePages) {
        this.welcomePages.addAll(Arrays.asList(welcomePages));
        return this;
    }

    public DeploymentInfo addWelcomePages(Collection<String> welcomePages) {
        this.welcomePages.addAll(welcomePages);
        return this;
    }

    public List<String> getWelcomePages() {
        return Collections.unmodifiableList(this.welcomePages);
    }

    public DeploymentInfo addErrorPage(ErrorPage errorPage) {
        this.errorPages.add(errorPage);
        return this;
    }

    public DeploymentInfo addErrorPages(ErrorPage ... errorPages) {
        this.errorPages.addAll(Arrays.asList(errorPages));
        return this;
    }

    public DeploymentInfo addErrorPages(Collection<ErrorPage> errorPages) {
        this.errorPages.addAll(errorPages);
        return this;
    }

    public List<ErrorPage> getErrorPages() {
        return Collections.unmodifiableList(this.errorPages);
    }

    public DeploymentInfo addMimeMapping(MimeMapping mimeMappings) {
        this.mimeMappings.add(mimeMappings);
        return this;
    }

    public DeploymentInfo addMimeMappings(MimeMapping ... mimeMappings) {
        this.mimeMappings.addAll(Arrays.asList(mimeMappings));
        return this;
    }

    public DeploymentInfo addMimeMappings(Collection<MimeMapping> mimeMappings) {
        this.mimeMappings.addAll(mimeMappings);
        return this;
    }

    public List<MimeMapping> getMimeMappings() {
        return Collections.unmodifiableList(this.mimeMappings);
    }

    public DeploymentInfo addSecurityConstraint(SecurityConstraint securityConstraint) {
        this.securityConstraints.add(securityConstraint);
        return this;
    }

    public DeploymentInfo addSecurityConstraints(SecurityConstraint ... securityConstraints) {
        this.securityConstraints.addAll(Arrays.asList(securityConstraints));
        return this;
    }

    public DeploymentInfo addSecurityConstraints(Collection<SecurityConstraint> securityConstraints) {
        this.securityConstraints.addAll(securityConstraints);
        return this;
    }

    public List<SecurityConstraint> getSecurityConstraints() {
        return Collections.unmodifiableList(this.securityConstraints);
    }

    public InstanceFactory<Executor> getExecutorFactory() {
        return this.executorFactory;
    }

    public void setExecutorFactory(InstanceFactory<Executor> executorFactory) {
        this.executorFactory = executorFactory;
    }

    public InstanceFactory<Executor> getAsyncExecutorFactory() {
        return this.asyncExecutorFactory;
    }

    public void setAsyncExecutorFactory(InstanceFactory<Executor> asyncExecutorFactory) {
        this.asyncExecutorFactory = asyncExecutorFactory;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.jspConfigDescriptor;
    }

    public void setJspConfigDescriptor(JspConfigDescriptor jspConfigDescriptor) {
        this.jspConfigDescriptor = jspConfigDescriptor;
    }

    public DefaultServletConfig getDefaultServletConfig() {
        return this.defaultServletConfig;
    }

    public DeploymentInfo setDefaultServletConfig(DefaultServletConfig defaultServletConfig) {
        this.defaultServletConfig = defaultServletConfig;
        return this;
    }

    public DeploymentInfo addLocaleCharsetMapping(String locale, String charset) {
        this.localeCharsetMapping.put(locale, charset);
        return this;
    }

    public Map<String, String> getLocaleCharsetMapping() {
        return this.localeCharsetMapping;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public DeploymentInfo setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
        return this;
    }

    public LoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    public DeploymentInfo setLoginConfig(LoginConfig loginConfig) {
        this.loginConfig = loginConfig;
        return this;
    }

    public IdentityManager getIdentityManager() {
        return this.identityManager;
    }

    public DeploymentInfo setIdentityManager(IdentityManager identityManager) {
        this.identityManager = identityManager;
        return this;
    }

    public ConfidentialPortManager getConfidentialPortManager() {
        return this.confidentialPortManager;
    }

    public DeploymentInfo setConfidentialPortManager(ConfidentialPortManager confidentialPortManager) {
        this.confidentialPortManager = confidentialPortManager;
        return this;
    }

    public DeploymentInfo addPrincipleVsRoleMapping(String principle, String role) {
        Set<String> roles = this.principleVsRoleMapping.get(principle);
        if (roles == null) {
            roles = new HashSet<String>();
            this.principleVsRoleMapping.put(principle, roles);
        }
        roles.add(role);
        return this;
    }

    public Map<String, Set<String>> getPrincipleVsRoleMapping() {
        return Collections.unmodifiableMap(this.principleVsRoleMapping);
    }

    public DeploymentInfo addSecurityRole(String role) {
        this.securityRoles.add(role);
        return this;
    }

    public DeploymentInfo addSecurityRoles(String ... roles) {
        this.securityRoles.addAll(Arrays.asList(roles));
        return this;
    }

    public DeploymentInfo addSecurityRoles(Collection<String> roles) {
        this.securityRoles.addAll(roles);
        return this;
    }

    public Set<String> getSecurityRoles() {
        return Collections.unmodifiableSet(this.securityRoles);
    }

    public DeploymentInfo addOuterHandlerChainWrapper(HandlerWrapper wrapper) {
        this.outerHandlerChainWrappers.add(wrapper);
        return this;
    }

    public List<HandlerWrapper> getOuterHandlerChainWrappers() {
        return Collections.unmodifiableList(this.outerHandlerChainWrappers);
    }

    public DeploymentInfo addInnerHandlerChainWrapper(HandlerWrapper wrapper) {
        this.innerHandlerChainWrappers.add(wrapper);
        return this;
    }

    public List<HandlerWrapper> getInnerHandlerChainWrappers() {
        return Collections.unmodifiableList(this.innerHandlerChainWrappers);
    }

    public DeploymentInfo addDispatchedHandlerChainWrapper(HandlerWrapper wrapper) {
        this.dispatchedHandlerChainWrappers.add(wrapper);
        return this;
    }

    public List<HandlerWrapper> getDispatchedHandlerChainWrappers() {
        return Collections.unmodifiableList(this.dispatchedHandlerChainWrappers);
    }

    public DeploymentInfo addNotificationReceiver(NotificationReceiver notificationReceiver) {
        this.notificationReceivers.add(notificationReceiver);
        return this;
    }

    public DeploymentInfo addNotificactionReceivers(NotificationReceiver ... notificationReceivers) {
        this.notificationReceivers.addAll(Arrays.asList(notificationReceivers));
        return this;
    }

    public DeploymentInfo addNotificationReceivers(Collection<NotificationReceiver> notificationReceivers) {
        this.notificationReceivers.addAll(notificationReceivers);
        return this;
    }

    public List<NotificationReceiver> getNotificationReceivers() {
        return Collections.unmodifiableList(this.notificationReceivers);
    }

    public DeploymentInfo clone() {
        DeploymentInfo info = new DeploymentInfo().setClassLoader(this.classLoader).setContextPath(this.contextPath).setResourceLoader(this.resourceLoader).setMajorVersion(this.majorVersion).setMinorVersion(this.minorVersion).setDeploymentName(this.deploymentName);
        for (Map.Entry<String, ServletInfo> entry : this.servlets.entrySet()) {
            info.addServlet(entry.getValue().clone());
        }
        for (Map.Entry<String, Cloneable> entry : this.filters.entrySet()) {
            info.addFilter(((FilterInfo)entry.getValue()).clone());
        }
        info.displayName = this.displayName;
        info.filterUrlMappings.addAll(this.filterUrlMappings);
        info.filterServletNameMappings.addAll(this.filterServletNameMappings);
        info.listeners.addAll(this.listeners);
        info.servletContainerInitializers.addAll(this.servletContainerInitializers);
        info.threadSetupActions.addAll(this.threadSetupActions);
        info.initParameters.putAll(this.initParameters);
        info.servletContextAttributes.putAll(this.servletContextAttributes);
        info.welcomePages.addAll(this.welcomePages);
        info.errorPages.addAll(this.errorPages);
        info.mimeMappings.addAll(this.mimeMappings);
        info.executorFactory = this.executorFactory;
        info.asyncExecutorFactory = this.asyncExecutorFactory;
        info.tempDir = this.tempDir;
        info.jspConfigDescriptor = this.jspConfigDescriptor;
        info.defaultServletConfig = this.defaultServletConfig;
        info.localeCharsetMapping.putAll(this.localeCharsetMapping);
        info.sessionManager = this.sessionManager;
        info.loginConfig = this.loginConfig;
        info.identityManager = this.identityManager;
        info.confidentialPortManager = this.confidentialPortManager;
        info.securityConstraints.addAll(this.securityConstraints);
        info.principleVsRoleMapping.putAll(this.principleVsRoleMapping);
        info.outerHandlerChainWrappers.addAll(this.outerHandlerChainWrappers);
        info.innerHandlerChainWrappers.addAll(this.innerHandlerChainWrappers);
        info.dispatchedHandlerChainWrappers.addAll(this.dispatchedHandlerChainWrappers);
        info.securityRoles.addAll(this.securityRoles);
        info.notificationReceivers.addAll(this.notificationReceivers);
        return info;
    }
}

