/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.security.impl.FormAuthenticationMechanism;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ServletFormAuthenticationMechanism
extends FormAuthenticationMechanism {
    private static final String SESSION_KEY = "io.undertow.servlet.form.auth.redirect.location";

    public ServletFormAuthenticationMechanism(String name, String loginPage, String errorPage) {
        super(name, loginPage, errorPage);
    }

    public ServletFormAuthenticationMechanism(String name, String loginPage, String errorPage, String postLocation) {
        super(name, loginPage, errorPage, postLocation);
    }

    protected Integer servePage(HttpServerExchange exchange, String location) {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        ServletRequest req = servletRequestContext.getServletRequest();
        ServletResponse resp = servletRequestContext.getServletResponse();
        RequestDispatcher disp = req.getRequestDispatcher(location);
        try {
            disp.forward(req, resp);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    protected void storeInitialLocation(HttpServerExchange exchange) {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest req = (HttpServletRequest)servletRequestContext.getServletRequest();
        req.getSession(true).setAttribute(SESSION_KEY, (Object)(req.getContextPath() + req.getServletPath() + (req.getPathInfo() == null ? "" : req.getPathInfo())));
    }

    protected void handleRedirectBack(HttpServerExchange exchange) {
        String path;
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest req = (HttpServletRequest)servletRequestContext.getServletRequest();
        HttpServletResponse resp = (HttpServletResponse)servletRequestContext.getServletResponse();
        HttpSession session = req.getSession(false);
        if (session != null && (path = (String)session.getAttribute(SESSION_KEY)) != null) {
            try {
                resp.sendRedirect(path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

