/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.UndertowLogger;
import io.undertow.servlet.UndertowServletMessages;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSourceChannel;

public class UpgradeServletInputStream
extends ServletInputStream {
    private final StreamSourceChannel channel;
    private volatile ReadListener listener;
    private static final int FLAG_READY = 1;
    private static final int FLAG_CLOSED = 2;
    private static final int FLAG_FINISHED = 4;
    private static final int FLAG_ON_DATA_READ_CALLED = 8;
    private int state;

    protected UpgradeServletInputStream(StreamSourceChannel channel) {
        this.channel = channel;
    }

    public boolean isFinished() {
        return Bits.anyAreSet((int)this.state, (int)4);
    }

    public boolean isReady() {
        return Bits.anyAreSet((int)this.state, (int)1);
    }

    public void setReadListener(ReadListener readListener) {
        if (readListener == null) {
            throw UndertowServletMessages.MESSAGES.paramCannotBeNull("readListener");
        }
        if (this.listener != null) {
            throw UndertowServletMessages.MESSAGES.listenerAlreadySet();
        }
        this.listener = readListener;
        this.channel.getReadSetter().set((ChannelListener)new UpgradeServletChannelListener());
        this.channel.resumeReads();
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        this.read(b);
        return b[0];
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw UndertowServletMessages.MESSAGES.streamIsClosed();
        }
        if (Bits.anyAreSet((int)this.state, (int)4)) {
            return -1;
        }
        ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
        if (this.listener == null) {
            int res = Channels.readBlocking((ReadableByteChannel)this.channel, (ByteBuffer)buffer);
            if (res == -1) {
                this.state |= 4;
            }
            return res;
        }
        if (Bits.anyAreClear((int)this.state, (int)1)) {
            throw UndertowServletMessages.MESSAGES.streamNotReady();
        }
        int res = this.channel.read(buffer);
        if (res == -1) {
            this.state |= 4;
        } else if (res == 0) {
            this.state &= 0xFFFFFFFE;
            this.channel.resumeReads();
        }
        return res;
    }

    public void close() throws IOException {
        this.channel.shutdownReads();
        this.state |= 6;
    }

    private class UpgradeServletChannelListener
    implements ChannelListener<StreamSourceChannel> {
        private UpgradeServletChannelListener() {
        }

        public void handleEvent(StreamSourceChannel channel) {
            channel.suspendReads();
            if (Bits.anyAreClear((int)UpgradeServletInputStream.this.state, (int)4)) {
                try {
                    UpgradeServletInputStream.this.state |= 1;
                    UpgradeServletInputStream.this.listener.onDataAvailable();
                }
                catch (IOException e) {
                    UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                    IoUtils.safeClose((Closeable)channel);
                }
            }
            if (Bits.anyAreSet((int)UpgradeServletInputStream.this.state, (int)4) && Bits.anyAreClear((int)UpgradeServletInputStream.this.state, (int)8)) {
                UpgradeServletInputStream.this.state |= 8;
                try {
                    channel.shutdownReads();
                    UpgradeServletInputStream.this.listener.onAllDataRead();
                }
                catch (IOException e) {
                    IoUtils.safeClose((Closeable)channel);
                }
            } else if (Bits.allAreClear((int)UpgradeServletInputStream.this.state, (int)5)) {
                channel.resumeReads();
            }
        }
    }
}

