/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.SingleConstraintMatch;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.handlers.security.SecurityPathMatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SecurityPathMatches {
    private final boolean denyUncoveredHttpMethods;
    private final PathSecurityInformation defaultPathSecurityInformation;
    private final Map<String, PathSecurityInformation> exactPathRoleInformation;
    private final Map<String, PathSecurityInformation> prefixPathRoleInformation;
    private final Map<String, PathSecurityInformation> extensionRoleInformation;

    private SecurityPathMatches(boolean denyUncoveredHttpMethods, PathSecurityInformation defaultPathSecurityInformation, Map<String, PathSecurityInformation> exactPathRoleInformation, Map<String, PathSecurityInformation> prefixPathRoleInformation, Map<String, PathSecurityInformation> extensionRoleInformation) {
        this.denyUncoveredHttpMethods = denyUncoveredHttpMethods;
        this.defaultPathSecurityInformation = defaultPathSecurityInformation;
        this.exactPathRoleInformation = exactPathRoleInformation;
        this.prefixPathRoleInformation = prefixPathRoleInformation;
        this.extensionRoleInformation = extensionRoleInformation;
    }

    public boolean isEmpty() {
        return this.defaultPathSecurityInformation.excludedMethodRoles.isEmpty() && this.defaultPathSecurityInformation.perMethodRequiredRoles.isEmpty() && this.defaultPathSecurityInformation.defaultRequiredRoles.isEmpty() && this.exactPathRoleInformation.isEmpty() && this.prefixPathRoleInformation.isEmpty() && this.extensionRoleInformation.isEmpty();
    }

    public SecurityPathMatch getSecurityInfo(String path, String method) {
        RuntimeMatch currentMatch = new RuntimeMatch();
        this.handleMatch(method, this.defaultPathSecurityInformation, currentMatch);
        PathSecurityInformation match = this.exactPathRoleInformation.get(path);
        if (match != null) {
            this.handleMatch(method, match, currentMatch);
            return new SecurityPathMatch(currentMatch.type, this.mergeConstraints(currentMatch));
        }
        match = this.prefixPathRoleInformation.get(path);
        if (match != null) {
            this.handleMatch(method, match, currentMatch);
            return new SecurityPathMatch(currentMatch.type, this.mergeConstraints(currentMatch));
        }
        int qsPos = -1;
        boolean extension = false;
        for (int i = path.length() - 1; i >= 0; --i) {
            String part;
            char c = path.charAt(i);
            if (c == '?') {
                part = path.substring(0, i);
                match = this.exactPathRoleInformation.get(part);
                if (match != null) {
                    this.handleMatch(method, match, currentMatch);
                    return new SecurityPathMatch(currentMatch.type, this.mergeConstraints(currentMatch));
                }
                qsPos = i;
                extension = false;
                continue;
            }
            if (c == '/') {
                extension = true;
                part = path.substring(0, i);
                match = this.prefixPathRoleInformation.get(part);
                if (match == null) continue;
                this.handleMatch(method, match, currentMatch);
                return new SecurityPathMatch(currentMatch.type, this.mergeConstraints(currentMatch));
            }
            if (c != '.' || extension) continue;
            extension = true;
            String ext = qsPos == -1 ? path.substring(i + 1, path.length()) : path.substring(i + 1, qsPos);
            match = this.extensionRoleInformation.get(ext);
            if (match == null) continue;
            this.handleMatch(method, match, currentMatch);
            return new SecurityPathMatch(currentMatch.type, this.mergeConstraints(currentMatch));
        }
        return new SecurityPathMatch(currentMatch.type, this.mergeConstraints(currentMatch));
    }

    private SingleConstraintMatch mergeConstraints(RuntimeMatch currentMatch) {
        if (currentMatch.uncovered && this.denyUncoveredHttpMethods) {
            return new SingleConstraintMatch(SecurityInfo.EmptyRoleSemantic.DENY, Collections.<String>emptySet());
        }
        HashSet<String> allowedRoles = new HashSet<String>();
        for (SingleConstraintMatch match : currentMatch.constraints) {
            if (match.getRequiredRoles().isEmpty()) {
                return new SingleConstraintMatch(match.getEmptyRoleSemantic(), Collections.<String>emptySet());
            }
            allowedRoles.addAll(match.getRequiredRoles());
        }
        return new SingleConstraintMatch(SecurityInfo.EmptyRoleSemantic.PERMIT, allowedRoles);
    }

    private void handleMatch(String method, PathSecurityInformation exact, RuntimeMatch currentMatch) {
        List<SecurityInformation> roles = exact.defaultRequiredRoles;
        for (SecurityInformation role : roles) {
            this.transport(currentMatch, role.transportGuaranteeType);
            currentMatch.constraints.add(new SingleConstraintMatch(role.emptyRoleSemantic, role.roles));
            if (role.emptyRoleSemantic != SecurityInfo.EmptyRoleSemantic.DENY && role.roles.isEmpty()) continue;
            currentMatch.uncovered = false;
        }
        List<SecurityInformation> methodInfo = exact.perMethodRequiredRoles.get(method);
        if (methodInfo != null) {
            currentMatch.uncovered = false;
            for (SecurityInformation role : methodInfo) {
                this.transport(currentMatch, role.transportGuaranteeType);
                currentMatch.constraints.add(new SingleConstraintMatch(role.emptyRoleSemantic, role.roles));
            }
        }
        for (ExcludedMethodRoles excluded : exact.excludedMethodRoles) {
            if (excluded.methods.contains(method)) continue;
            currentMatch.uncovered = false;
            this.transport(currentMatch, excluded.securityInformation.transportGuaranteeType);
            currentMatch.constraints.add(new SingleConstraintMatch(excluded.securityInformation.emptyRoleSemantic, excluded.securityInformation.roles));
        }
    }

    private void transport(RuntimeMatch match, TransportGuaranteeType other) {
        if (other.ordinal() > match.type.ordinal()) {
            match.type = other;
        }
    }

    public static Builder builder(DeploymentInfo deploymentInfo) {
        return new Builder(deploymentInfo);
    }

    private static final class RuntimeMatch {
        TransportGuaranteeType type = TransportGuaranteeType.NONE;
        final List<SingleConstraintMatch> constraints = new ArrayList<SingleConstraintMatch>();
        boolean uncovered = true;

        private RuntimeMatch() {
        }
    }

    private static final class SecurityInformation {
        final Set<String> roles;
        final TransportGuaranteeType transportGuaranteeType;
        final SecurityInfo.EmptyRoleSemantic emptyRoleSemantic;

        private SecurityInformation(Set<String> roles, TransportGuaranteeType transportGuaranteeType, SecurityInfo.EmptyRoleSemantic emptyRoleSemantic) {
            this.emptyRoleSemantic = emptyRoleSemantic;
            this.roles = new HashSet<String>(roles);
            this.transportGuaranteeType = transportGuaranteeType;
        }
    }

    private static final class ExcludedMethodRoles {
        final Set<String> methods;
        final SecurityInformation securityInformation;

        public ExcludedMethodRoles(Set<String> methods, SecurityInformation securityInformation) {
            this.methods = methods;
            this.securityInformation = securityInformation;
        }
    }

    private static class PathSecurityInformation {
        final List<SecurityInformation> defaultRequiredRoles = new ArrayList<SecurityInformation>();
        final Map<String, List<SecurityInformation>> perMethodRequiredRoles = new HashMap<String, List<SecurityInformation>>();
        final List<ExcludedMethodRoles> excludedMethodRoles = new ArrayList<ExcludedMethodRoles>();

        private PathSecurityInformation() {
        }
    }

    public static class Builder {
        private final DeploymentInfo deploymentInfo;
        private final PathSecurityInformation defaultPathSecurityInformation = new PathSecurityInformation();
        private final Map<String, PathSecurityInformation> exactPathRoleInformation = new HashMap<String, PathSecurityInformation>();
        private final Map<String, PathSecurityInformation> prefixPathRoleInformation = new HashMap<String, PathSecurityInformation>();
        private final Map<String, PathSecurityInformation> extensionRoleInformation = new HashMap<String, PathSecurityInformation>();

        private Builder(DeploymentInfo deploymentInfo) {
            this.deploymentInfo = deploymentInfo;
        }

        public void addSecurityConstraint(SecurityConstraint securityConstraint) {
            Set<String> roles = this.expandRolesAllowed(securityConstraint.getRolesAllowed());
            SecurityInformation securityInformation = new SecurityInformation(roles, securityConstraint.getTransportGuaranteeType(), securityConstraint.getEmptyRoleSemantic());
            for (WebResourceCollection webResources : securityConstraint.getWebResourceCollections()) {
                if (webResources.getUrlPatterns().isEmpty()) {
                    this.setupPathSecurityInformation(this.defaultPathSecurityInformation, securityInformation, webResources);
                }
                for (String pattern : webResources.getUrlPatterns()) {
                    PathSecurityInformation info;
                    String part;
                    if (pattern.endsWith("/*") || pattern.endsWith("/")) {
                        part = pattern.substring(0, pattern.lastIndexOf(47));
                        info = this.prefixPathRoleInformation.get(part);
                        if (info == null) {
                            info = new PathSecurityInformation();
                            this.prefixPathRoleInformation.put(part, info);
                        }
                        this.setupPathSecurityInformation(info, securityInformation, webResources);
                        continue;
                    }
                    if (pattern.startsWith("*.")) {
                        part = pattern.substring(2, pattern.length());
                        info = this.extensionRoleInformation.get(part);
                        if (info == null) {
                            info = new PathSecurityInformation();
                            this.extensionRoleInformation.put(part, info);
                        }
                        this.setupPathSecurityInformation(info, securityInformation, webResources);
                        continue;
                    }
                    PathSecurityInformation info2 = this.exactPathRoleInformation.get(pattern);
                    if (info2 == null) {
                        info2 = new PathSecurityInformation();
                        this.exactPathRoleInformation.put(pattern, info2);
                    }
                    this.setupPathSecurityInformation(info2, securityInformation, webResources);
                }
            }
        }

        private Set<String> expandRolesAllowed(Set<String> rolesAllowed) {
            HashSet<String> roles = new HashSet<String>(rolesAllowed);
            if (roles.contains("*")) {
                roles.remove("*");
                roles.addAll(this.deploymentInfo.getSecurityRoles());
            }
            return roles;
        }

        private void setupPathSecurityInformation(PathSecurityInformation info, SecurityInformation securityConstraint, WebResourceCollection webResources) {
            if (webResources.getHttpMethods().isEmpty() && webResources.getHttpMethodOmissions().isEmpty()) {
                info.defaultRequiredRoles.add(securityConstraint);
            } else if (!webResources.getHttpMethods().isEmpty()) {
                for (String method : webResources.getHttpMethods()) {
                    List<SecurityInformation> securityInformations = info.perMethodRequiredRoles.get(method);
                    if (securityInformations == null) {
                        securityInformations = new ArrayList<SecurityInformation>();
                        info.perMethodRequiredRoles.put(method, securityInformations);
                    }
                    securityInformations.add(securityConstraint);
                }
            } else if (!webResources.getHttpMethodOmissions().isEmpty()) {
                info.excludedMethodRoles.add(new ExcludedMethodRoles(webResources.getHttpMethodOmissions(), securityConstraint));
            }
        }

        public SecurityPathMatches build() {
            return new SecurityPathMatches(this.deploymentInfo.isDenyUncoveredHttpMethods(), this.defaultPathSecurityInformation, this.exactPathRoleInformation, this.prefixPathRoleInformation, this.extensionRoleInformation);
        }
    }
}

