/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterMappingInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.core.ManagedFilter;
import io.undertow.servlet.core.ManagedFilters;
import io.undertow.servlet.core.ManagedServlet;
import io.undertow.servlet.core.ManagedServlets;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.servlet.handlers.FilterHandler;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletHandler;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletPathMatchesData;
import io.undertow.servlet.handlers.security.ServletSecurityRoleHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;

public class ServletPathMatches {
    public static final String DEFAULT_SERVLET_NAME = "default";
    private final Deployment deployment;
    private final String[] welcomePages;
    private final ResourceManager resourceManager;
    private volatile ServletPathMatchesData data;

    public ServletPathMatches(Deployment deployment) {
        this.deployment = deployment;
        this.welcomePages = deployment.getDeploymentInfo().getWelcomePages().toArray(new String[deployment.getDeploymentInfo().getWelcomePages().size()]);
        this.resourceManager = deployment.getDeploymentInfo().getResourceManager();
    }

    public ServletChain getServletHandlerByName(String name) {
        return this.getData().getServletHandlerByName(name);
    }

    public ServletPathMatch getServletHandlerByPath(String path) {
        ServletPathMatch match = this.getData().getServletHandlerByPath(path);
        if (!match.isRequiredWelcomeFileMatch()) {
            return match;
        }
        try {
            String remaining = match.getRemaining() == null ? match.getMatched() : match.getRemaining();
            Resource resource = this.resourceManager.getResource(remaining);
            if (resource == null || !resource.isDirectory()) {
                return match;
            }
            boolean pathEndsWithSlash = remaining.endsWith("/");
            String pathWithTrailingSlash = pathEndsWithSlash ? remaining : remaining + "/";
            ServletPathMatch welcomePage = this.findWelcomeFile(pathWithTrailingSlash, !pathEndsWithSlash);
            if (welcomePage != null) {
                return welcomePage;
            }
            welcomePage = this.findWelcomeServlet(pathWithTrailingSlash, !pathEndsWithSlash);
            if (welcomePage != null) {
                return welcomePage;
            }
            if (pathEndsWithSlash) {
                return match;
            }
            return new ServletPathMatch(match.getServletChain(), match.getMatched(), match.getRemaining(), ServletPathMatch.Type.REDIRECT, "/");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void invalidate() {
        this.data = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServletPathMatchesData getData() {
        ServletPathMatchesData data = this.data;
        if (data != null) {
            return data;
        }
        ServletPathMatches servletPathMatches = this;
        synchronized (servletPathMatches) {
            if (this.data != null) {
                return this.data;
            }
            this.data = this.setupServletChains();
            return this.data;
        }
    }

    private ServletPathMatch findWelcomeFile(String path, boolean requiresRedirect) {
        if (File.separatorChar != '/' && path.contains(File.separator)) {
            return null;
        }
        for (String i : this.welcomePages) {
            try {
                String mergedPath = path + i;
                Resource resource = this.resourceManager.getResource(mergedPath);
                if (resource == null) continue;
                ServletPathMatch handler = this.data.getServletHandlerByPath(mergedPath);
                return new ServletPathMatch(handler.getServletChain(), mergedPath, null, requiresRedirect ? ServletPathMatch.Type.REDIRECT : ServletPathMatch.Type.REWRITE, i);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    private ServletPathMatch findWelcomeServlet(String path, boolean requiresRedirect) {
        for (String i : this.welcomePages) {
            String mergedPath = path + i;
            ServletPathMatch handler = this.data.getServletHandlerByPath(mergedPath);
            if (handler == null || handler.isRequiredWelcomeFileMatch()) continue;
            return new ServletPathMatch(handler.getServletChain(), handler.getMatched(), handler.getRemaining(), requiresRedirect ? ServletPathMatch.Type.REDIRECT : ServletPathMatch.Type.REWRITE, i);
        }
        return null;
    }

    private ServletPathMatchesData setupServletChains() {
        ServletHandler defaultServlet = null;
        ManagedServlets servlets = this.deployment.getServlets();
        ManagedFilters filters = this.deployment.getFilters();
        HashMap<String, ServletHandler> extensionServlets = new HashMap<String, ServletHandler>();
        HashMap<String, ServletHandler> pathServlets = new HashMap<String, ServletHandler>();
        HashSet<String> pathMatches = new HashSet<String>();
        HashSet<String> extensionMatches = new HashSet<String>();
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        for (FilterMappingInfo filterMappingInfo : deploymentInfo.getFilterMappings()) {
            if (filterMappingInfo.getMappingType() != FilterMappingInfo.MappingType.URL) continue;
            String path = filterMappingInfo.getMapping();
            if (path.equals("*")) {
                path = "/*";
            }
            if (!path.startsWith("*.")) {
                pathMatches.add(path);
                continue;
            }
            extensionMatches.add(path.substring(2));
        }
        for (Map.Entry entry : servlets.getServletHandlers().entrySet()) {
            ServletHandler handler = (ServletHandler)entry.getValue();
            for (String path : handler.getManagedServlet().getServletInfo().getMappings()) {
                if (path.equals("/")) {
                    pathMatches.add("/*");
                    if (defaultServlet != null) {
                        throw UndertowServletMessages.MESSAGES.twoServletsWithSameMapping(path);
                    }
                    defaultServlet = handler;
                    continue;
                }
                if (!path.startsWith("*.")) {
                    if (path.isEmpty()) {
                        path = "/";
                    }
                    pathMatches.add(path);
                    if (pathServlets.containsKey(path)) {
                        throw UndertowServletMessages.MESSAGES.twoServletsWithSameMapping(path);
                    }
                    pathServlets.put(path, handler);
                    continue;
                }
                String ext = path.substring(2);
                extensionMatches.add(ext);
                extensionServlets.put(ext, handler);
            }
        }
        ServletHandler managedDefaultServlet = servlets.getServletHandler(DEFAULT_SERVLET_NAME);
        if (managedDefaultServlet == null) {
            managedDefaultServlet = servlets.addServlet(new ServletInfo(DEFAULT_SERVLET_NAME, DefaultServlet.class));
        }
        if (defaultServlet == null) {
            pathMatches.add("/*");
            defaultServlet = managedDefaultServlet;
        }
        ServletPathMatchesData.Builder builder = ServletPathMatchesData.builder();
        for (String string : pathMatches) {
            MatchData targetServletMatch = ServletPathMatches.resolveServletForPath(string, pathServlets, extensionServlets, defaultServlet);
            EnumMap<DispatcherType, List<ManagedFilter>> noExtension = new EnumMap<DispatcherType, List<ManagedFilter>>(DispatcherType.class);
            HashMap extension = new HashMap();
            for (String ext : extensionMatches) {
                extension.put(ext, new EnumMap(DispatcherType.class));
            }
            for (FilterMappingInfo filterMapping : deploymentInfo.getFilterMappings()) {
                ManagedFilter filter = filters.getManagedFilter(filterMapping.getFilterName());
                if (filterMapping.getMappingType() == FilterMappingInfo.MappingType.SERVLET) {
                    if (targetServletMatch.handler != null && filterMapping.getMapping().equals(targetServletMatch.handler.getManagedServlet().getServletInfo().getName())) {
                        ServletPathMatches.addToListMap(noExtension, filterMapping.getDispatcher(), filter);
                    }
                    for (Map.Entry entry : extension.entrySet()) {
                        ServletHandler pathServlet = targetServletMatch.handler;
                        boolean defaultServletMatch = targetServletMatch.defaultServlet;
                        if (defaultServletMatch && extensionServlets.containsKey(entry.getKey())) {
                            pathServlet = (ServletHandler)extensionServlets.get(entry.getKey());
                        }
                        if (!filterMapping.getMapping().equals(pathServlet.getManagedServlet().getServletInfo().getName())) continue;
                        ServletPathMatches.addToListMap((Map)extension.get(entry.getKey()), filterMapping.getDispatcher(), filter);
                    }
                    continue;
                }
                if (filterMapping.getMapping().isEmpty() || !filterMapping.getMapping().startsWith("*.")) {
                    if (!ServletPathMatches.isFilterApplicable(string, filterMapping.getMapping())) continue;
                    ServletPathMatches.addToListMap(noExtension, filterMapping.getDispatcher(), filter);
                    for (Map l : extension.values()) {
                        ServletPathMatches.addToListMap(l, filterMapping.getDispatcher(), filter);
                    }
                    continue;
                }
                ServletPathMatches.addToListMap((Map)extension.get(filterMapping.getMapping().substring(2)), filterMapping.getDispatcher(), filter);
            }
            if (string.endsWith("/*")) {
                String prefix = string.substring(0, string.length() - 2);
                builder.addPrefixMatch(prefix, this.createHandler(deploymentInfo, targetServletMatch.handler, noExtension, targetServletMatch.matchedPath, targetServletMatch.defaultServlet), targetServletMatch.defaultServlet || targetServletMatch.handler.getManagedServlet().getServletInfo().isRequireWelcomeFileMapping());
                for (Map.Entry entry : extension.entrySet()) {
                    ServletHandler pathServlet = targetServletMatch.handler;
                    String pathMatch = targetServletMatch.matchedPath;
                    boolean defaultServletMatch = targetServletMatch.defaultServlet;
                    if (defaultServletMatch && extensionServlets.containsKey(entry.getKey())) {
                        defaultServletMatch = false;
                        pathServlet = (ServletHandler)extensionServlets.get(entry.getKey());
                    }
                    Object handler = pathServlet;
                    if (!((Map)entry.getValue()).isEmpty()) {
                        handler = new FilterHandler((Map)entry.getValue(), deploymentInfo.isAllowNonStandardWrappers(), (HttpHandler)handler);
                    }
                    builder.addExtensionMatch(prefix, (String)entry.getKey(), ServletPathMatches.servletChain(handler, pathServlet.getManagedServlet(), pathMatch, deploymentInfo, defaultServletMatch));
                }
                continue;
            }
            if (string.isEmpty()) {
                builder.addExactMatch("/", this.createHandler(deploymentInfo, targetServletMatch.handler, noExtension, targetServletMatch.matchedPath, targetServletMatch.defaultServlet));
                continue;
            }
            int lastSegmentIndex = string.lastIndexOf(47);
            String lastSegment = lastSegmentIndex > 0 ? string.substring(lastSegmentIndex) : string;
            if (lastSegment.contains(".")) {
                String ext = lastSegment.substring(lastSegment.lastIndexOf(46) + 1);
                if (extension.containsKey(ext)) {
                    Map extMap = (Map)extension.get(ext);
                    builder.addExactMatch(string, this.createHandler(deploymentInfo, targetServletMatch.handler, extMap, targetServletMatch.matchedPath, targetServletMatch.defaultServlet));
                    continue;
                }
                builder.addExactMatch(string, this.createHandler(deploymentInfo, targetServletMatch.handler, noExtension, targetServletMatch.matchedPath, targetServletMatch.defaultServlet));
                continue;
            }
            builder.addExactMatch(string, this.createHandler(deploymentInfo, targetServletMatch.handler, noExtension, targetServletMatch.matchedPath, targetServletMatch.defaultServlet));
        }
        for (Map.Entry entry : servlets.getServletHandlers().entrySet()) {
            EnumMap<DispatcherType, List<ManagedFilter>> filtersByDispatcher = new EnumMap<DispatcherType, List<ManagedFilter>>(DispatcherType.class);
            for (FilterMappingInfo filterMapping : deploymentInfo.getFilterMappings()) {
                ManagedFilter filter = filters.getManagedFilter(filterMapping.getFilterName());
                if (filterMapping.getMappingType() != FilterMappingInfo.MappingType.SERVLET || !filterMapping.getMapping().equals(entry.getKey())) continue;
                ServletPathMatches.addToListMap(filtersByDispatcher, filterMapping.getDispatcher(), filter);
            }
            if (filtersByDispatcher.isEmpty()) {
                builder.addNameMatch((String)entry.getKey(), ServletPathMatches.servletChain((HttpHandler)entry.getValue(), ((ServletHandler)entry.getValue()).getManagedServlet(), null, deploymentInfo, false));
                continue;
            }
            builder.addNameMatch((String)entry.getKey(), ServletPathMatches.servletChain(new FilterHandler(filtersByDispatcher, deploymentInfo.isAllowNonStandardWrappers(), (HttpHandler)entry.getValue()), ((ServletHandler)entry.getValue()).getManagedServlet(), null, deploymentInfo, false));
        }
        return builder.build();
    }

    private ServletChain createHandler(DeploymentInfo deploymentInfo, ServletHandler targetServlet, Map<DispatcherType, List<ManagedFilter>> noExtension, String servletPath, boolean defaultServlet) {
        ServletChain initialHandler;
        if (noExtension.isEmpty()) {
            initialHandler = ServletPathMatches.servletChain(targetServlet, targetServlet.getManagedServlet(), servletPath, deploymentInfo, defaultServlet);
        } else {
            FilterHandler handler = new FilterHandler(noExtension, deploymentInfo.isAllowNonStandardWrappers(), targetServlet);
            initialHandler = ServletPathMatches.servletChain(handler, targetServlet.getManagedServlet(), servletPath, deploymentInfo, defaultServlet);
        }
        return initialHandler;
    }

    private static MatchData resolveServletForPath(String path, Map<String, ServletHandler> pathServlets, Map<String, ServletHandler> extensionServlets, ServletHandler defaultServlet) {
        String ext;
        if (pathServlets.containsKey(path)) {
            if (path.endsWith("/*")) {
                String base = path.substring(0, path.length() - 2);
                return new MatchData(pathServlets.get(path), base, false);
            }
            return new MatchData(pathServlets.get(path), path, false);
        }
        String match = null;
        ServletHandler servlet = null;
        for (Map.Entry<String, ServletHandler> entry : pathServlets.entrySet()) {
            String key = entry.getKey();
            if (!key.endsWith("/*")) continue;
            String base = key.substring(0, key.length() - 2);
            if (match != null && base.length() <= match.length() || !path.startsWith(base)) continue;
            match = base;
            servlet = entry.getValue();
        }
        if (servlet != null) {
            return new MatchData(servlet, match, false);
        }
        int index = path.lastIndexOf(46);
        if (index != -1 && (servlet = extensionServlets.get(ext = path.substring(index + 1))) != null) {
            return new MatchData(servlet, null, false);
        }
        return new MatchData(defaultServlet, null, true);
    }

    private static boolean isFilterApplicable(String path, String filterPath) {
        String modifiedPath = filterPath.equals("*") ? "/*" : filterPath;
        if (path.isEmpty()) {
            return modifiedPath.equals("/*") || modifiedPath.equals("/");
        }
        if (modifiedPath.endsWith("/*")) {
            String baseFilterPath = modifiedPath.substring(0, modifiedPath.length() - 1);
            return path.startsWith(baseFilterPath);
        }
        return modifiedPath.equals(path);
    }

    private static <K, V> void addToListMap(Map<K, List<V>> map, K key, V value) {
        List<V> list = map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            map.put(key, list);
        }
        list.add(value);
    }

    private static ServletChain servletChain(HttpHandler next, ManagedServlet managedServlet, String servletPath, DeploymentInfo deploymentInfo, boolean defaultServlet) {
        ServletSecurityRoleHandler servletHandler = new ServletSecurityRoleHandler(next, deploymentInfo.getAuthorizationManager());
        servletHandler = ServletPathMatches.wrapHandlers(servletHandler, managedServlet.getServletInfo().getHandlerChainWrappers());
        return new ServletChain(servletHandler, managedServlet, servletPath, defaultServlet);
    }

    private static HttpHandler wrapHandlers(HttpHandler wrapee, List<HandlerWrapper> wrappers) {
        HttpHandler current = wrapee;
        for (HandlerWrapper wrapper : wrappers) {
            current = wrapper.wrap(current);
        }
        return current;
    }

    private static class MatchData {
        final ServletHandler handler;
        final String matchedPath;
        final boolean defaultServlet;

        private MatchData(ServletHandler handler, String matchedPath, boolean defaultServlet) {
            this.handler = handler;
            this.matchedPath = matchedPath;
            this.defaultServlet = defaultServlet;
        }
    }
}

