/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.AsyncContextImpl;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.SecurityActions;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.util.QueryParameterUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestDispatcherImpl
implements RequestDispatcher {
    private final String path;
    private final ServletContextImpl servletContext;
    private final ServletChain chain;
    private final ServletPathMatch pathMatch;
    private final boolean named;

    public RequestDispatcherImpl(String path, ServletContextImpl servletContext) {
        this.path = path;
        this.servletContext = servletContext;
        int qPos = path.indexOf("?");
        this.pathMatch = qPos == -1 ? servletContext.getDeployment().getServletPaths().getServletHandlerByPath(path) : servletContext.getDeployment().getServletPaths().getServletHandlerByPath(path.substring(0, qPos));
        this.chain = this.pathMatch.getServletChain();
        this.named = false;
    }

    public RequestDispatcherImpl(ServletChain chain, ServletContextImpl servletContext) {
        this.chain = chain;
        this.named = true;
        this.servletContext = servletContext;
        this.path = null;
        this.pathMatch = null;
    }

    public void forward(final ServletRequest request, final ServletResponse response) throws ServletException, IOException {
        if (System.getSecurityManager() != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        RequestDispatcherImpl.this.forwardImpl(request, response);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof ServletException) {
                    throw (ServletException)e.getCause();
                }
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        } else {
            this.forwardImpl(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardImpl(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ServletRequestContext servletRequestContext = SecurityActions.currentServletRequestContext();
        if (servletRequestContext == null) {
            UndertowLogger.REQUEST_LOGGER.debugf("No servlet request context for %s, dispatching mock request", (Object)request);
            this.mock(request, response);
            return;
        }
        ThreadSetupAction.Handle handle = null;
        ServletContextImpl oldServletContext = null;
        HttpSessionImpl oldSession = null;
        if (servletRequestContext.getCurrentServletContext() != this.servletContext) {
            oldServletContext = servletRequestContext.getCurrentServletContext();
            oldSession = servletRequestContext.getSession();
            servletRequestContext.setSession(null);
            handle = this.servletContext.getDeployment().getThreadSetupAction().setup(servletRequestContext.getExchange());
            servletRequestContext.setCurrentServletContext(this.servletContext);
        }
        try {
            HttpServletRequestImpl requestImpl = servletRequestContext.getOriginalRequest();
            HttpServletResponseImpl responseImpl = servletRequestContext.getOriginalResponse();
            if (!this.servletContext.getDeployment().getDeploymentInfo().isAllowNonStandardWrappers()) {
                if (servletRequestContext.getOriginalRequest() != request && !(request instanceof ServletRequestWrapper)) {
                    throw UndertowServletMessages.MESSAGES.requestWasNotOriginalOrWrapper(request);
                }
                if (servletRequestContext.getOriginalResponse() != response && !(response instanceof ServletResponseWrapper)) {
                    throw UndertowServletMessages.MESSAGES.responseWasNotOriginalOrWrapper(response);
                }
            }
            response.resetBuffer();
            ServletRequest oldRequest = servletRequestContext.getServletRequest();
            ServletResponse oldResponse = servletRequestContext.getServletResponse();
            Map<String, Deque<String>> queryParameters = requestImpl.getQueryParameters();
            if (!this.named) {
                if (request.getAttribute("javax.servlet.forward.request_uri") == null) {
                    requestImpl.setAttribute("javax.servlet.forward.request_uri", requestImpl.getRequestURI());
                    requestImpl.setAttribute("javax.servlet.forward.context_path", requestImpl.getContextPath());
                    requestImpl.setAttribute("javax.servlet.forward.servlet_path", requestImpl.getServletPath());
                    requestImpl.setAttribute("javax.servlet.forward.path_info", requestImpl.getPathInfo());
                    requestImpl.setAttribute("javax.servlet.forward.query_string", requestImpl.getQueryString());
                }
                int qsPos = this.path.indexOf("?");
                String newServletPath = this.path;
                if (qsPos != -1) {
                    String newQueryString = newServletPath.substring(qsPos + 1);
                    newServletPath = newServletPath.substring(0, qsPos);
                    String encoding = QueryParameterUtils.getQueryParamEncoding((HttpServerExchange)servletRequestContext.getExchange());
                    Map newQueryParameters = QueryParameterUtils.mergeQueryParametersWithNewQueryString(queryParameters, (String)newQueryString, (String)encoding);
                    requestImpl.getExchange().setQueryString(newQueryString);
                    requestImpl.setQueryParameters(newQueryParameters);
                }
                String newRequestUri = this.servletContext.getContextPath() + newServletPath;
                requestImpl.getExchange().setRelativePath(newServletPath);
                requestImpl.getExchange().setRequestPath(newRequestUri);
                requestImpl.getExchange().setRequestURI(newRequestUri);
                ((ServletRequestContext)requestImpl.getExchange().getAttachment(ServletRequestContext.ATTACHMENT_KEY)).setServletPathMatch(this.pathMatch);
                requestImpl.setServletContext(this.servletContext);
                responseImpl.setServletContext(this.servletContext);
            }
            try {
                try {
                    servletRequestContext.setServletRequest(request);
                    servletRequestContext.setServletResponse(response);
                    if (this.named) {
                        this.servletContext.getDeployment().getServletDispatcher().dispatchToServlet(requestImpl.getExchange(), this.chain, DispatcherType.FORWARD);
                    } else {
                        this.servletContext.getDeployment().getServletDispatcher().dispatchToPath(requestImpl.getExchange(), this.pathMatch, DispatcherType.FORWARD);
                    }
                    if (!request.isAsyncStarted()) {
                        if (response instanceof HttpServletResponseImpl) {
                            responseImpl.closeStreamAndWriter();
                        } else {
                            try {
                                PrintWriter writer = response.getWriter();
                                writer.flush();
                                writer.close();
                            }
                            catch (IllegalStateException e) {
                                ServletOutputStream outputStream = response.getOutputStream();
                                outputStream.flush();
                                outputStream.close();
                            }
                        }
                    }
                }
                catch (ServletException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                servletRequestContext.setServletRequest(oldRequest);
                servletRequestContext.setServletResponse(oldResponse);
            }
        }
        finally {
            if (handle != null) {
                servletRequestContext.setSession(oldSession);
                servletRequestContext.setCurrentServletContext(oldServletContext);
                handle.tearDown();
            }
        }
    }

    public void include(final ServletRequest request, final ServletResponse response) throws ServletException, IOException {
        if (System.getSecurityManager() != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        RequestDispatcherImpl.this.includeImpl(request, response);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof ServletException) {
                    throw (ServletException)e.getCause();
                }
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        } else {
            this.includeImpl(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void includeImpl(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ServletRequestContext servletRequestContext = SecurityActions.currentServletRequestContext();
        if (servletRequestContext == null) {
            UndertowLogger.REQUEST_LOGGER.debugf("No servlet request context for %s, dispatching mock request", (Object)request);
            this.mock(request, response);
            return;
        }
        HttpServletRequestImpl requestImpl = servletRequestContext.getOriginalRequest();
        HttpServletResponseImpl responseImpl = servletRequestContext.getOriginalResponse();
        ThreadSetupAction.Handle handle = null;
        ServletContextImpl oldServletContext = null;
        HttpSessionImpl oldSession = null;
        if (servletRequestContext.getCurrentServletContext() != this.servletContext) {
            oldServletContext = servletRequestContext.getCurrentServletContext();
            oldSession = servletRequestContext.getSession();
            servletRequestContext.setSession(null);
            handle = this.servletContext.getDeployment().getThreadSetupAction().setup(servletRequestContext.getExchange());
            servletRequestContext.setCurrentServletContext(this.servletContext);
        }
        try {
            if (!this.servletContext.getDeployment().getDeploymentInfo().isAllowNonStandardWrappers()) {
                if (servletRequestContext.getOriginalRequest() != request && !(request instanceof ServletRequestWrapper)) {
                    throw UndertowServletMessages.MESSAGES.requestWasNotOriginalOrWrapper(request);
                }
                if (servletRequestContext.getOriginalResponse() != response && !(response instanceof ServletResponseWrapper)) {
                    throw UndertowServletMessages.MESSAGES.responseWasNotOriginalOrWrapper(response);
                }
            }
            ServletRequest oldRequest = servletRequestContext.getServletRequest();
            ServletResponse oldResponse = servletRequestContext.getServletResponse();
            Object requestUri = null;
            Object contextPath = null;
            Object servletPath = null;
            Object pathInfo = null;
            Object queryString = null;
            Map<String, Deque<String>> queryParameters = requestImpl.getQueryParameters();
            if (!this.named) {
                requestUri = request.getAttribute("javax.servlet.include.request_uri");
                contextPath = request.getAttribute("javax.servlet.include.context_path");
                servletPath = request.getAttribute("javax.servlet.include.servlet_path");
                pathInfo = request.getAttribute("javax.servlet.include.path_info");
                queryString = request.getAttribute("javax.servlet.include.query_string");
                int qsPos = this.path.indexOf("?");
                String newServletPath = this.path;
                if (qsPos != -1) {
                    String newQueryString = newServletPath.substring(qsPos + 1);
                    newServletPath = newServletPath.substring(0, qsPos);
                    String encoding = QueryParameterUtils.getQueryParamEncoding((HttpServerExchange)servletRequestContext.getExchange());
                    Map newQueryParameters = QueryParameterUtils.mergeQueryParametersWithNewQueryString(queryParameters, (String)newQueryString, (String)encoding);
                    requestImpl.setQueryParameters(newQueryParameters);
                    requestImpl.setAttribute("javax.servlet.include.query_string", newQueryString);
                } else {
                    requestImpl.setAttribute("javax.servlet.include.query_string", "");
                }
                String newRequestUri = this.servletContext.getContextPath() + newServletPath;
                requestImpl.setAttribute("javax.servlet.include.request_uri", newRequestUri);
                requestImpl.setAttribute("javax.servlet.include.context_path", this.servletContext.getContextPath());
                requestImpl.setAttribute("javax.servlet.include.servlet_path", this.pathMatch.getMatched());
                requestImpl.setAttribute("javax.servlet.include.path_info", this.pathMatch.getRemaining());
            }
            boolean inInclude = responseImpl.isInsideInclude();
            responseImpl.setInsideInclude(true);
            DispatcherType oldDispatcherType = servletRequestContext.getDispatcherType();
            ServletContextImpl oldContext = requestImpl.getServletContext();
            try {
                requestImpl.setServletContext(this.servletContext);
                responseImpl.setServletContext(this.servletContext);
                try {
                    servletRequestContext.setServletRequest(request);
                    servletRequestContext.setServletResponse(response);
                    this.servletContext.getDeployment().getServletDispatcher().dispatchToServlet(requestImpl.getExchange(), this.chain, DispatcherType.INCLUDE);
                }
                catch (ServletException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                responseImpl.setInsideInclude(inInclude);
                requestImpl.setServletContext(oldContext);
                responseImpl.setServletContext(oldContext);
                servletRequestContext.setServletRequest(oldRequest);
                servletRequestContext.setServletResponse(oldResponse);
                servletRequestContext.setDispatcherType(oldDispatcherType);
                if (!this.named) {
                    requestImpl.setAttribute("javax.servlet.include.request_uri", requestUri);
                    requestImpl.setAttribute("javax.servlet.include.context_path", contextPath);
                    requestImpl.setAttribute("javax.servlet.include.servlet_path", servletPath);
                    requestImpl.setAttribute("javax.servlet.include.path_info", pathInfo);
                    requestImpl.setAttribute("javax.servlet.include.query_string", queryString);
                    requestImpl.setQueryParameters(queryParameters);
                }
            }
        }
        finally {
            if (handle != null) {
                servletRequestContext.setSession(oldSession);
                servletRequestContext.setCurrentServletContext(oldServletContext);
                handle.tearDown();
            }
        }
    }

    public void error(ServletRequestContext servletRequestContext, ServletRequest request, ServletResponse response, String servletName, String message) throws ServletException, IOException {
        this.error(servletRequestContext, request, response, servletName, null, message);
    }

    public void error(ServletRequestContext servletRequestContext, ServletRequest request, ServletResponse response, String servletName) throws ServletException, IOException {
        this.error(servletRequestContext, request, response, servletName, null, null);
    }

    public void error(ServletRequestContext servletRequestContext, ServletRequest request, ServletResponse response, String servletName, Throwable exception) throws ServletException, IOException {
        this.error(servletRequestContext, request, response, servletName, exception, exception.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void error(ServletRequestContext servletRequestContext, ServletRequest request, ServletResponse response, String servletName, Throwable exception, String message) throws ServletException, IOException {
        if (request.getDispatcherType() == DispatcherType.ERROR) {
            UndertowServletLogger.REQUEST_LOGGER.errorGeneratingErrorPage(servletRequestContext.getExchange().getRequestPath(), request.getAttribute("javax.servlet.error.exception"), servletRequestContext.getExchange().getResponseCode(), exception);
            servletRequestContext.getExchange().endExchange();
            return;
        }
        HttpServletRequestImpl requestImpl = servletRequestContext.getOriginalRequest();
        HttpServletResponseImpl responseImpl = servletRequestContext.getOriginalResponse();
        if (!this.servletContext.getDeployment().getDeploymentInfo().isAllowNonStandardWrappers()) {
            if (servletRequestContext.getOriginalRequest() != request && !(request instanceof ServletRequestWrapper)) {
                throw UndertowServletMessages.MESSAGES.requestWasNotOriginalOrWrapper(request);
            }
            if (servletRequestContext.getOriginalResponse() != response && !(response instanceof ServletResponseWrapper)) {
                throw UndertowServletMessages.MESSAGES.responseWasNotOriginalOrWrapper(response);
            }
        }
        ServletRequest oldRequest = servletRequestContext.getServletRequest();
        ServletResponse oldResponse = servletRequestContext.getServletResponse();
        servletRequestContext.setDispatcherType(DispatcherType.ERROR);
        requestImpl.setAttribute("javax.servlet.error.request_uri", requestImpl.getRequestURI());
        requestImpl.setAttribute("javax.servlet.error.servlet_name", servletName);
        if (exception != null) {
            requestImpl.setAttribute("javax.servlet.error.exception", exception);
            requestImpl.setAttribute("javax.servlet.error.exception_type", exception.getClass());
        }
        requestImpl.setAttribute("javax.servlet.error.message", message);
        requestImpl.setAttribute("javax.servlet.error.status_code", responseImpl.getStatus());
        String newQueryString = "";
        int qsPos = this.path.indexOf("?");
        String newServletPath = this.path;
        if (qsPos != -1) {
            newQueryString = newServletPath.substring(qsPos + 1);
            newServletPath = newServletPath.substring(0, qsPos);
        }
        String newRequestUri = this.servletContext.getContextPath() + newServletPath;
        HashMap<String, Deque<String>> newQueryParameters = new HashMap<String, Deque<String>>();
        String[] arr$ = newQueryString.split("&");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ArrayDeque<String> queue;
            String part;
            String name = part = arr$[i$];
            String value = "";
            int equals = part.indexOf(61);
            if (equals != -1) {
                name = part.substring(0, equals);
                value = part.substring(equals + 1);
            }
            if ((queue = (ArrayDeque<String>)newQueryParameters.get(name)) == null) {
                queue = new ArrayDeque<String>(1);
                newQueryParameters.put(name, queue);
            }
            queue.add(value);
        }
        requestImpl.setQueryParameters(newQueryParameters);
        requestImpl.getExchange().setRelativePath(newServletPath);
        requestImpl.getExchange().setQueryString(newQueryString);
        requestImpl.getExchange().setRequestPath(newRequestUri);
        requestImpl.getExchange().setRequestURI(newRequestUri);
        ((ServletRequestContext)requestImpl.getExchange().getAttachment(ServletRequestContext.ATTACHMENT_KEY)).setServletPathMatch(this.pathMatch);
        requestImpl.setServletContext(this.servletContext);
        responseImpl.setServletContext(this.servletContext);
        try {
            try {
                servletRequestContext.setServletRequest(request);
                servletRequestContext.setServletResponse(response);
                this.servletContext.getDeployment().getServletDispatcher().dispatchToPath(requestImpl.getExchange(), this.pathMatch, DispatcherType.ERROR);
            }
            catch (ServletException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            AsyncContextImpl ac = servletRequestContext.getOriginalRequest().getAsyncContextInternal();
            if (ac != null) {
                ac.complete();
            }
            servletRequestContext.setServletRequest(oldRequest);
            servletRequestContext.setServletResponse(oldResponse);
        }
    }

    public void mock(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw UndertowServletMessages.MESSAGES.invalidRequestResponseType(request, response);
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        this.servletContext.getDeployment().getServletDispatcher().dispatchMockRequest(req, resp);
    }
}

