/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.spec.AsyncContextImpl;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.channels.Channels;
import org.xnio.channels.EmptyStreamSourceChannel;
import org.xnio.channels.StreamSourceChannel;

public class ServletInputStreamImpl
extends ServletInputStream {
    private final HttpServletRequestImpl request;
    private final StreamSourceChannel channel;
    private final ByteBufferPool bufferPool;
    private volatile ReadListener listener;
    private volatile ServletInputStreamChannelListener internalListener;
    private static final int FLAG_READY = 1;
    private static final int FLAG_CLOSED = 2;
    private static final int FLAG_FINISHED = 4;
    private static final int FLAG_ON_DATA_READ_CALLED = 8;
    private static final int FLAG_CALL_ON_ALL_DATA_READ = 16;
    private static final int FLAG_BEING_INVOKED_IN_IO_THREAD = 32;
    private static final int FLAG_IS_READY_CALLED = 64;
    private volatile int state;
    private volatile AsyncContextImpl asyncContext;
    private volatile PooledByteBuffer pooled;
    private static final AtomicIntegerFieldUpdater<ServletInputStreamImpl> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(ServletInputStreamImpl.class, "state");

    public ServletInputStreamImpl(HttpServletRequestImpl request) {
        this.request = request;
        this.channel = request.getExchange().isRequestChannelAvailable() ? request.getExchange().getRequestChannel() : new EmptyStreamSourceChannel(request.getExchange().getIoThread());
        this.bufferPool = request.getExchange().getConnection().getByteBufferPool();
    }

    public boolean isFinished() {
        return Bits.anyAreSet((int)this.state, (int)4);
    }

    public boolean isReady() {
        boolean ready;
        boolean finished = Bits.anyAreSet((int)this.state, (int)4);
        if (finished && Bits.anyAreClear((int)this.state, (int)8)) {
            if (Bits.allAreClear((int)this.state, (int)32)) {
                this.setFlags(8);
                this.request.getServletContext().invokeOnAllDataRead(this.request.getExchange(), this.listener);
            } else {
                this.setFlags(16);
            }
        }
        boolean bl = ready = Bits.anyAreSet((int)this.state, (int)1) && !finished;
        if (!ready && this.listener != null && !finished) {
            this.channel.resumeReads();
        }
        if (ready) {
            this.setFlags(64);
        }
        return ready;
    }

    public void setReadListener(ReadListener readListener) {
        if (readListener == null) {
            throw UndertowServletMessages.MESSAGES.listenerCannotBeNull();
        }
        if (this.listener != null) {
            throw UndertowServletMessages.MESSAGES.listenerAlreadySet();
        }
        if (!this.request.isAsyncStarted()) {
            throw UndertowServletMessages.MESSAGES.asyncNotStarted();
        }
        this.asyncContext = this.request.getAsyncContext();
        this.listener = readListener;
        this.internalListener = new ServletInputStreamChannelListener();
        this.channel.getReadSetter().set((ChannelListener)this.internalListener);
        this.asyncContext.addAsyncTask(new Runnable(){

            @Override
            public void run() {
                ServletInputStreamImpl.this.channel.getIoThread().execute(new Runnable(){

                    @Override
                    public void run() {
                        ServletInputStreamImpl.this.internalListener.handleEvent(ServletInputStreamImpl.this.channel);
                    }
                });
            }
        });
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b);
        if (read == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw UndertowServletMessages.MESSAGES.streamIsClosed();
        }
        if (this.listener != null) {
            if (Bits.anyAreClear((int)this.state, (int)65)) {
                throw UndertowServletMessages.MESSAGES.streamNotReady();
            }
            this.clearFlags(64);
        } else {
            this.readIntoBuffer();
        }
        if (Bits.anyAreSet((int)this.state, (int)4)) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        ByteBuffer buffer = this.pooled.getBuffer();
        int copied = Buffers.copy((ByteBuffer)ByteBuffer.wrap(b, off, len), (ByteBuffer)buffer);
        if (!buffer.hasRemaining()) {
            this.pooled.close();
            this.pooled = null;
            if (this.listener != null) {
                this.readIntoBufferNonBlocking();
            }
        }
        return copied;
    }

    private void readIntoBuffer() throws IOException {
        if (this.pooled == null && !Bits.anyAreSet((int)this.state, (int)4)) {
            this.pooled = this.bufferPool.allocate();
            int res = Channels.readBlocking((ReadableByteChannel)this.channel, (ByteBuffer)this.pooled.getBuffer());
            this.pooled.getBuffer().flip();
            if (res == -1) {
                this.setFlags(4);
                this.pooled.close();
                this.pooled = null;
            }
        }
    }

    private void readIntoBufferNonBlocking() throws IOException {
        if (this.pooled == null && !Bits.anyAreSet((int)this.state, (int)4)) {
            this.pooled = this.bufferPool.allocate();
            if (this.listener == null) {
                int res = this.channel.read(this.pooled.getBuffer());
                if (res == 0) {
                    this.pooled.close();
                    this.pooled = null;
                    return;
                }
                this.pooled.getBuffer().flip();
                if (res == -1) {
                    this.setFlags(4);
                    this.pooled.close();
                    this.pooled = null;
                }
            } else {
                int res = this.channel.read(this.pooled.getBuffer());
                this.pooled.getBuffer().flip();
                if (res == -1) {
                    this.setFlags(4);
                    this.pooled.close();
                    this.pooled = null;
                } else if (res == 0) {
                    this.clearFlags(1);
                    this.pooled.close();
                    this.pooled = null;
                }
            }
        }
    }

    public int available() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw UndertowServletMessages.MESSAGES.streamIsClosed();
        }
        this.readIntoBufferNonBlocking();
        if (Bits.anyAreSet((int)this.state, (int)4)) {
            return 0;
        }
        if (this.pooled == null) {
            return 0;
        }
        return this.pooled.getBuffer().remaining();
    }

    public void close() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            return;
        }
        this.setFlags(2);
        try {
            while (Bits.allAreClear((int)this.state, (int)4)) {
                this.readIntoBuffer();
                if (this.pooled == null) continue;
                this.pooled.close();
                this.pooled = null;
            }
        }
        finally {
            this.setFlags(4);
            if (this.pooled != null) {
                this.pooled.close();
                this.pooled = null;
            }
            this.channel.shutdownReads();
        }
    }

    private void setFlags(int flags) {
        int old;
        while (!stateUpdater.compareAndSet(this, old = this.state, old | flags)) {
        }
    }

    private void clearFlags(int flags) {
        int old;
        while (!stateUpdater.compareAndSet(this, old = this.state, old & ~flags)) {
        }
    }

    private class ServletInputStreamChannelListener
    implements ChannelListener<StreamSourceChannel> {
        private ServletInputStreamChannelListener() {
        }

        public void handleEvent(StreamSourceChannel channel) {
            block12: {
                if (ServletInputStreamImpl.this.asyncContext.isDispatched()) {
                    channel.suspendReads();
                    return;
                }
                if (Bits.anyAreSet((int)ServletInputStreamImpl.this.state, (int)4)) {
                    channel.suspendReads();
                    return;
                }
                try {
                    ServletInputStreamImpl.this.readIntoBufferNonBlocking();
                    if (ServletInputStreamImpl.this.pooled != null) {
                        channel.suspendReads();
                        ServletInputStreamImpl.this.setFlags(1);
                        if (Bits.anyAreSet((int)ServletInputStreamImpl.this.state, (int)4)) break block12;
                        ServletInputStreamImpl.this.setFlags(32);
                        try {
                            ServletInputStreamImpl.this.request.getServletContext().invokeOnDataAvailable(ServletInputStreamImpl.this.request.getExchange(), ServletInputStreamImpl.this.listener);
                        }
                        finally {
                            ServletInputStreamImpl.this.clearFlags(32);
                        }
                        if (Bits.anyAreSet((int)ServletInputStreamImpl.this.state, (int)16) && Bits.allAreClear((int)ServletInputStreamImpl.this.state, (int)8)) {
                            ServletInputStreamImpl.this.setFlags(8);
                            ServletInputStreamImpl.this.request.getServletContext().invokeOnAllDataRead(ServletInputStreamImpl.this.request.getExchange(), ServletInputStreamImpl.this.listener);
                        }
                        break block12;
                    }
                    if (Bits.anyAreSet((int)ServletInputStreamImpl.this.state, (int)4)) {
                        if (Bits.allAreClear((int)ServletInputStreamImpl.this.state, (int)8)) {
                            ServletInputStreamImpl.this.setFlags(8);
                            ServletInputStreamImpl.this.request.getServletContext().invokeOnAllDataRead(ServletInputStreamImpl.this.request.getExchange(), ServletInputStreamImpl.this.listener);
                        }
                    } else {
                        channel.resumeReads();
                    }
                }
                catch (IOException | RuntimeException e) {
                    ServletInputStreamImpl.this.request.getServletContext().invokeRunnable(ServletInputStreamImpl.this.request.getExchange(), new Runnable(){

                        @Override
                        public void run() {
                            ServletInputStreamImpl.this.listener.onError((Throwable)e);
                        }
                    });
                    IoUtils.safeClose((Closeable)channel);
                }
            }
        }
    }
}

