/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.servlet.core.ManagedServlet;
import java.util.concurrent.Executor;
import javax.servlet.http.MappingMatch;

public class ServletChain {
    private final HttpHandler handler;
    private final ManagedServlet managedServlet;
    private final String servletPath;
    private final Executor executor;
    private final boolean defaultServletMapping;
    private final MappingMatch mappingMatch;
    private final String pattern;

    public ServletChain(HttpHandler handler, ManagedServlet managedServlet, String servletPath, boolean defaultServletMapping, MappingMatch mappingMatch, String pattern) {
        this.handler = handler;
        this.managedServlet = managedServlet;
        this.servletPath = servletPath;
        this.defaultServletMapping = defaultServletMapping;
        this.mappingMatch = mappingMatch;
        this.pattern = pattern;
        this.executor = managedServlet.getServletInfo().getExecutor();
    }

    public ServletChain(ServletChain other, String pattern, MappingMatch mappingMatch) {
        this(other.getHandler(), other.getManagedServlet(), other.getServletPath(), other.isDefaultServletMapping(), mappingMatch, pattern);
    }

    public HttpHandler getHandler() {
        return this.handler;
    }

    public ManagedServlet getManagedServlet() {
        return this.managedServlet;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public boolean isDefaultServletMapping() {
        return this.defaultServletMapping;
    }

    public MappingMatch getMappingMatch() {
        return this.mappingMatch;
    }

    public String getPattern() {
        return this.pattern;
    }
}

