/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.ext.dropwizard.Match;
import io.vertx.ext.dropwizard.impl.HttpMetricsImpl;
import io.vertx.ext.dropwizard.impl.Matcher;
import io.vertx.ext.dropwizard.impl.RequestMetric;
import io.vertx.ext.dropwizard.impl.WebSocketMetric;
import java.util.List;

class HttpServerMetricsImpl
extends HttpMetricsImpl
implements HttpServerMetrics<RequestMetric, WebSocketMetric, Timer.Context> {
    private final Matcher uriMatcher;

    HttpServerMetricsImpl(MetricRegistry registry, String baseName, List<Match> monitoredUris, SocketAddress localAddress) {
        super(registry, baseName, localAddress);
        this.uriMatcher = new Matcher(monitoredUris);
    }

    public RequestMetric requestBegin(Timer.Context socketMetric, HttpServerRequest request) {
        return this.createRequestMetric(request.method(), request.uri());
    }

    public WebSocketMetric upgrade(RequestMetric requestMetric, ServerWebSocket serverWebSocket) {
        return this.createWebSocketMetric();
    }

    public void responseEnd(RequestMetric requestMetric, HttpServerResponse response) {
        this.end(requestMetric, response.getStatusCode(), requestMetric.uri != null && this.uriMatcher.match(requestMetric.uri));
    }

    public WebSocketMetric connected(Timer.Context socketMetric, ServerWebSocket serverWebSocket) {
        return this.createWebSocketMetric();
    }

    public void disconnected(WebSocketMetric serverWebSocketMetric) {
        this.disconnect(serverWebSocketMetric);
    }
}

