/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Timer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.WebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.ext.dropwizard.Match;
import io.vertx.ext.dropwizard.impl.AbstractMetrics;
import io.vertx.ext.dropwizard.impl.EndpointMetric;
import io.vertx.ext.dropwizard.impl.HttpClientReporter;
import io.vertx.ext.dropwizard.impl.HttpClientRequestMetric;
import io.vertx.ext.dropwizard.impl.Matcher;
import io.vertx.ext.dropwizard.impl.VertxMetricsImpl;
import io.vertx.ext.dropwizard.impl.WebSocketMetric;
import java.util.List;
import java.util.concurrent.TimeUnit;

class HttpClientMetricsImpl
extends AbstractMetrics
implements HttpClientMetrics<HttpClientRequestMetric, WebSocketMetric, Long, EndpointMetric, Timer.Context> {
    private final VertxMetricsImpl owner;
    private final Matcher uriMatcher;
    private final Matcher endpointMatcher;
    final HttpClientReporter clientReporter;
    final int maxPoolSize;

    HttpClientMetricsImpl(VertxMetricsImpl owner, HttpClientReporter clientReporter, HttpClientOptions options, List<Match> monitoredUris, List<Match> monitoredEndpoints) {
        super(clientReporter.registry, clientReporter.baseName);
        this.owner = owner;
        this.clientReporter = clientReporter;
        this.uriMatcher = new Matcher(monitoredUris);
        this.endpointMatcher = new Matcher(monitoredEndpoints);
        this.maxPoolSize = options.getMaxPoolSize();
        clientReporter.incMaxPoolSize(this.maxPoolSize);
    }

    public EndpointMetric createEndpoint(String host, int port, int maxPoolSize) {
        String name = host + ":" + port;
        if (this.endpointMatcher.match(name)) {
            return new EndpointMetric(this.clientReporter, name);
        }
        return null;
    }

    public void closeEndpoint(String host, int port, EndpointMetric endpointMetric) {
    }

    public Timer.Context enqueueRequest(EndpointMetric endpointMetric) {
        if (endpointMetric != null) {
            endpointMetric.queueSize.inc();
            return endpointMetric.queueDelay.time();
        }
        return null;
    }

    public void dequeueRequest(EndpointMetric endpointMetric, Timer.Context taskMetric) {
        if (endpointMetric != null) {
            endpointMetric.queueSize.dec();
            taskMetric.stop();
        }
    }

    public void endpointConnected(EndpointMetric endpointMetric, Long socketMetric) {
        if (endpointMetric != null) {
            endpointMetric.openConnections.inc();
        }
    }

    public void endpointDisconnected(EndpointMetric endpointMetric, Long socketMetric) {
        if (endpointMetric != null) {
            endpointMetric.openConnections.dec();
        }
    }

    public HttpClientRequestMetric requestBegin(EndpointMetric endpointMetric, Long socketMetric, SocketAddress localAddress, SocketAddress remoteAddress, HttpClientRequest request) {
        if (endpointMetric != null) {
            endpointMetric.inUse.inc();
        }
        return new HttpClientRequestMetric(endpointMetric, request.method(), request.uri());
    }

    public void requestEnd(HttpClientRequestMetric requestMetric) {
        requestMetric.requestEnd = System.nanoTime();
    }

    public void responseBegin(HttpClientRequestMetric requestMetric, HttpClientResponse response) {
        long waitTime = System.nanoTime() - requestMetric.requestEnd;
        if (requestMetric.endpointMetric != null) {
            requestMetric.endpointMetric.ttfb.update(waitTime, TimeUnit.NANOSECONDS);
        }
    }

    public HttpClientRequestMetric responsePushed(EndpointMetric endpointMetric, Long socketMetric, SocketAddress localAddress, SocketAddress remoteAddress, HttpClientRequest request) {
        if (endpointMetric != null) {
            endpointMetric.inUse.inc();
        }
        return this.requestBegin(endpointMetric, socketMetric, localAddress, remoteAddress, request);
    }

    public void requestReset(HttpClientRequestMetric requestMetric) {
        long duration = this.clientReporter.end(requestMetric, 0, requestMetric.uri != null && this.uriMatcher.match(requestMetric.uri));
        if (requestMetric.endpointMetric != null) {
            requestMetric.endpointMetric.inUse.dec();
            requestMetric.endpointMetric.usage.update(duration, TimeUnit.NANOSECONDS);
        }
    }

    public void responseEnd(HttpClientRequestMetric requestMetric, HttpClientResponse response) {
        long duration = this.clientReporter.end(requestMetric, response.statusCode(), requestMetric.uri != null && this.uriMatcher.match(requestMetric.uri));
        if (requestMetric.endpointMetric != null) {
            requestMetric.endpointMetric.inUse.dec();
            requestMetric.endpointMetric.usage.update(duration, TimeUnit.NANOSECONDS);
        }
    }

    public WebSocketMetric connected(EndpointMetric endpointMetric, Long socketMetric, WebSocket webSocket) {
        return this.clientReporter.createWebSocketMetric();
    }

    public void disconnected(WebSocketMetric webSocketMetric) {
        this.clientReporter.disconnect(webSocketMetric);
    }

    public Long connected(SocketAddress remoteAddress, String remoteName) {
        return this.clientReporter.connected(remoteAddress, remoteName);
    }

    public void disconnected(Long socketMetric, SocketAddress remoteAddress) {
        this.clientReporter.disconnected(socketMetric, remoteAddress);
    }

    public void bytesRead(Long socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.clientReporter.bytesRead(socketMetric, remoteAddress, numberOfBytes);
    }

    public void bytesWritten(Long socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.clientReporter.bytesWritten(socketMetric, remoteAddress, numberOfBytes);
    }

    public void exceptionOccurred(Long socketMetric, SocketAddress remoteAddress, Throwable t) {
        this.clientReporter.exceptionOccurred(socketMetric, remoteAddress, t);
    }

    @Override
    public boolean isEnabled() {
        return this.clientReporter.isEnabled();
    }

    public void close() {
        this.owner.closed(this);
    }
}

