/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.cluster.infinispan;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.spi.cluster.AsyncMultiMap;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.ext.cluster.infinispan.impl.InfinispanAsyncMapImpl;
import io.vertx.ext.cluster.infinispan.impl.InfinispanAsyncMultiMap;
import io.vertx.ext.cluster.infinispan.impl.JGroupsCounter;
import io.vertx.ext.cluster.infinispan.impl.JGroupsLock;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.commons.api.BasicCacheContainer;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.MergeEvent;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.jgroups.JChannel;
import org.jgroups.blocks.atomic.CounterService;
import org.jgroups.blocks.locking.LockService;
import org.jgroups.fork.ForkChannel;
import org.jgroups.protocols.CENTRAL_LOCK;
import org.jgroups.protocols.COUNTER;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;

public class InfinispanClusterManager
implements ClusterManager {
    private static final Logger log = LoggerFactory.getLogger(InfinispanClusterManager.class);
    private static final String VERTX_INFINISPAN_CONFIG_PROP_NAME = "vertx.infinispan.config";
    private static final String INFINISPAN_XML = "infinispan.xml";
    private static final String DEFAULT_INFINISPAN_XML = "default-infinispan.xml";
    private static final String VERTX_JGROUPS_CONFIG_PROP_NAME = "vertx.jgroups.config";
    private static final String JGROUPS_XML = "jgroups.xml";
    private final String ispnConfigPath;
    private final String jgroupsConfigPath;
    private final boolean userProvidedCacheManager;
    private Vertx vertx;
    private DefaultCacheManager cacheManager;
    private NodeListener nodeListener;
    private CounterService counterService;
    private LockService lockService;
    private volatile boolean active;
    private ClusterViewListener viewListener;
    private Set<InfinispanAsyncMultiMap> multimaps = Collections.newSetFromMap(new WeakHashMap(1));
    private ForkChannel forkChannel;

    public InfinispanClusterManager() {
        this.ispnConfigPath = System.getProperty(VERTX_INFINISPAN_CONFIG_PROP_NAME, INFINISPAN_XML);
        this.jgroupsConfigPath = System.getProperty(VERTX_JGROUPS_CONFIG_PROP_NAME, JGROUPS_XML);
        this.userProvidedCacheManager = false;
    }

    public InfinispanClusterManager(DefaultCacheManager cacheManager) {
        Objects.requireNonNull(cacheManager, "cacheManager");
        this.cacheManager = cacheManager;
        this.ispnConfigPath = null;
        this.jgroupsConfigPath = null;
        this.userProvidedCacheManager = true;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public BasicCacheContainer getCacheContainer() {
        return this.cacheManager;
    }

    public <K, V> void getAsyncMultiMap(String name, Handler<AsyncResult<AsyncMultiMap<K, V>>> resultHandler) {
        this.vertx.executeBlocking(future -> {
            Cache cache = this.cacheManager.getCache(name);
            InfinispanAsyncMultiMap asyncMultiMap = new InfinispanAsyncMultiMap(this.vertx, (Cache<InfinispanAsyncMultiMap.MultiMapKey, Object>)cache);
            InfinispanClusterManager infinispanClusterManager = this;
            synchronized (infinispanClusterManager) {
                this.multimaps.add(asyncMultiMap);
            }
            future.complete(asyncMultiMap);
        }, false, resultHandler);
    }

    public <K, V> void getAsyncMap(String name, Handler<AsyncResult<AsyncMap<K, V>>> resultHandler) {
        this.vertx.executeBlocking(future -> {
            Cache cache = this.cacheManager.getCache(name);
            future.complete(new InfinispanAsyncMapImpl(this.vertx, (Cache<Object, Object>)cache));
        }, false, resultHandler);
    }

    public <K, V> Map<K, V> getSyncMap(String name) {
        return this.cacheManager.getCache(name);
    }

    public void getLockWithTimeout(String name, long timeout, Handler<AsyncResult<Lock>> resultHandler) {
        ContextImpl context = (ContextImpl)this.vertx.getOrCreateContext();
        context.executeBlocking(() -> {
            java.util.concurrent.locks.Lock lock = this.lockService.getLock(name);
            try {
                if (lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
                    return new JGroupsLock(this.vertx, lock);
                }
                throw new VertxException("Timed out waiting to get lock " + name);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new VertxException((Throwable)e);
            }
        }, resultHandler);
    }

    public void getCounter(String name, Handler<AsyncResult<Counter>> resultHandler) {
        this.vertx.executeBlocking(future -> future.complete((Object)new JGroupsCounter(this.vertx, this.counterService.getOrCreateCounter(name, 0L))), false, resultHandler);
    }

    public String getNodeID() {
        return this.cacheManager.getNodeAddress();
    }

    public List<String> getNodes() {
        return this.cacheManager.getTransport().getMembers().stream().map(Object::toString).collect(Collectors.toList());
    }

    public synchronized void nodeListener(NodeListener nodeListener) {
        this.nodeListener = nodeListener;
    }

    public void join(Handler<AsyncResult<Void>> resultHandler) {
        this.vertx.executeBlocking(future -> {
            if (this.active) {
                future.complete();
                return;
            }
            this.active = true;
            if (!this.userProvidedCacheManager) {
                InputStream ispnConfigStream = null;
                try {
                    FileLookup fileLookup = FileLookupFactory.newInstance();
                    ispnConfigStream = fileLookup.lookupFile(this.ispnConfigPath, this.getCTCCL());
                    if (ispnConfigStream == null) {
                        log.warn((Object)("Cannot find Infinispan config '" + this.ispnConfigPath + "', using default"));
                        ispnConfigStream = fileLookup.lookupFileStrict(DEFAULT_INFINISPAN_XML, this.getCTCCL());
                    }
                    ConfigurationBuilderHolder builderHolder = new ParserRegistry().parse(ispnConfigStream);
                    ClassLoader classLoader = this.getCTCCL();
                    if (classLoader == null) {
                        classLoader = this.getClass().getClassLoader();
                    }
                    builderHolder.getGlobalConfigurationBuilder().classLoader(classLoader);
                    if (fileLookup.lookupFileLocation(this.jgroupsConfigPath, this.getCTCCL()) != null) {
                        log.warn((Object)("Forcing JGroups config to '" + this.jgroupsConfigPath + "'"));
                        builderHolder.getGlobalConfigurationBuilder().transport().defaultTransport().addProperty("configurationFile", this.jgroupsConfigPath);
                    }
                    this.cacheManager = new DefaultCacheManager(builderHolder, true);
                    this.safeClose(ispnConfigStream);
                }
                catch (IOException e) {
                    try {
                        future.fail((Throwable)e);
                        this.safeClose(ispnConfigStream);
                        return;
                    }
                    catch (Throwable throwable) {
                        this.safeClose(ispnConfigStream);
                        throw throwable;
                    }
                }
            }
            this.viewListener = new ClusterViewListener();
            this.cacheManager.addListener((Object)this.viewListener);
            JGroupsTransport transport = (JGroupsTransport)this.cacheManager.getTransport();
            JChannel channel = transport.getChannel();
            CENTRAL_LOCK centralLock = new CENTRAL_LOCK();
            centralLock.setValue("use_thread_id_for_lock_owner", (Object)Boolean.FALSE);
            centralLock.setBypassBundling(true);
            COUNTER counter = new COUNTER();
            counter.setBypassBundling(true);
            Protocol[] protocols = new Protocol[]{centralLock, counter};
            Class<?> topProtocol = channel.getProtocolStack().getTopProtocol().getClass();
            try {
                this.forkChannel = new ForkChannel(channel, "vertx-infinispan-stack", "vertx-infinispan-channel", true, ProtocolStack.Position.ABOVE, topProtocol, protocols);
                this.forkChannel.connect("ignored");
                this.counterService = new CounterService((JChannel)this.forkChannel);
                this.lockService = new LockService((JChannel)this.forkChannel);
                future.complete();
            }
            catch (Exception e) {
                future.fail((Throwable)e);
            }
        }, false, resultHandler);
    }

    private ClassLoader getCTCCL() {
        return Thread.currentThread().getContextClassLoader();
    }

    private void safeClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void leave(Handler<AsyncResult<Void>> resultHandler) {
        this.vertx.executeBlocking(future -> {
            if (!this.active) {
                future.complete();
                return;
            }
            this.active = false;
            this.forkChannel.close();
            this.cacheManager.removeListener((Object)this.viewListener);
            if (!this.userProvidedCacheManager) {
                this.cacheManager.stop();
            }
            future.complete();
        }, false, resultHandler);
    }

    public boolean isActive() {
        return this.active;
    }

    @Listener(sync=false)
    private class ClusterViewListener {
        private ClusterViewListener() {
        }

        @ViewChanged
        public void handleViewChange(ViewChangedEvent e) {
            this.handleViewChangeInternal(e);
        }

        @Merged
        public void handleMerge(MergeEvent e) {
            this.handleViewChangeInternal((ViewChangedEvent)e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleViewChangeInternal(ViewChangedEvent e) {
            InfinispanClusterManager infinispanClusterManager = InfinispanClusterManager.this;
            synchronized (infinispanClusterManager) {
                if (!InfinispanClusterManager.this.active) {
                    return;
                }
                InfinispanClusterManager.this.multimaps.forEach(InfinispanAsyncMultiMap::clearCache);
                ArrayList added = new ArrayList(e.getNewMembers());
                added.removeAll(e.getOldMembers());
                log.debug((Object)("Members added = " + added));
                added.forEach(address -> {
                    if (InfinispanClusterManager.this.nodeListener != null) {
                        InfinispanClusterManager.this.nodeListener.nodeAdded(address.toString());
                    }
                });
                ArrayList removed = new ArrayList(e.getOldMembers());
                removed.removeAll(e.getNewMembers());
                log.debug((Object)("Members removed = " + removed));
                removed.forEach(address -> {
                    if (InfinispanClusterManager.this.nodeListener != null) {
                        InfinispanClusterManager.this.nodeListener.nodeLeft(address.toString());
                    }
                });
            }
        }
    }
}

