/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Shareable;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.jdbc.impl.JDBCConnectionImpl;
import io.vertx.ext.jdbc.spi.DataSourceProvider;
import io.vertx.ext.sql.SQLConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class JDBCClientImpl
implements JDBCClient {
    private static final String DS_LOCAL_MAP_NAME = "__vertx.JDBCClient.datasources";
    private final Vertx vertx;
    private final DataSourceHolder holder;
    private final ExecutorService exec;
    private final DataSource ds;

    public JDBCClientImpl(Vertx vertx, DataSource dataSource) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(dataSource);
        this.vertx = vertx;
        this.holder = new DataSourceHolder(dataSource);
        this.exec = this.holder.exec();
        this.ds = dataSource;
    }

    public JDBCClientImpl(Vertx vertx, JsonObject config, String datasourceName) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(config);
        Objects.requireNonNull(datasourceName);
        this.vertx = vertx;
        this.holder = this.lookupHolder(datasourceName, config);
        this.exec = this.holder.exec();
        this.ds = this.holder.ds();
    }

    @Override
    public void close() {
        this.holder.close();
    }

    @Override
    public JDBCClient getConnection(Handler<AsyncResult<SQLConnection>> handler) {
        Context ctx = this.vertx.getOrCreateContext();
        this.exec.execute(() -> {
            Future res = Future.future();
            try {
                Connection conn = this.ds.getConnection();
                JDBCConnectionImpl sconn = new JDBCConnectionImpl(this.vertx, conn);
                res.complete((Object)sconn);
            }
            catch (SQLException e) {
                res.fail((Throwable)e);
            }
            ctx.runOnContext(v -> res.setHandler(handler));
        });
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSourceHolder lookupHolder(String datasourceName, JsonObject config) {
        Vertx vertx = this.vertx;
        synchronized (vertx) {
            LocalMap map = this.vertx.sharedData().getLocalMap(DS_LOCAL_MAP_NAME);
            DataSourceHolder theHolder = (DataSourceHolder)map.get((Object)datasourceName);
            if (theHolder == null) {
                theHolder = new DataSourceHolder(config, () -> this.removeFromMap((LocalMap<String, DataSourceHolder>)map, datasourceName));
                map.put((Object)datasourceName, (Object)theHolder);
            } else {
                theHolder.incRefCount();
            }
            return theHolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromMap(LocalMap<String, DataSourceHolder> map, String dataSourceName) {
        Vertx vertx = this.vertx;
        synchronized (vertx) {
            map.remove((Object)dataSourceName);
            if (map.isEmpty()) {
                map.close();
            }
        }
    }

    private class DataSourceHolder
    implements Shareable {
        DataSourceProvider provider;
        JsonObject config;
        Runnable closeRunner;
        DataSource ds;
        ExecutorService exec;
        int refCount = 1;

        public DataSourceHolder(DataSource ds) {
            this.ds = ds;
        }

        public DataSourceHolder(JsonObject config, Runnable closeRunner) {
            this.config = config;
            this.closeRunner = closeRunner;
        }

        synchronized DataSource ds() {
            if (this.ds == null) {
                String providerClass = this.config.getString("provider_class");
                if (providerClass == null) {
                    providerClass = "io.vertx.ext.jdbc.spi.impl.C3P0DataSourceProvider";
                }
                if (Thread.currentThread().getContextClassLoader() != null) {
                    try {
                        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(providerClass);
                        this.provider = (DataSourceProvider)clazz.newInstance();
                        this.ds = this.provider.getDataSource(this.config);
                        return this.ds;
                    }
                    catch (ClassNotFoundException clazz) {
                    }
                    catch (IllegalAccessException | InstantiationException | SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    Class<?> clazz = this.getClass().getClassLoader().loadClass(providerClass);
                    this.provider = (DataSourceProvider)clazz.newInstance();
                    this.ds = this.provider.getDataSource(this.config);
                    return this.ds;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.ds;
        }

        synchronized ExecutorService exec() {
            if (this.exec == null) {
                this.exec = new ThreadPoolExecutor(1, 1, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> new Thread(r, "vertx-jdbc-service-get-connection-thread"));
            }
            return this.exec;
        }

        synchronized void incRefCount() {
            ++this.refCount;
        }

        synchronized void close() {
            if (--this.refCount == 0) {
                if (this.provider != null) {
                    JDBCClientImpl.this.vertx.executeBlocking(future -> {
                        try {
                            this.provider.close(this.ds);
                            future.complete();
                        }
                        catch (SQLException e) {
                            future.fail((Throwable)e);
                        }
                    }, null);
                }
                if (this.exec != null) {
                    this.exec.shutdown();
                }
                if (this.closeRunner != null) {
                    this.closeRunner.run();
                }
            }
        }
    }
}

