/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class AbstractJDBCAction<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractJDBCAction.class);
    protected final Vertx vertx;
    protected final Connection conn;
    protected final Context context;

    protected AbstractJDBCAction(Vertx vertx, Connection conn, Context context) {
        this.vertx = vertx;
        this.conn = conn;
        this.context = context;
    }

    public void handle(Future<T> future) {
        try {
            T result = this.execute(this.conn);
            future.complete(result);
        }
        catch (SQLException e) {
            future.fail((Throwable)e);
        }
    }

    public void execute(Handler<AsyncResult<T>> resultHandler) {
        Future f = Future.future();
        Context callbackContext = this.vertx.getOrCreateContext();
        this.context.runOnContext(v -> {
            f.setHandler(ar -> callbackContext.runOnContext(v2 -> resultHandler.handle(ar)));
            this.handle(f);
        });
    }

    protected abstract T execute(Connection var1) throws SQLException;

    protected abstract String name();
}

