/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.ResultSet;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;

public class JDBCCallable
extends AbstractJDBCAction<ResultSet> {
    private final String sql;
    private final JsonArray in;
    private final JsonArray out;

    public JDBCCallable(Vertx vertx, Connection connection, Context context, String sql, JsonArray in, JsonArray out) {
        super(vertx, connection, context);
        this.sql = sql;
        this.in = in;
        this.out = out;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ResultSet execute(Connection conn) throws SQLException {
        try (CallableStatement statement = conn.prepareCall(this.sql);){
            boolean outResult;
            JDBCStatementHelper.fillStatement(statement, this.in, this.out);
            boolean retResult = statement.execute();
            boolean bl = outResult = this.out != null && this.out.size() > 0;
            if (retResult) {
                try (java.sql.ResultSet rs = statement.getResultSet();){
                    if (outResult) {
                        ResultSet resultSet = JDBCStatementHelper.asList(rs).setOutput(this.convertOutputs(statement));
                        return resultSet;
                    }
                    ResultSet resultSet = JDBCStatementHelper.asList(rs);
                    return resultSet;
                }
            }
            if (outResult) return new ResultSet(Collections.emptyList(), Collections.emptyList()).setOutput(this.convertOutputs(statement));
            ResultSet resultSet = null;
            return resultSet;
        }
    }

    private JsonArray convertOutputs(CallableStatement statement) throws SQLException {
        JsonArray result = new JsonArray();
        for (int i = 0; i < this.out.size(); ++i) {
            Object var = this.out.getValue(i);
            if (var != null) {
                Object value = statement.getObject(i + 1);
                if (value == null) {
                    result.addNull();
                    continue;
                }
                if (value instanceof java.sql.ResultSet) {
                    result.add((Object)JDBCStatementHelper.asList((java.sql.ResultSet)value));
                    continue;
                }
                result.add(JDBCStatementHelper.convertSqlValue(value));
                continue;
            }
            result.addNull();
        }
        return result;
    }

    @Override
    protected String name() {
        return "callable";
    }
}

