/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.ResultSet;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;

final class JDBCStatementHelper {
    private static final JsonArray EMPTY = new JsonArray(Collections.unmodifiableList(new ArrayList()));

    private JDBCStatementHelper() {
    }

    public static void fillStatement(PreparedStatement statement, JsonArray in) throws SQLException {
        if (in == null) {
            in = EMPTY;
        }
        for (int i = 0; i < in.size(); ++i) {
            Object value = in.getValue(i);
            if (value != null) {
                statement.setObject(i + 1, in.getValue(i));
                continue;
            }
            statement.setNull(i + 1, 0);
        }
    }

    public static void fillStatement(CallableStatement statement, JsonArray in, JsonArray out) throws SQLException {
        if (in == null) {
            in = EMPTY;
        }
        if (out == null) {
            out = EMPTY;
        }
        int max = Math.max(in.size(), out.size());
        for (int i = 0; i < max; ++i) {
            Object value = null;
            if (i < in.size()) {
                value = in.getValue(i);
            }
            if (value != null) {
                statement.setObject(i + 1, value);
                continue;
            }
            if (i < out.size()) {
                value = out.getValue(i);
            }
            if (value != null) {
                statement.registerOutParameter(i + 1, (int)JDBCType.valueOf((String)value).getVendorTypeNumber());
                continue;
            }
            statement.setNull(i + 1, 0);
        }
    }

    public static ResultSet asList(java.sql.ResultSet rs) throws SQLException {
        ArrayList<String> columnNames = new ArrayList<String>();
        ResultSetMetaData metaData = rs.getMetaData();
        int cols = metaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            columnNames.add(metaData.getColumnLabel(i));
        }
        ArrayList<JsonArray> results = new ArrayList<JsonArray>();
        while (rs.next()) {
            JsonArray result = new JsonArray();
            for (int i = 1; i <= cols; ++i) {
                Object res = JDBCStatementHelper.convertSqlValue(rs.getObject(i));
                if (res != null) {
                    result.add(res);
                    continue;
                }
                result.addNull();
            }
            results.add(result);
        }
        return new ResultSet(columnNames, results);
    }

    public static Object convertSqlValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean || value instanceof String || value instanceof byte[]) {
            return value;
        }
        if (value instanceof Number) {
            if (value instanceof BigDecimal) {
                BigDecimal d = (BigDecimal)value;
                if (d.scale() == 0) {
                    return ((BigDecimal)value).toBigInteger();
                }
                return ((BigDecimal)value).doubleValue();
            }
            return value;
        }
        if (value instanceof Date || value instanceof Time || value instanceof Timestamp) {
            return OffsetDateTime.ofInstant(Instant.ofEpochMilli(((java.util.Date)value).getTime()), ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        if (value instanceof Clob) {
            Clob c = (Clob)value;
            try {
                String tmp = c.getSubString(1L, (int)c.length());
                c.free();
                return tmp;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (value instanceof Blob) {
            Blob b = (Blob)value;
            try {
                byte[] tmp = b.getBytes(1L, (int)b.length());
                b.free();
                return tmp;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (value instanceof Array) {
            Array a = (Array)value;
            try {
                Object[] arr = (Object[])a.getArray();
                if (arr != null) {
                    JsonArray jsonArray = new JsonArray();
                    for (Object o : arr) {
                        jsonArray.add(JDBCStatementHelper.convertSqlValue(o));
                    }
                    a.free();
                    return jsonArray;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return value.toString();
    }
}

