/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.UpdateResult;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class JDBCUpdate
extends AbstractJDBCAction<UpdateResult> {
    private final String sql;
    private final JsonArray in;

    public JDBCUpdate(Vertx vertx, Connection connection, Context context, String sql, JsonArray in) {
        super(vertx, connection, context);
        this.sql = sql;
        this.in = in;
    }

    @Override
    protected UpdateResult execute(Connection conn) throws SQLException {
        try (PreparedStatement statement = conn.prepareStatement(this.sql, 1);){
            JDBCStatementHelper.fillStatement(statement, this.in);
            int updated = statement.executeUpdate();
            JsonArray keys = new JsonArray();
            try (ResultSet rs = statement.getGeneratedKeys();){
                if (rs != null) {
                    while (rs.next()) {
                        Object key = rs.getObject(1);
                        if (key == null) continue;
                        keys.add(JDBCStatementHelper.convertSqlValue(key));
                    }
                }
            }
            UpdateResult updateResult = new UpdateResult(updated, keys);
            return updateResult;
        }
    }

    @Override
    protected String name() {
        return "update";
    }
}

