/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.ResultSet;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;

public class JDBCCallable
extends AbstractJDBCAction<ResultSet> {
    private final String sql;
    private final JsonArray in;
    private final JsonArray out;
    private final int timeout;

    public JDBCCallable(Vertx vertx, JDBCStatementHelper helper, Connection connection, WorkerExecutor exec, int timeout, String sql, JsonArray in, JsonArray out) {
        super(vertx, helper, connection, exec);
        this.sql = sql;
        this.in = in;
        this.out = out;
        this.timeout = timeout;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ResultSet execute() throws SQLException {
        try (CallableStatement statement = this.conn.prepareCall(this.sql);){
            boolean outResult;
            if (this.timeout >= 0) {
                statement.setQueryTimeout(this.timeout);
            }
            this.helper.fillStatement(statement, this.in, this.out);
            boolean retResult = statement.execute();
            boolean bl = outResult = this.out != null && this.out.size() > 0;
            if (retResult) {
                try (java.sql.ResultSet rs = statement.getResultSet();){
                    if (outResult) {
                        ResultSet resultSet = this.helper.asList(rs).setOutput(this.convertOutputs(statement));
                        return resultSet;
                    }
                    ResultSet resultSet = this.helper.asList(rs);
                    return resultSet;
                }
            }
            if (outResult) return new ResultSet(Collections.emptyList(), Collections.emptyList()).setOutput(this.convertOutputs(statement));
            ResultSet resultSet = null;
            return resultSet;
        }
    }

    private JsonArray convertOutputs(CallableStatement statement) throws SQLException {
        JsonArray result = new JsonArray();
        for (int i = 0; i < this.out.size(); ++i) {
            Object var = this.out.getValue(i);
            if (var != null) {
                Object value = statement.getObject(i + 1);
                if (value == null) {
                    result.addNull();
                    continue;
                }
                if (value instanceof java.sql.ResultSet) {
                    result.add((Object)this.helper.asList((java.sql.ResultSet)value));
                    continue;
                }
                result.add(this.helper.convertSqlValue(value));
                continue;
            }
            result.addNull();
        }
        return result;
    }

    @Override
    protected String name() {
        return "callable";
    }
}

