/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.ServerMode;
import io.vertx.oracleclient.impl.Helper;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import oracle.jdbc.datasource.OracleDataSource;

public class OracleDatabaseHelper {
    public static OracleDataSource createDataSource(OracleConnectOptions options) {
        OracleDataSource oracleDataSource = (OracleDataSource)Helper.getOrHandleSQLException(oracle.jdbc.pool.OracleDataSource::new);
        Helper.runOrHandleSQLException(() -> oracleDataSource.setURL(OracleDatabaseHelper.composeJdbcUrl(options)));
        OracleDatabaseHelper.configureStandardOptions(oracleDataSource, options);
        OracleDatabaseHelper.configureExtendedOptions(oracleDataSource, options);
        OracleDatabaseHelper.configureJdbcDefaults(oracleDataSource);
        return oracleDataSource;
    }

    private static String composeJdbcUrl(OracleConnectOptions options) {
        String serviceId;
        String host;
        StringBuilder url = new StringBuilder("jdbc:oracle:thin:@");
        String tnsAlias = options.getTnsAlias();
        if (tnsAlias != null) {
            return url.append(tnsAlias).toString();
        }
        if (options.isSsl()) {
            url.append("tcps://");
        }
        if ((host = options.getHost()).indexOf(58) >= 0) {
            url.append("[").append(host).append("]");
        } else {
            url.append(OracleDatabaseHelper.encodeUrl(host));
        }
        int port = options.getPort();
        if (port > 0) {
            url.append(":").append(port);
        }
        if ((serviceId = options.getServiceId()) != null) {
            url.append(":").append(OracleDatabaseHelper.encodeUrl(serviceId));
        } else {
            String database = Optional.ofNullable(options.getServiceName()).orElse(options.getDatabase());
            if (database != null) {
                url.append("/").append(OracleDatabaseHelper.encodeUrl(database));
                if (options.getServerMode() == ServerMode.SHARED) {
                    url.append(":").append((Object)ServerMode.SHARED);
                }
            }
        }
        return url.toString();
    }

    private static void configureStandardOptions(OracleDataSource oracleDataSource, OracleConnectOptions options) {
        int connectTimeout;
        String password;
        String user;
        Map<String, String> properties = options.getProperties();
        if (properties != null && !properties.isEmpty()) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                Helper.runOrHandleSQLException(() -> oracleDataSource.setConnectionProperty((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        if ((user = options.getUser()) != null) {
            Helper.runOrHandleSQLException(() -> oracleDataSource.setUser(user));
        }
        if ((password = options.getPassword()) != null) {
            Helper.runOrHandleSQLException(() -> oracleDataSource.setPassword(password.toString()));
        }
        if ((connectTimeout = options.getConnectTimeout()) > 0) {
            Helper.runOrHandleSQLException(() -> oracleDataSource.setLoginTimeout(connectTimeout));
        }
    }

    private static void configureExtendedOptions(OracleDataSource oracleDataSource, OracleConnectOptions options) {
        String tnsAdmin = options.getTnsAdmin();
        if (tnsAdmin != null) {
            Helper.runOrHandleSQLException(() -> oracleDataSource.setConnectionProperty("oracle.net.tns_admin", tnsAdmin));
        }
    }

    private static void configureJdbcDefaults(OracleDataSource oracleDataSource) {
        String enableJdbcSpecCompliance = "oracle.jdbc.J2EE13Compliant";
        Helper.runOrHandleSQLException(() -> oracleDataSource.setConnectionProperty(enableJdbcSpecCompliance, "true"));
        Helper.runOrHandleSQLException(() -> {
            String userValue = oracleDataSource.getConnectionProperty("oracle.jdbc.implicitStatementCacheSize");
            if (userValue == null) {
                oracleDataSource.setConnectionProperty("oracle.jdbc.implicitStatementCacheSize", "25");
            }
        });
    }

    private static String encodeUrl(String url) {
        return URLEncoder.encode(url, StandardCharsets.UTF_8);
    }
}

