/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetSocket;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonHelper;
import io.vertx.proton.ProtonLinkOptions;
import io.vertx.proton.ProtonReceiver;
import io.vertx.proton.ProtonSender;
import io.vertx.proton.ProtonSession;
import io.vertx.proton.ProtonTransportOptions;
import io.vertx.proton.impl.ProtonMetaDataSupportImpl;
import io.vertx.proton.impl.ProtonReceiverImpl;
import io.vertx.proton.impl.ProtonSaslClientAuthenticatorImpl;
import io.vertx.proton.impl.ProtonSenderImpl;
import io.vertx.proton.impl.ProtonSessionImpl;
import io.vertx.proton.impl.ProtonTransport;
import io.vertx.proton.sasl.ProtonSaslAuthenticator;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Record;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;

public class ProtonConnectionImpl
implements ProtonConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ProtonConnectionImpl.class);
    public static final Symbol ANONYMOUS_RELAY = Symbol.valueOf((String)"ANONYMOUS-RELAY");
    private final Connection connection = Proton.connection();
    private final Vertx vertx;
    private ProtonTransport transport;
    private Handler<AsyncResult<ProtonConnection>> openHandler = result -> LOG.trace((Object)"Connection open completed");
    private Handler<AsyncResult<ProtonConnection>> closeHandler = result -> {
        if (result.succeeded()) {
            LOG.trace((Object)"Connection closed");
        } else {
            LOG.warn((Object)"Connection closed with error", result.cause());
        }
    };
    private Handler<ProtonConnection> disconnectHandler = connection -> LOG.trace((Object)"Connection disconnected");
    private Handler<ProtonSession> sessionOpenHandler = session -> session.setCondition(new ErrorCondition(Symbol.getSymbol((String)"Not Supported"), ""));
    private Handler<ProtonSender> senderOpenHandler = sender -> sender.setCondition(new ErrorCondition(Symbol.getSymbol((String)"Not Supported"), ""));
    private Handler<ProtonReceiver> receiverOpenHandler = receiver -> receiver.setCondition(new ErrorCondition(Symbol.getSymbol((String)"Not Supported"), ""));
    private boolean anonymousRelaySupported;
    private ProtonSession defaultSession;

    ProtonConnectionImpl(Vertx vertx, String hostname) {
        this.vertx = vertx;
        this.connection.setContext((Object)this);
        this.connection.setContainer("vert.x-" + UUID.randomUUID());
        this.connection.setHostname(hostname);
        LinkedHashMap<Symbol, Object> props = this.createInitialPropertiesMap();
        this.connection.setProperties(props);
    }

    private LinkedHashMap<Symbol, Object> createInitialPropertiesMap() {
        LinkedHashMap<Symbol, Object> props = new LinkedHashMap<Symbol, Object>();
        props.put(ProtonMetaDataSupportImpl.PRODUCT_KEY, "vertx-proton");
        props.put(ProtonMetaDataSupportImpl.VERSION_KEY, ProtonMetaDataSupportImpl.VERSION);
        return props;
    }

    @Override
    public ProtonConnectionImpl setProperties(Map<Symbol, Object> properties) {
        LinkedHashMap<Symbol, Object> newProps = null;
        if (properties != null) {
            newProps = this.createInitialPropertiesMap();
            newProps.putAll(properties);
        }
        this.connection.setProperties(newProps);
        return this;
    }

    public ProtonConnectionImpl setOfferedCapabilities(Symbol[] capabilities) {
        this.connection.setOfferedCapabilities(capabilities);
        return this;
    }

    @Override
    public ProtonConnectionImpl setHostname(String hostname) {
        this.connection.setHostname(hostname);
        return this;
    }

    public ProtonConnectionImpl setDesiredCapabilities(Symbol[] capabilities) {
        this.connection.setDesiredCapabilities(capabilities);
        return this;
    }

    @Override
    public ProtonConnectionImpl setContainer(String container) {
        this.connection.setContainer(container);
        return this;
    }

    @Override
    public ProtonConnectionImpl setCondition(ErrorCondition condition) {
        this.connection.setCondition(condition);
        return this;
    }

    @Override
    public ErrorCondition getCondition() {
        return this.connection.getCondition();
    }

    @Override
    public String getContainer() {
        return this.connection.getContainer();
    }

    @Override
    public String getHostname() {
        return this.connection.getHostname();
    }

    public EndpointState getLocalState() {
        return this.connection.getLocalState();
    }

    @Override
    public ErrorCondition getRemoteCondition() {
        return this.connection.getRemoteCondition();
    }

    @Override
    public String getRemoteContainer() {
        return this.connection.getRemoteContainer();
    }

    public Symbol[] getRemoteDesiredCapabilities() {
        return this.connection.getRemoteDesiredCapabilities();
    }

    @Override
    public String getRemoteHostname() {
        return this.connection.getRemoteHostname();
    }

    public Symbol[] getRemoteOfferedCapabilities() {
        return this.connection.getRemoteOfferedCapabilities();
    }

    @Override
    public Map<Symbol, Object> getRemoteProperties() {
        return this.connection.getRemoteProperties();
    }

    public EndpointState getRemoteState() {
        return this.connection.getRemoteState();
    }

    @Override
    public boolean isAnonymousRelaySupported() {
        return this.anonymousRelaySupported;
    }

    @Override
    public Record attachments() {
        return this.connection.attachments();
    }

    @Override
    public ProtonConnection open() {
        this.connection.open();
        this.flush();
        return this;
    }

    @Override
    public ProtonConnection close() {
        this.connection.close();
        this.flush();
        return this;
    }

    @Override
    public ProtonSessionImpl createSession() {
        return new ProtonSessionImpl(this.connection.session());
    }

    private ProtonSession getDefaultSession() {
        if (this.defaultSession == null) {
            this.defaultSession = this.createSession();
            this.defaultSession.closeHandler((Handler<AsyncResult<ProtonSession>>)((Handler)result -> {
                String msg = "The connections default session closed unexpectedly";
                if (!result.succeeded()) {
                    msg = msg + ": ";
                    msg = msg + ": " + String.valueOf(result.cause());
                }
                Future failure = Future.failedFuture((String)msg);
                Handler<AsyncResult<ProtonConnection>> connCloseHandler = this.closeHandler;
                if (connCloseHandler != null) {
                    connCloseHandler.handle((Object)failure);
                }
            }));
            this.defaultSession.open();
        }
        return this.defaultSession;
    }

    @Override
    public ProtonSender createSender(String address) {
        return this.getDefaultSession().createSender(address);
    }

    @Override
    public ProtonSender createSender(String address, ProtonLinkOptions senderOptions) {
        return this.getDefaultSession().createSender(address, senderOptions);
    }

    @Override
    public ProtonReceiver createReceiver(String address) {
        return this.getDefaultSession().createReceiver(address);
    }

    @Override
    public ProtonReceiver createReceiver(String address, ProtonLinkOptions receiverOptions) {
        return this.getDefaultSession().createReceiver(address, receiverOptions);
    }

    public void flush() {
        if (this.transport != null) {
            this.transport.flush();
        }
    }

    @Override
    public void disconnect() {
        if (this.transport != null) {
            this.transport.disconnect();
        }
    }

    @Override
    public boolean isDisconnected() {
        return this.transport == null;
    }

    @Override
    public ProtonConnection openHandler(Handler<AsyncResult<ProtonConnection>> openHandler) {
        this.openHandler = openHandler;
        return this;
    }

    @Override
    public ProtonConnection closeHandler(Handler<AsyncResult<ProtonConnection>> closeHandler) {
        this.closeHandler = closeHandler;
        return this;
    }

    @Override
    public ProtonConnection disconnectHandler(Handler<ProtonConnection> disconnectHandler) {
        this.disconnectHandler = disconnectHandler;
        return this;
    }

    @Override
    public ProtonConnection sessionOpenHandler(Handler<ProtonSession> remoteSessionOpenHandler) {
        this.sessionOpenHandler = remoteSessionOpenHandler;
        return this;
    }

    @Override
    public ProtonConnection senderOpenHandler(Handler<ProtonSender> remoteSenderOpenHandler) {
        this.senderOpenHandler = remoteSenderOpenHandler;
        return this;
    }

    @Override
    public ProtonConnection receiverOpenHandler(Handler<ProtonReceiver> remoteReceiverOpenHandler) {
        this.receiverOpenHandler = remoteReceiverOpenHandler;
        return this;
    }

    private void processCapabilities() {
        List<Symbol> list;
        Symbol[] capabilities = this.getRemoteOfferedCapabilities();
        if (capabilities != null && (list = Arrays.asList(capabilities)).contains(ANONYMOUS_RELAY)) {
            this.anonymousRelaySupported = true;
        }
    }

    void fireRemoteOpen() {
        this.processCapabilities();
        if (this.openHandler != null) {
            this.openHandler.handle(ProtonHelper.future(this, this.getRemoteCondition()));
        }
    }

    void fireRemoteClose() {
        if (this.closeHandler != null) {
            this.closeHandler.handle(ProtonHelper.future(this, this.getRemoteCondition()));
        }
    }

    public void fireDisconnect() {
        this.transport = null;
        if (this.disconnectHandler != null) {
            this.disconnectHandler.handle((Object)this);
        }
    }

    void bindClient(NetClient client, NetSocket socket, ProtonSaslClientAuthenticatorImpl authenticator, ProtonTransportOptions transportOptions) {
        this.transport = new ProtonTransport(this.connection, this.vertx, client, socket, authenticator, transportOptions);
    }

    void bindServer(NetSocket socket, ProtonSaslAuthenticator authenticator, ProtonTransportOptions transportOptions) {
        this.transport = new ProtonTransport(this.connection, this.vertx, null, socket, authenticator, transportOptions);
    }

    void fireRemoteSessionOpen(Session session) {
        if (this.sessionOpenHandler != null) {
            this.sessionOpenHandler.handle((Object)new ProtonSessionImpl(session));
        }
    }

    void fireRemoteLinkOpen(Link link) {
        if (link instanceof Sender) {
            if (this.senderOpenHandler != null) {
                this.senderOpenHandler.handle((Object)new ProtonSenderImpl((Sender)link));
            }
        } else if (this.receiverOpenHandler != null) {
            this.receiverOpenHandler.handle((Object)new ProtonReceiverImpl((Receiver)link));
        }
    }
}

