/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.net.NetSocket;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.sasl.ProtonSaslAuthenticator;
import io.vertx.proton.sasl.ProtonSaslMechanism;
import io.vertx.proton.sasl.impl.ProtonSaslMechanismFinderImpl;
import java.util.Set;
import javax.security.sasl.SaslException;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Transport;

public class ProtonSaslClientAuthenticatorImpl
implements ProtonSaslAuthenticator {
    private Sasl sasl;
    private final String username;
    private final String password;
    private ProtonSaslMechanism mechanism;
    private Set<String> mechanismsRestriction;
    private Handler<AsyncResult<ProtonConnection>> handler;
    private NetSocket socket;
    private ProtonConnection connection;
    private boolean succeeded;

    public ProtonSaslClientAuthenticatorImpl(String username, String password, Set<String> allowedSaslMechanisms, Handler<AsyncResult<ProtonConnection>> handler) {
        this.handler = handler;
        this.username = username;
        this.password = password;
        this.mechanismsRestriction = allowedSaslMechanisms;
    }

    @Override
    public void init(NetSocket socket, ProtonConnection protonConnection, Transport transport) {
        this.socket = socket;
        this.connection = protonConnection;
        this.sasl = transport.sasl();
        this.sasl.client();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Handler<Boolean> completionHandler) {
        if (this.sasl == null) {
            throw new IllegalStateException("Init was not called with the associated transport");
        }
        boolean done = false;
        this.succeeded = false;
        try {
            switch (this.sasl.getState()) {
                case PN_SASL_IDLE: {
                    this.handleSaslInit();
                    break;
                }
                case PN_SASL_STEP: {
                    this.handleSaslStep();
                    break;
                }
                case PN_SASL_FAIL: {
                    done = true;
                    this.handler.handle((Object)Future.failedFuture((Throwable)new SecurityException("Failed to authenticate")));
                    break;
                }
                case PN_SASL_PASS: {
                    done = true;
                    this.succeeded = true;
                    this.handler.handle((Object)Future.succeededFuture((Object)this.connection));
                    break;
                }
            }
        }
        catch (Exception e) {
            done = true;
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            finally {
                this.handler.handle((Object)Future.failedFuture((Throwable)e));
            }
        }
        completionHandler.handle((Object)done);
    }

    @Override
    public boolean succeeded() {
        return this.succeeded;
    }

    private void handleSaslInit() throws SecurityException {
        block4: {
            try {
                String[] remoteMechanisms = this.sasl.getRemoteMechanisms();
                if (remoteMechanisms == null || remoteMechanisms.length == 0) break block4;
                this.mechanism = ProtonSaslMechanismFinderImpl.findMatchingMechanism(this.username, this.password, this.mechanismsRestriction, remoteMechanisms);
                if (this.mechanism != null) {
                    this.mechanism.setUsername(this.username);
                    this.mechanism.setPassword(this.password);
                    this.sasl.setMechanisms(new String[]{this.mechanism.getName()});
                    byte[] response = this.mechanism.getInitialResponse();
                    if (response != null) {
                        this.sasl.send(response, 0, response.length);
                    }
                    break block4;
                }
                throw new SecurityException("Could not find a suitable SASL mechanism for the remote peer using the available credentials.");
            }
            catch (SaslException se) {
                throw new SecurityException("Exception while processing SASL init.", se);
            }
        }
    }

    private void handleSaslStep() throws SecurityException {
        try {
            if (this.sasl.pending() != 0) {
                byte[] challenge = new byte[this.sasl.pending()];
                this.sasl.recv(challenge, 0, challenge.length);
                byte[] response = this.mechanism.getChallengeResponse(challenge);
                this.sasl.send(response, 0, response.length);
            }
        }
        catch (SaslException se) {
            throw new SecurityException("Exception while processing SASL step.", se);
        }
    }
}

