/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonServer;
import io.vertx.proton.ProtonServerOptions;
import io.vertx.proton.ProtonTransportOptions;
import io.vertx.proton.impl.ProtonConnectionImpl;
import io.vertx.proton.impl.ProtonSaslServerAuthenticatorImpl;
import io.vertx.proton.sasl.ProtonSaslAuthenticator;
import io.vertx.proton.sasl.ProtonSaslAuthenticatorFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.engine.Transport;

public class ProtonServerImpl
implements ProtonServer {
    private final Vertx vertx;
    private final NetServer server;
    private Handler<ProtonConnection> handler;
    private ProtonSaslAuthenticatorFactory authenticatorFactory = new DefaultAuthenticatorFactory();
    private boolean advertiseAnonymousRelayCapability = true;
    private ProtonServerOptions options;

    public ProtonServerImpl(Vertx vertx) {
        this.vertx = vertx;
        this.server = this.vertx.createNetServer();
        this.options = new ProtonServerOptions();
    }

    public ProtonServerImpl(Vertx vertx, ProtonServerOptions options) {
        this.vertx = vertx;
        this.server = this.vertx.createNetServer((NetServerOptions)options);
        this.options = options;
    }

    @Override
    public int actualPort() {
        return this.server.actualPort();
    }

    @Override
    public ProtonServerImpl listen(int i) {
        this.server.listen(i);
        return this;
    }

    @Override
    public ProtonServerImpl listen() {
        this.server.listen();
        return this;
    }

    public boolean isMetricsEnabled() {
        return this.server.isMetricsEnabled();
    }

    @Override
    public ProtonServerImpl listen(int port, String host, Handler<AsyncResult<ProtonServer>> handler) {
        this.server.listen(port, host, this.convertHandler(handler));
        return this;
    }

    @Override
    public ProtonServerImpl listen(Handler<AsyncResult<ProtonServer>> handler) {
        this.server.listen(this.convertHandler(handler));
        return this;
    }

    private Handler<AsyncResult<NetServer>> convertHandler(Handler<AsyncResult<ProtonServer>> handler) {
        return result -> {
            if (result.succeeded()) {
                handler.handle((Object)Future.succeededFuture((Object)this));
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)result.cause()));
            }
        };
    }

    @Override
    public ProtonServerImpl listen(int i, String s) {
        this.server.listen(i, s);
        return this;
    }

    @Override
    public ProtonServerImpl listen(int i, Handler<AsyncResult<ProtonServer>> handler) {
        this.server.listen(i, this.convertHandler(handler));
        return this;
    }

    @Override
    public void close() {
        this.server.close();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.server.close(handler);
    }

    @Override
    public Handler<ProtonConnection> connectHandler() {
        return this.handler;
    }

    @Override
    public ProtonServer saslAuthenticatorFactory(ProtonSaslAuthenticatorFactory authenticatorFactory) {
        this.authenticatorFactory = authenticatorFactory == null ? new DefaultAuthenticatorFactory() : authenticatorFactory;
        return this;
    }

    @Override
    public ProtonServerImpl connectHandler(final Handler<ProtonConnection> handler) {
        this.handler = handler;
        this.server.connectHandler(netSocket -> {
            String hostname = null;
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            final ProtonConnectionImpl connection = new ProtonConnectionImpl(this.vertx, hostname);
            if (this.advertiseAnonymousRelayCapability) {
                connection.setOfferedCapabilities(new Symbol[]{ProtonConnectionImpl.ANONYMOUS_RELAY});
            }
            final ProtonSaslAuthenticator authenticator = this.authenticatorFactory.create();
            ProtonTransportOptions transportOptions = new ProtonTransportOptions();
            transportOptions.setHeartbeat(this.options.getHeartbeat());
            connection.bindServer((NetSocket)netSocket, new ProtonSaslAuthenticator(){

                @Override
                public void init(NetSocket socket, ProtonConnection protonConnection, Transport transport) {
                    authenticator.init(socket, protonConnection, transport);
                }

                @Override
                public void process(Handler<Boolean> completionHandler) {
                    Context context = Vertx.currentContext();
                    authenticator.process((Handler<Boolean>)((Handler)complete -> {
                        Context callbackContext = ProtonServerImpl.this.vertx.getOrCreateContext();
                        if (context != callbackContext) {
                            throw new IllegalStateException("Callback was not made on the original context");
                        }
                        if (complete.booleanValue()) {
                            if (this.succeeded()) {
                                handler.handle((Object)connection);
                                connection.flush();
                            } else {
                                connection.flush();
                                connection.disconnect();
                            }
                        }
                        completionHandler.handle(complete);
                    }));
                }

                @Override
                public boolean succeeded() {
                    return authenticator.succeeded();
                }
            }, transportOptions);
        });
        return this;
    }

    public void setAdvertiseAnonymousRelayCapability(boolean advertiseAnonymousRelayCapability) {
        this.advertiseAnonymousRelayCapability = advertiseAnonymousRelayCapability;
    }

    private static class DefaultAuthenticatorFactory
    implements ProtonSaslAuthenticatorFactory {
        private DefaultAuthenticatorFactory() {
        }

        @Override
        public ProtonSaslAuthenticator create() {
            return new ProtonSaslServerAuthenticatorImpl();
        }
    }
}

