/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rabbitmq;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.rabbitmq.QueueOptions;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;

public class QueueOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, QueueOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "autoAck": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setAutoAck((Boolean)member.getValue());
                    break;
                }
                case "consumerArguments": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof Object) {
                            map.put((String)entry.getKey(), entry.getValue());
                        }
                    });
                    obj.setConsumerArguments(map);
                    break;
                }
                case "consumerExclusive": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setConsumerExclusive((Boolean)member.getValue());
                    break;
                }
                case "consumerTag": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setConsumerTag((String)member.getValue());
                    break;
                }
                case "keepMostRecent": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setKeepMostRecent((Boolean)member.getValue());
                    break;
                }
                case "maxInternalQueueSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxInternalQueueSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "noLocal": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setNoLocal((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(QueueOptions obj, JsonObject json) {
        QueueOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(QueueOptions obj, Map<String, Object> json) {
        json.put("autoAck", obj.isAutoAck());
        if (obj.getConsumerArguments() != null) {
            JsonObject map = new JsonObject();
            obj.getConsumerArguments().forEach((key, value) -> map.put(key, value));
            json.put("consumerArguments", map);
        }
        json.put("consumerExclusive", obj.isConsumerExclusive());
        if (obj.getConsumerTag() != null) {
            json.put("consumerTag", obj.getConsumerTag());
        }
        json.put("keepMostRecent", obj.isKeepMostRecent());
        json.put("noLocal", obj.isNoLocal());
    }
}

